/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.util;

import com.massivecraft.massivecore.MassiveCore;
import com.massivecraft.massivecore.store.Coll;
import com.massivecraft.massivecore.store.Entity;
import com.massivecraft.massivecore.util.IdUtil;
import com.massivecraft.massivecore.util.MUtil;
import com.massivecraft.massivecore.util.Txt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class IdUpdateUtil {
    public static String update(String string, boolean force) {
        if (string == null) {
            return null;
        }
        String ret = IdUtil.getId(string);
        if (ret != null) {
            return ret;
        }
        if (!force) {
            return string;
        }
        return null;
    }

    public static void update(Collection<String> from, Collection<String> to, boolean force) {
        for (String string : from) {
            if ((string = IdUpdateUtil.update(string, force)) == null) continue;
            to.add(string);
        }
    }

    public static List<String> update(List<String> strings, boolean force) {
        ArrayList<String> ret = new ArrayList<String>();
        IdUpdateUtil.update(strings, ret, force);
        return ret;
    }

    public static Set<String> update(Set<String> strings, boolean force) {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        IdUpdateUtil.update(strings, ret, force);
        return ret;
    }

    public static <E extends Entity<E>> void update(Coll<E> coll) {
        IdUpdateUtil.update(coll, false);
    }

    public static <E extends Entity<E>> void update(Coll<E> coll, boolean force) {
        long pre = System.currentTimeMillis();
        MassiveCore.get().log(Txt.parse("<i>Pre update <h>%s<i>.", coll.getName()));
        int countTotal = coll.getAll().size();
        int countUpdate = 0;
        for (Entity entity : coll.getAll()) {
            if (!IdUpdateUtil.update(coll, entity, force)) continue;
            ++countUpdate;
        }
        long post = System.currentTimeMillis();
        long delta = post - pre;
        MassiveCore.get().log(Txt.parse("<i>Post update <h>%s<i>. Took <h>%dms<i>. <h>%d/%d <i>changed.", coll.getName(), delta, countUpdate, countTotal));
    }

    public static <E extends Entity<E>> boolean update(Coll<E> coll, E entity, boolean force) {
        String before = coll.getId(entity);
        if (before == null) {
            return false;
        }
        String after = IdUpdateUtil.update(before, force);
        if (after == null && !force) {
            return false;
        }
        if (MUtil.equals(before, after)) {
            return false;
        }
        coll.detachEntity(entity);
        if (after == null) {
            return true;
        }
        coll.attach(entity, after);
        coll.syncId(after);
        return true;
    }
}

