/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.util;

import com.massivecraft.massivecore.MassiveCore;
import com.massivecraft.massivecore.event.EventMassiveCorePlayerLeave;
import com.massivecraft.massivecore.event.EventMassiveCoreSenderRegister;
import com.massivecraft.massivecore.event.EventMassiveCoreSenderUnregister;
import com.massivecraft.massivecore.fetcher.Fetcher;
import com.massivecraft.massivecore.fetcher.IdAndName;
import com.massivecraft.massivecore.mixin.Mixin;
import com.massivecraft.massivecore.store.Coll;
import com.massivecraft.massivecore.store.SenderColl;
import com.massivecraft.massivecore.store.SenderEntity;
import com.massivecraft.massivecore.util.DiscUtil;
import com.massivecraft.massivecore.util.IdData;
import com.massivecraft.massivecore.util.MUtil;
import com.massivecraft.massivecore.util.Txt;
import com.massivecraft.massivecore.xlib.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.plugin.Plugin;

public class IdUtil
implements Listener,
Runnable {
    private static IdUtil i = new IdUtil();
    public static final String IDPREFIX = "@";
    public static final String CONSOLE_ID = "@console";
    public static final IdData CONSOLE_DATA = new IdData("@console", "@console");
    private static final Object CACHEFILE_LOCK = new Object();
    public static final File CACHEFILE = new File(MassiveCore.get().getDataFolder(), "idnamecache.json");
    public static final File CACHEFILE_TEMP = new File(MassiveCore.get().getDataFolder(), "idnamecache.json.temp");
    public static final Type CACHEFILE_TYPE = new TypeToken<Set<IdData>>(){}.getType();
    private static Set<IdData> datas = Collections.newSetFromMap(new ConcurrentHashMap());
    private static Map<String, IdData> idToData = new ConcurrentSkipListMap<String, IdData>(String.CASE_INSENSITIVE_ORDER);
    private static Map<String, IdData> nameToData = new ConcurrentSkipListMap<String, IdData>(String.CASE_INSENSITIVE_ORDER);
    private static Set<String> onlineIds = new ConcurrentSkipListSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static Set<String> onlineNames = new ConcurrentSkipListSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static Set<String> allIds = new ConcurrentSkipListSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static Set<String> allNames = new ConcurrentSkipListSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static Map<String, CommandSender> registryIdToSender = new ConcurrentHashMap<String, CommandSender>();
    private static Map<CommandSender, String> registrySenderToId = new ConcurrentHashMap<CommandSender, String>();

    public static IdUtil get() {
        return i;
    }

    public static Set<IdData> getDatas() {
        return datas;
    }

    public static Map<String, IdData> getIdToData() {
        return idToData;
    }

    public static Map<String, IdData> getNameToData() {
        return nameToData;
    }

    public static Set<String> getOnlineIds() {
        return Collections.unmodifiableSet(onlineIds);
    }

    public static Set<String> getOnlineNames() {
        return Collections.unmodifiableSet(onlineNames);
    }

    public static Set<String> getAllIds() {
        return Collections.unmodifiableSet(allIds);
    }

    public static Set<String> getAllNames() {
        return Collections.unmodifiableSet(allNames);
    }

    public static void register(CommandSender sender) {
        String id;
        if (sender == null) {
            throw new NullPointerException("sender");
        }
        String name = id = IdUtil.getId(sender);
        IdData data = new IdData(id, name);
        registryIdToSender.put(id, sender);
        registrySenderToId.put(sender, id);
        IdUtil.update(id, name, true);
        EventMassiveCoreSenderRegister event = new EventMassiveCoreSenderRegister(sender, data);
        event.run();
    }

    public static void unregister(CommandSender sender) {
        String id;
        if (sender == null) {
            throw new NullPointerException("sender");
        }
        String name = id = IdUtil.getId(sender);
        IdData data = new IdData(id, name);
        CommandSender removed = registryIdToSender.remove(id);
        registrySenderToId.remove(sender);
        if (removed == null) {
            return;
        }
        IdUtil.update(id, name, false);
        EventMassiveCoreSenderUnregister event = new EventMassiveCoreSenderUnregister(sender, data);
        event.run();
    }

    public static Set<CommandSender> getOnlineSenders() {
        LinkedHashSet<CommandSender> ret = new LinkedHashSet<CommandSender>();
        ret.addAll(MUtil.getOnlinePlayers());
        ret.add((CommandSender)IdUtil.getConsole());
        ret.addAll(registryIdToSender.values());
        return ret;
    }

    private static String removeId(String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        onlineIds.remove(id);
        allIds.remove(id);
        IdData data = idToData.remove(id);
        if (data == null) {
            return null;
        }
        datas.remove(data);
        return data.getName();
    }

    private static String removeName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        onlineNames.remove(name);
        allNames.remove(name);
        IdData data = nameToData.remove(name);
        if (data == null) {
            return null;
        }
        datas.remove(data);
        return data.getId();
    }

    private static void addData(IdData data, boolean online) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        String id = data.getId();
        String name = data.getName();
        datas.add(data);
        if (id != null) {
            idToData.put(id, data);
        }
        if (name != null) {
            nameToData.put(name, data);
        }
        if (id != null && name != null) {
            if (online) {
                onlineIds.add(id);
            }
            allIds.add(id);
            if (online) {
                onlineNames.add(name);
            }
            allNames.add(name);
        }
    }

    public static void update(String id, String name) {
        IdUtil.update(id, name, null);
    }

    public static void update(String id, String name, long millis) {
        IdUtil.update(id, name, millis, null);
    }

    public static void update(String id, String name, Boolean online) {
        IdUtil.update(id, name, System.currentTimeMillis(), online);
    }

    public static void update(String id, String name, long millis, Boolean online) {
        Long nameMillis;
        if (id == null && name == null) {
            throw new NullPointerException("Either id or name must be set. They can't both be null.");
        }
        Long previousMillis = null;
        Long idMillis = IdUtil.getMillis(id);
        if (idMillis != null && (previousMillis == null || idMillis < previousMillis)) {
            previousMillis = idMillis;
        }
        if ((nameMillis = IdUtil.getMillis(name)) != null && (previousMillis == null || nameMillis < previousMillis)) {
            previousMillis = nameMillis;
        }
        if (previousMillis != null && previousMillis > millis) {
            return;
        }
        if (online == null) {
            if (id != null) {
                online = onlineIds.contains(id);
            } else if (name != null) {
                online = onlineNames.contains(name);
            }
        }
        String otherId = null;
        String otherName = null;
        if (id != null) {
            otherName = IdUtil.removeId(id);
        }
        if (name != null) {
            otherId = IdUtil.removeName(name);
        }
        if (otherId != null && !otherId.equals(id)) {
            IdUtil.removeId(otherId);
        }
        if (otherName != null && !otherName.equals(name)) {
            IdUtil.removeName(otherName);
        }
        IdData data = new IdData(id, name, millis);
        IdUtil.addData(data, online);
    }

    public static void setup() {
        long start = System.currentTimeMillis();
        datas.clear();
        idToData.clear();
        nameToData.clear();
        onlineIds.clear();
        onlineNames.clear();
        allIds.clear();
        allNames.clear();
        IdUtil.loadDatas();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MassiveCore.get(), new Runnable(){

            @Override
            public void run() {
                IdUtil.register((CommandSender)IdUtil.getConsole());
            }
        });
        long ticks = 1200L;
        Bukkit.getScheduler().scheduleAsyncRepeatingTask((Plugin)MassiveCore.get(), (Runnable)IdUtil.get(), ticks, ticks);
        Bukkit.getPluginManager().registerEvents((Listener)IdUtil.get(), (Plugin)MassiveCore.get());
        long end = System.currentTimeMillis();
        MassiveCore.get().log(Txt.parse("<i>Setup of IdUtil took <h>%d<i>ms.", end - start));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void playerLoginLowest(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        String id = uuid.toString();
        String name = player.getName();
        boolean online = Mixin.isOnline(player);
        IdUtil.update(id, name, online);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void playerJoinLowest(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        String id = uuid.toString();
        String name = player.getName();
        boolean online = true;
        IdUtil.update(id, name, online);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void playerLeaveMonitor(EventMassiveCorePlayerLeave event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        String id = uuid.toString();
        String name = player.getName();
        boolean online = !Mixin.isActualLeave(event);
        IdUtil.update(id, name, online);
    }

    public static IdData getData(Object senderObject) {
        if (senderObject == null) {
            return null;
        }
        if (senderObject instanceof IdData) {
            return (IdData)senderObject;
        }
        if (senderObject instanceof ConsoleCommandSender) {
            return CONSOLE_DATA;
        }
        if (CONSOLE_ID.equals(senderObject)) {
            return CONSOLE_DATA;
        }
        if (senderObject instanceof SenderEntity) {
            SenderEntity senderEntity = (SenderEntity)senderObject;
            return IdUtil.getData(senderEntity.getId());
        }
        if (senderObject instanceof CommandSender || senderObject instanceof UUID) {
            String id = IdUtil.getId(senderObject);
            return IdUtil.getIdToData().get(id);
        }
        if (senderObject instanceof String) {
            IdData ret = IdUtil.getIdToData().get(senderObject);
            if (ret != null) {
                return ret;
            }
            return IdUtil.getNameToData().get(senderObject);
        }
        return null;
    }

    public static ConsoleCommandSender getConsole() {
        return Bukkit.getConsoleSender();
    }

    public static Player getPlayer(Object senderObject) {
        return IdUtil.getAsPlayer(IdUtil.getSender(senderObject));
    }

    public static CommandSender getSender(Object senderObject) {
        if (senderObject == null) {
            return null;
        }
        if (senderObject instanceof CommandSender) {
            return (CommandSender)senderObject;
        }
        if (CONSOLE_ID.equals(senderObject)) {
            return IdUtil.getConsole();
        }
        if (senderObject instanceof SenderEntity) {
            SenderEntity senderEntity = (SenderEntity)senderObject;
            return IdUtil.getSender(senderEntity.getId());
        }
        if (senderObject instanceof UUID) {
            UUID uuid = (UUID)senderObject;
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player != null) {
                return player;
            }
            return registryIdToSender.get(uuid.toString());
        }
        if (senderObject instanceof String) {
            String string = (String)senderObject;
            UUID uuid = IdUtil.uuidFromString(string);
            if (uuid != null) {
                return IdUtil.getSender(uuid);
            }
            CommandSender sender = registryIdToSender.get(string);
            if (sender != null) {
                return sender;
            }
            return Bukkit.getPlayerExact((String)string);
        }
        return null;
    }

    public static UUID getUuid(Object senderObject) {
        String string;
        UUID uuid;
        if (senderObject == null) {
            return null;
        }
        if (senderObject instanceof UUID) {
            return (UUID)senderObject;
        }
        if (senderObject instanceof ConsoleCommandSender) {
            return null;
        }
        if (CONSOLE_ID.equals(senderObject)) {
            return null;
        }
        if (senderObject instanceof SenderEntity) {
            SenderEntity senderEntity = (SenderEntity)senderObject;
            return IdUtil.getUuid(senderEntity.getId());
        }
        if (senderObject instanceof Player) {
            return ((Player)senderObject).getUniqueId();
        }
        if (senderObject instanceof CommandSender) {
            CommandSender sender = (CommandSender)senderObject;
            String id = sender.getName();
            return IdUtil.uuidFromString(id);
        }
        if (senderObject instanceof String && (uuid = IdUtil.uuidFromString(string = (String)senderObject)) != null) {
            return uuid;
        }
        IdData data = IdUtil.getData(senderObject);
        if (data != null) {
            String id = data.getId();
            if (id == null) {
                return null;
            }
            UUID uuid2 = IdUtil.uuidFromString(id);
            return uuid2;
        }
        return null;
    }

    public static String getId(Object senderObject) {
        if (senderObject == null) {
            return null;
        }
        if (senderObject instanceof String && MUtil.isValidUUID((String)senderObject)) {
            return (String)senderObject;
        }
        if (senderObject instanceof ConsoleCommandSender) {
            return CONSOLE_ID;
        }
        if (CONSOLE_ID.equals(senderObject)) {
            return CONSOLE_ID;
        }
        if (senderObject instanceof SenderEntity) {
            SenderEntity senderEntity = (SenderEntity)senderObject;
            return IdUtil.getId(senderEntity.getId());
        }
        if (senderObject instanceof Player) {
            return ((Player)senderObject).getUniqueId().toString();
        }
        if (senderObject instanceof CommandSender) {
            return ((CommandSender)senderObject).getName();
        }
        if (senderObject instanceof UUID) {
            return ((UUID)senderObject).toString();
        }
        IdData data = IdUtil.getData(senderObject);
        if (data != null) {
            return data.getId();
        }
        return null;
    }

    public static String getName(Object senderObject) {
        if (senderObject == null) {
            return null;
        }
        if (senderObject instanceof ConsoleCommandSender) {
            return CONSOLE_ID;
        }
        if (CONSOLE_ID.equals(senderObject)) {
            return CONSOLE_ID;
        }
        if (senderObject instanceof SenderEntity) {
            SenderEntity senderEntity = (SenderEntity)senderObject;
            return IdUtil.getName(senderEntity.getId());
        }
        if (senderObject instanceof CommandSender) {
            return ((CommandSender)senderObject).getName();
        }
        IdData data = IdUtil.getData(senderObject);
        if (data != null) {
            return data.getName();
        }
        if (senderObject instanceof String) {
            return (String)senderObject;
        }
        return null;
    }

    public static boolean isOnline(Object senderObject) {
        if (senderObject == null) {
            return false;
        }
        String id = IdUtil.getId(senderObject);
        if (id == null) {
            return false;
        }
        if (CONSOLE_ID.equals(id)) {
            return true;
        }
        return IdUtil.getOnlineIds().contains(id);
    }

    public static Long getMillis(Object senderObject) {
        IdData data = IdUtil.getData(senderObject);
        if (data == null) {
            return null;
        }
        return data.getMillis();
    }

    public static boolean isPlayerId(String string) {
        return MUtil.isValidPlayerName(string) || MUtil.isValidUUID(string);
    }

    public static boolean isPlayer(Object senderObject) {
        String id = IdUtil.getId(senderObject);
        if (id == null) {
            return false;
        }
        return IdUtil.isPlayerId(id);
    }

    public static boolean isConsoleId(String string) {
        return CONSOLE_ID.equals(string);
    }

    public static boolean isConsole(Object senderObject) {
        String id = IdUtil.getId(senderObject);
        if (id == null) {
            return false;
        }
        return IdUtil.isConsoleId(id);
    }

    public static CommandSender getAsSender(Object object) {
        if (!(object instanceof CommandSender)) {
            return null;
        }
        return (CommandSender)object;
    }

    public static Player getAsPlayer(Object object) {
        if (!(object instanceof Player)) {
            return null;
        }
        return (Player)object;
    }

    public static ConsoleCommandSender getAsConsole(Object object) {
        if (!(object instanceof ConsoleCommandSender)) {
            return null;
        }
        return (ConsoleCommandSender)object;
    }

    public static GameMode getGameMode(Object object, GameMode def) {
        Player player = IdUtil.getPlayer(object);
        if (player == null) {
            return def;
        }
        return player.getGameMode();
    }

    public static boolean isGameMode(Object object, GameMode gm, boolean def) {
        Player player = IdUtil.getPlayer(object);
        if (player == null) {
            return def;
        }
        return player.getGameMode() == gm;
    }

    public static void loadDatas() {
        MassiveCore.get().log(Txt.parse("<i>Loading Cachefile datas..."));
        for (IdData data : IdUtil.getCachefileDatas()) {
            IdUtil.update(data.getId(), data.getName(), data.getMillis(), false);
        }
        MassiveCore.get().log(Txt.parse("<i>Loading Onlineplayer datas..."));
        for (IdData data : IdUtil.getOnlineplayerDatas()) {
            IdUtil.update(data.getId(), data.getName(), data.getMillis(), true);
        }
        MassiveCore.get().log(Txt.parse("<i>Loading Registry datas..."));
        Iterator<Object> iterator = registryIdToSender.keySet().iterator();
        while (iterator.hasNext()) {
            String id;
            String name = id = (String)iterator.next();
            IdUtil.update(id, name, true);
        }
        if (Bukkit.getServer().getOnlineMode()) {
            MassiveCore.get().log(Txt.parse("<i>Loading Dbmojangapi datas..."));
            for (IdData data : IdUtil.getDbmojangapiDatas()) {
                IdUtil.update(data.getId(), data.getName(), data.getMillis());
            }
        } else {
            MassiveCore.get().log(Txt.parse("<i>Skipping Dbmojangapi datas since offline mode..."));
        }
        MassiveCore.get().log(Txt.parse("<i>Saving Cachefile..."));
        IdUtil.saveCachefileDatas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCachefileDatas() {
        Object object = CACHEFILE_LOCK;
        synchronized (object) {
            String content = MassiveCore.gson.toJson(datas, CACHEFILE_TYPE);
            DiscUtil.writeCatch(CACHEFILE_TEMP, content);
            if (!CACHEFILE_TEMP.exists()) {
                return;
            }
            CACHEFILE.delete();
            CACHEFILE_TEMP.renameTo(CACHEFILE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<IdData> getCachefileDatas() {
        Object object = CACHEFILE_LOCK;
        synchronized (object) {
            String content = DiscUtil.readCatch(CACHEFILE);
            if (content == null) {
                return new HashSet<IdData>();
            }
            if ((content = content.trim()).length() == 0) {
                return new HashSet<IdData>();
            }
            Set ret = (Set)MassiveCore.gson.fromJson(content, CACHEFILE_TYPE);
            return ret;
        }
    }

    @Override
    public void run() {
        IdUtil.saveCachefileDatas();
    }

    public static Set<IdData> getOnlineplayerDatas() {
        LinkedHashSet<IdData> ret = new LinkedHashSet<IdData>();
        long millis = System.currentTimeMillis();
        for (Player player : MUtil.getOnlinePlayers()) {
            String id = IdUtil.getId(player);
            if (id == null) {
                throw new NullPointerException("id");
            }
            String name = IdUtil.getName(player);
            if (name == null) {
                throw new NullPointerException("name");
            }
            IdData data = new IdData(id, name, millis);
            ret.add(data);
        }
        return ret;
    }

    public static Set<IdData> getDbmojangapiDatas() {
        LinkedHashSet<IdData> ret = new LinkedHashSet<IdData>();
        TreeSet<String> strings = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Coll<?> coll : Coll.getInstances()) {
            if (!(coll instanceof SenderColl)) continue;
            for (String id : coll.getIds()) {
                if (!MUtil.isValidPlayerName(id)) continue;
                strings.add(id);
            }
        }
        MassiveCore.get().log(Txt.parse("<k>Player Strings Found: <v>%d", strings.size()));
        Iterator iter = strings.iterator();
        int cached = 0;
        while (iter.hasNext()) {
            String string = (String)iter.next();
            if (IdUtil.getData(string) == null) continue;
            ++cached;
            iter.remove();
        }
        MassiveCore.get().log(Txt.parse("<k>Player Strings Cached: <v>%d", cached));
        MassiveCore.get().log(Txt.parse("<k>Player Strings Remaining: <v>%d", strings.size()));
        MassiveCore.get().log(Txt.parse("<i>Now fetching the remaining players from Mojang API ..."));
        Set<IdAndName> idAndNames = null;
        try {
            idAndNames = Fetcher.fetch(strings);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        MassiveCore.get().log(Txt.parse("<i> ... done!"));
        long millis = System.currentTimeMillis();
        for (IdAndName idAndName : idAndNames) {
            String id = null;
            UUID uuid = idAndName.getId();
            if (uuid != null) {
                id = uuid.toString();
            }
            String name = idAndName.getName();
            ret.add(new IdData(id, name, millis));
        }
        return ret;
    }

    public static UUID uuidFromString(String string) {
        try {
            return UUID.fromString(string);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

