/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.util;

import com.massivecraft.massivecore.MassiveCore;
import java.util.AbstractMap;
import java.util.Map;

public class IntervalUtil {
    public static Double parseDouble(String str, Double def) {
        if (str == null) {
            return def;
        }
        try {
            return Double.valueOf(str);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static Integer parseInteger(String str, Integer def) {
        if (str == null) {
            return def;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static boolean isValidInterval(String interval) {
        return interval.matches("^.+to.+$");
    }

    public static Map.Entry<Double, Double> parseDoubleInterval(String interval, Double dmin, Double dmax) {
        String[] parts;
        if (interval == null) {
            return new AbstractMap.SimpleEntry<Double, Double>(dmin, dmax);
        }
        if (interval.contains("to") && (parts = interval.split("to")).length == 2) {
            Double min = IntervalUtil.parseDouble(parts[0], dmin);
            Double max = IntervalUtil.parseDouble(parts[1], dmax);
            return new AbstractMap.SimpleEntry<Double, Double>(min, max);
        }
        Double single = IntervalUtil.parseDouble(interval, dmin);
        return new AbstractMap.SimpleEntry<Double, Double>(single, single);
    }

    public static Map.Entry<Integer, Integer> parseIntegerInterval(String interval, Integer dmin, Integer dmax) {
        String[] parts;
        if (interval == null) {
            return new AbstractMap.SimpleEntry<Integer, Integer>(dmin, dmax);
        }
        if (interval.contains("to") && (parts = interval.split("to")).length == 2) {
            Integer min = IntervalUtil.parseInteger(parts[0], dmin);
            Integer max = IntervalUtil.parseInteger(parts[1], dmax);
            return new AbstractMap.SimpleEntry<Integer, Integer>(min, max);
        }
        Integer single = IntervalUtil.parseInteger(interval, dmin);
        return new AbstractMap.SimpleEntry<Integer, Integer>(single, single);
    }

    public static int randomIntegerFromInterval(int min, int max) {
        return min + MassiveCore.random.nextInt(max - min + 1);
    }

    public static int randomIntegerFromInterval(Map.Entry<Integer, Integer> interval) {
        int min = interval.getKey();
        int max = interval.getValue();
        return IntervalUtil.randomIntegerFromInterval(min, max);
    }

    public static double randomDoubleFromInterval(double min, double max) {
        return min + MassiveCore.random.nextDouble() * (max - min);
    }

    public static double randomDoubleFromInterval(Map.Entry<Double, Double> interval) {
        double min = interval.getKey();
        double max = interval.getValue();
        return IntervalUtil.randomDoubleFromInterval(min, max);
    }

    public static Double randomDoubleFromInterval(String data, Double def) {
        if (IntervalUtil.isValidInterval(data)) {
            Map.Entry<Double, Double> interval = IntervalUtil.parseDoubleInterval(data, def, def);
            return IntervalUtil.randomDoubleFromInterval(interval);
        }
        return IntervalUtil.parseDouble(data, def);
    }

    public static Integer randomIntegerFromInterval(String data, Integer def) {
        if (IntervalUtil.isValidInterval(data)) {
            Map.Entry<Integer, Integer> interval = IntervalUtil.parseIntegerInterval(data, def, def);
            return IntervalUtil.randomIntegerFromInterval(interval);
        }
        return IntervalUtil.parseInteger(data, def);
    }
}

