/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.util;

import com.massivecraft.massivecore.MassiveCore;
import com.massivecraft.massivecore.mixin.Mixin;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class InventoryUtil {
    public static void update(HumanEntity human) {
        if (!(human instanceof Player)) {
            return;
        }
        Player player = (Player)human;
        player.updateInventory();
    }

    public static void updateSoon(final HumanEntity human) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MassiveCore.get(), new Runnable(){

            @Override
            public void run() {
                InventoryUtil.update(human);
            }
        });
    }

    public static void updateLater(final HumanEntity human) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MassiveCore.get(), new Runnable(){

            @Override
            public void run() {
                InventoryUtil.update(human);
            }
        }, 1L);
    }

    public static boolean isOutside(InventoryClickEvent event) {
        return event.getRawSlot() < 0;
    }

    public static boolean isTopInventory(InventoryClickEvent event) {
        if (InventoryUtil.isOutside(event)) {
            return false;
        }
        return event.getRawSlot() < event.getInventory().getSize();
    }

    public static boolean isBottomInventory(InventoryClickEvent event) {
        if (InventoryUtil.isOutside(event)) {
            return false;
        }
        return event.getRawSlot() >= event.getInventory().getSize();
    }

    public static boolean isGiving(InventoryClickEvent event) {
        if (InventoryUtil.isOutside(event)) {
            return false;
        }
        boolean topClicked = InventoryUtil.isTopInventory(event);
        if (event.getClick() == ClickType.NUMBER_KEY) {
            if (!topClicked) {
                return false;
            }
            if (InventoryUtil.isSomething(event.getCurrentItem())) {
                return false;
            }
            ItemStack hotbar = event.getView().getBottomInventory().getItem(event.getHotbarButton());
            return !InventoryUtil.isNothing(hotbar);
        }
        boolean ret = false;
        ret = topClicked ? InventoryUtil.isSomething(event.getCursor()) : event.isShiftClick();
        return ret;
    }

    public static boolean isTaking(InventoryClickEvent event) {
        if (InventoryUtil.isOutside(event)) {
            return false;
        }
        boolean topClicked = InventoryUtil.isTopInventory(event);
        if (event.getClick() == ClickType.NUMBER_KEY) {
            if (!topClicked) {
                return false;
            }
            return !InventoryUtil.isNothing(event.getCurrentItem());
        }
        boolean ret = false;
        if (topClicked) {
            ret = InventoryUtil.isSomething(event.getCurrentItem());
        }
        return ret;
    }

    public static boolean isAltering(InventoryClickEvent event) {
        return InventoryUtil.isGiving(event) || InventoryUtil.isTaking(event);
    }

    public static ItemStack isEquipping(InventoryClickEvent event) {
        boolean isShiftClick = event.isShiftClick();
        InventoryType inventoryType = event.getInventory().getType();
        InventoryType.SlotType slotType = event.getSlotType();
        ItemStack cursor = event.getCursor();
        ItemStack currentItem = event.getCurrentItem();
        if (isShiftClick) {
            if (inventoryType != InventoryType.CRAFTING) {
                return null;
            }
            if (slotType == InventoryType.SlotType.CRAFTING) {
                return null;
            }
            if (slotType == InventoryType.SlotType.ARMOR) {
                return null;
            }
            if (slotType == InventoryType.SlotType.RESULT) {
                return null;
            }
            if (currentItem.getType() == Material.AIR) {
                return null;
            }
            return currentItem;
        }
        if (slotType == InventoryType.SlotType.ARMOR) {
            return cursor;
        }
        return null;
    }

    public static void debug(InventoryClickEvent event) {
        System.out.println("===== DEBUG START =====");
        System.out.println("event.getAction() " + event.getAction());
        System.out.println("event.isLeftClick() " + event.isLeftClick());
        System.out.println("event.isRightClick() " + event.isRightClick());
        System.out.println("event.isShiftClick() " + event.isShiftClick());
        System.out.println("event.getClick() " + event.getClick());
        System.out.println("event.getCurrentItem() " + event.getCurrentItem());
        System.out.println("event.getCursor() " + event.getCursor());
        System.out.println("event.getHotbarButton() " + event.getHotbarButton());
        System.out.println("getInventory().getType() " + event.getInventory().getType());
        System.out.println("event.getRawSlot() " + event.getRawSlot());
        System.out.println("event.getResult() " + event.getResult());
        System.out.println("event.getSlot() " + event.getSlot());
        System.out.println("event.getSlotType() " + event.getSlotType());
        System.out.println("getView().getTopInventory().getType() " + event.getView().getTopInventory().getType());
        System.out.println("getView().getType() " + event.getView().getType());
        System.out.println("getView().getBottomInventory().getType() " + event.getView().getBottomInventory().getType());
        System.out.println("event.getWhoClicked() " + event.getWhoClicked());
        System.out.println("-----");
        System.out.println("isOutside(event) " + InventoryUtil.isOutside(event));
        System.out.println("isTopInventory(event) " + InventoryUtil.isTopInventory(event));
        System.out.println("isBottomInventory(event) " + InventoryUtil.isBottomInventory(event));
        System.out.println("isGiving(event) " + InventoryUtil.isGiving(event));
        System.out.println("isTaking(event) " + InventoryUtil.isTaking(event));
        System.out.println("isAltering(event) " + InventoryUtil.isAltering(event));
        System.out.println("isEquipping(event) " + InventoryUtil.isEquipping(event));
        System.out.println("===== DEBUG END =====");
    }

    public static boolean isEmpty(Inventory inv) {
        if (inv == null) {
            return true;
        }
        for (ItemStack itemStack : inv.getContents()) {
            if (!InventoryUtil.isSomething(itemStack)) continue;
            return false;
        }
        if (inv instanceof PlayerInventory) {
            PlayerInventory pinv = (PlayerInventory)inv;
            if (InventoryUtil.isSomething(pinv.getHelmet())) {
                return false;
            }
            if (InventoryUtil.isSomething(pinv.getChestplate())) {
                return false;
            }
            if (InventoryUtil.isSomething(pinv.getLeggings())) {
                return false;
            }
            if (InventoryUtil.isSomething(pinv.getBoots())) {
                return false;
            }
        }
        return true;
    }

    public static boolean isNothing(ItemStack itemStack) {
        if (itemStack == null) {
            return true;
        }
        if (itemStack.getAmount() == 0) {
            return true;
        }
        return itemStack.getType() == Material.AIR;
    }

    public static boolean isSomething(ItemStack itemStack) {
        return !InventoryUtil.isNothing(itemStack);
    }

    public static ItemStack[] cloneItemStacks(ItemStack[] itemStacks) {
        ItemStack[] ret = new ItemStack[itemStacks.length];
        for (int i = 0; i < itemStacks.length; ++i) {
            ItemStack stack = itemStacks[i];
            if (stack == null) continue;
            ret[i] = new ItemStack(itemStacks[i]);
        }
        return ret;
    }

    public static Inventory cloneInventory(Inventory inventory) {
        if (inventory == null) {
            return null;
        }
        PlayerInventory ret = null;
        int size = inventory.getSize();
        InventoryHolder holder = inventory.getHolder();
        String title = inventory.getTitle();
        if (inventory instanceof PlayerInventory) {
            PlayerInventory pret;
            ret = pret = Mixin.createPlayerInventory();
            PlayerInventory pinventory = (PlayerInventory)inventory;
            pret.setHelmet(pinventory.getHelmet() == null ? null : new ItemStack(pinventory.getHelmet()));
            pret.setChestplate(pinventory.getChestplate() == null ? null : new ItemStack(pinventory.getChestplate()));
            pret.setLeggings(pinventory.getLeggings() == null ? null : new ItemStack(pinventory.getLeggings()));
            pret.setBoots(pinventory.getBoots() == null ? null : new ItemStack(pinventory.getBoots()));
        } else {
            ret = Mixin.createInventory(holder, size, title);
        }
        ItemStack[] contents = InventoryUtil.cloneItemStacks(inventory.getContents());
        ret.setContents(contents);
        return ret;
    }

    public static PlayerInventory cloneInventory(PlayerInventory inventory) {
        return (PlayerInventory)InventoryUtil.cloneInventory((Inventory)inventory);
    }

    public static boolean equals(ItemStack one, ItemStack two) {
        if (InventoryUtil.isNothing(one)) {
            return InventoryUtil.isNothing(two);
        }
        if (InventoryUtil.isNothing(two)) {
            return false;
        }
        return one.equals((Object)two);
    }

    public static boolean equals(ItemStack[] one, ItemStack[] two) {
        if (one == null) {
            return two == null;
        }
        if (two == null) {
            return false;
        }
        if (one.length != two.length) {
            return false;
        }
        for (int i = 0; i < one.length; ++i) {
            if (InventoryUtil.equals(one[i], two[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Inventory one, Inventory two) {
        if (one == null) {
            return two == null;
        }
        if (two == null) {
            return false;
        }
        if (!InventoryUtil.equals(one.getContents(), two.getContents())) {
            return false;
        }
        if (one instanceof PlayerInventory) {
            PlayerInventory pone = (PlayerInventory)one;
            if (two instanceof PlayerInventory) {
                PlayerInventory ptwo = (PlayerInventory)two;
                return InventoryUtil.equals(pone.getArmorContents(), ptwo.getArmorContents());
            }
            return false;
        }
        return true;
    }

    public static void setAllContents(Inventory from, Inventory to) {
        to.setContents(from.getContents());
        if (from instanceof PlayerInventory) {
            PlayerInventory pfrom = (PlayerInventory)from;
            if (to instanceof PlayerInventory) {
                PlayerInventory pto = (PlayerInventory)to;
                pto.setHelmet(pfrom.getHelmet());
                pto.setChestplate(pfrom.getChestplate());
                pto.setLeggings(pfrom.getLeggings());
                pto.setBoots(pfrom.getBoots());
            }
        }
    }

    public static int roomLeft(Inventory inventory, ItemStack item, int limit) {
        int ret;
        inventory = InventoryUtil.cloneInventory(inventory);
        for (ret = 0; limit <= 0 || ret < limit; ++ret) {
            HashMap result = inventory.addItem(new ItemStack[]{item.clone()});
            if (result.size() == 0) continue;
            return ret;
        }
        return ret;
    }

    public static void addItemTimes(Inventory inventory, ItemStack item, int times) {
        for (int i = 0; i < times; ++i) {
            inventory.addItem(new ItemStack[]{item.clone()});
        }
    }

    public static int countSimilar(Inventory inventory, ItemStack itemStack) {
        int ret = 0;
        for (ItemStack item : inventory.getContents()) {
            if (item == null || !item.isSimilar(itemStack)) continue;
            ret += item.getAmount();
        }
        return ret;
    }
}

