/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.util;

import com.massivecraft.massivecore.CaseInsensitiveComparator;
import com.massivecraft.massivecore.MassiveCore;
import com.massivecraft.massivecore.MassiveCoreEngineMain;
import com.massivecraft.massivecore.MassiveCoreEngineWorldNameSet;
import com.massivecraft.massivecore.collections.MassiveList;
import com.massivecraft.massivecore.collections.MassiveSet;
import com.massivecraft.massivecore.collections.MassiveTreeSet;
import com.massivecraft.massivecore.util.InventoryUtil;
import com.massivecraft.massivecore.util.extractor.Extractor;
import com.massivecraft.massivecore.util.extractor.ExtractorPlayer;
import com.massivecraft.massivecore.util.extractor.ExtractorPlayerName;
import com.massivecraft.massivecore.util.extractor.ExtractorSender;
import com.massivecraft.massivecore.util.extractor.ExtractorSenderId;
import com.massivecraft.massivecore.util.extractor.ExtractorSenderName;
import com.massivecraft.massivecore.util.extractor.ExtractorWorld;
import com.massivecraft.massivecore.util.extractor.ExtractorWorldName;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;

public class MUtil {
    private static Method methodGetOnlinePlayers = MUtil.getMethodGetOnlinePlayers();
    public static final Pattern playerNamePattern = Pattern.compile("^[a-zA-Z0-9_]{2,16}$");
    public static final Set<Material> FOOD_MATERIALS = new HashSet<Material>(MUtil.list(Material.APPLE, Material.BREAD, Material.COOKED_BEEF, Material.COOKED_CHICKEN, Material.COOKED_FISH, Material.COOKIE, Material.GRILLED_PORK, Material.GOLDEN_APPLE, Material.MELON, Material.MUSHROOM_SOUP, Material.PORK, Material.RAW_BEEF, Material.RAW_CHICKEN, Material.RAW_FISH, Material.ROTTEN_FLESH, Material.SPIDER_EYE));
    public static Set<Material> SWORD_MATERIALS = EnumSet.of(Material.WOOD_SWORD, Material.STONE_SWORD, Material.IRON_SWORD, Material.GOLD_SWORD, Material.DIAMOND_SWORD);
    public static Set<Material> AXE_MATERIALS = EnumSet.of(Material.WOOD_AXE, Material.STONE_AXE, Material.IRON_AXE, Material.GOLD_AXE, Material.DIAMOND_AXE);
    public static Set<Material> PICKAXE_MATERIALS = EnumSet.of(Material.WOOD_PICKAXE, Material.STONE_PICKAXE, Material.IRON_PICKAXE, Material.GOLD_PICKAXE, Material.DIAMOND_PICKAXE);
    public static Set<Material> SPADE_MATERIALS = EnumSet.of(Material.WOOD_SPADE, Material.STONE_SPADE, Material.IRON_SPADE, Material.GOLD_SPADE, Material.DIAMOND_SPADE);
    public static final Set<PotionEffectType> HARMFUL_POTION_EFFECTS = Collections.unmodifiableSet(MUtil.set(PotionEffectType.BLINDNESS, PotionEffectType.CONFUSION, PotionEffectType.HARM, PotionEffectType.HUNGER, PotionEffectType.POISON, PotionEffectType.SLOW, PotionEffectType.SLOW_DIGGING, PotionEffectType.WEAKNESS, PotionEffectType.WITHER));
    protected static Map<Class<?>, Map<String, Set<Extractor>>> classesPropertiesExtractors = new HashMap();

    public static Method getMethodGetOnlinePlayers() {
        Method ret = null;
        try {
            for (Method method : Bukkit.class.getDeclaredMethods()) {
                if (!method.getName().equals("getOnlinePlayers")) continue;
                if (ret == null) {
                    ret = method;
                }
                if (!method.getReturnType().isAssignableFrom(Collection.class)) continue;
                ret = method;
                break;
            }
            ret.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static Collection<? extends Player> getOnlinePlayers() {
        try {
            return Bukkit.getOnlinePlayers();
        }
        catch (Throwable e) {
            try {
                Object playersObject = methodGetOnlinePlayers.invoke(null, new Object[0]);
                if (playersObject instanceof Collection) {
                    Collection playersCollection = (Collection)playersObject;
                    return playersCollection;
                }
                if (playersObject instanceof Player[]) {
                    Player[] playersArray = (Player[])playersObject;
                    return Arrays.asList(playersArray);
                }
                throw new RuntimeException("Unknown return type for getOnlinePlayers using reflection.");
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return null;
            }
        }
    }

    public static boolean isValidPlayerName(String string) {
        return playerNamePattern.matcher(string).matches();
    }

    public static boolean isValidUUID(String string) {
        if (string == null) {
            return false;
        }
        try {
            UUID.fromString(string);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getStackTraceString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        new Throwable().printStackTrace(pw);
        return sw.toString();
    }

    public static int getCode(ChatColor chatColor) {
        switch (chatColor) {
            case BLACK: {
                return 0;
            }
            case DARK_BLUE: {
                return 1;
            }
            case DARK_GREEN: {
                return 2;
            }
            case DARK_AQUA: {
                return 3;
            }
            case DARK_RED: {
                return 4;
            }
            case DARK_PURPLE: {
                return 5;
            }
            case GOLD: {
                return 6;
            }
            case GRAY: {
                return 7;
            }
            case DARK_GRAY: {
                return 8;
            }
            case BLUE: {
                return 9;
            }
            case GREEN: {
                return 10;
            }
            case AQUA: {
                return 11;
            }
            case RED: {
                return 12;
            }
            case LIGHT_PURPLE: {
                return 13;
            }
            case YELLOW: {
                return 14;
            }
            case WHITE: {
                return 15;
            }
            case MAGIC: {
                return 16;
            }
            case BOLD: {
                return 17;
            }
            case STRIKETHROUGH: {
                return 18;
            }
            case UNDERLINE: {
                return 19;
            }
            case ITALIC: {
                return 20;
            }
            case RESET: {
                return 21;
            }
        }
        throw new IllegalArgumentException("The chat color " + chatColor.name() + " is not yet supported!");
    }

    public static String getIp(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return null;
        }
        Player player = (Player)sender;
        InetSocketAddress address = player.getAddress();
        if (address == null) {
            return null;
        }
        String ret = address.toString();
        String[] parts = ret.split("/");
        ret = parts[1];
        parts = ret.split(":");
        ret = parts[0];
        return ret;
    }

    public static <T> T regexPickFirstVal(String input, Map<String, T> regex2val) {
        if (regex2val == null) {
            return null;
        }
        T ret = null;
        for (Map.Entry<String, T> entry : regex2val.entrySet()) {
            String regex;
            ret = entry.getValue();
            if (input == null || !Pattern.matches(regex = entry.getKey(), input)) continue;
            break;
        }
        return ret;
    }

    public static <E, T> T equalsPickFirstVal(E input, Map<E, T> thing2val) {
        if (thing2val == null) {
            return null;
        }
        T ret = null;
        for (Map.Entry<E, T> entry : thing2val.entrySet()) {
            E thing;
            ret = entry.getValue();
            if (input == null || !MUtil.equals(input, thing = entry.getKey())) continue;
            break;
        }
        return ret;
    }

    public static <T> T recurseResolveMap(T input, Map<T, T> map) {
        T output = map.get(input);
        if (output == null) {
            return input;
        }
        return MUtil.recurseResolveMap(output, map);
    }

    public static List<Block> getBlocks(Location location, int halfWidth) {
        return MUtil.getBlocks(location.getBlock(), halfWidth);
    }

    public static List<Block> getBlocks(Block block, int halfWidth) {
        int xmin = block.getX() - halfWidth;
        int ymin = block.getY() - halfWidth;
        int zmin = block.getZ() - halfWidth;
        int xmax = block.getX() + halfWidth;
        int ymax = block.getY() + halfWidth;
        int zmax = block.getZ() + halfWidth;
        return MUtil.getBlocks(block.getWorld(), xmin, ymin, zmin, xmax, ymax, zmax);
    }

    public static List<Block> getBlocks(World world, int xmin, int ymin, int zmin, int xmax, int ymax, int zmax) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int x = xmin; x <= xmax; ++x) {
            for (int y = ymin; y <= ymax; ++y) {
                for (int z = zmin; z <= zmax; ++z) {
                    blocks.add(world.getBlockAt(x, y, z));
                }
            }
        }
        return blocks;
    }

    public static boolean isSameBlock(PlayerMoveEvent event) {
        return MUtil.isSameBlock(event.getFrom(), event.getTo());
    }

    public static boolean isSameBlock(Location one, Location two) {
        if (one.getBlockX() != two.getBlockX()) {
            return false;
        }
        if (one.getBlockZ() != two.getBlockZ()) {
            return false;
        }
        if (one.getBlockY() != two.getBlockY()) {
            return false;
        }
        return one.getWorld().equals(two.getWorld());
    }

    public static boolean isSameChunk(PlayerMoveEvent event) {
        return MUtil.isSameChunk(event.getFrom(), event.getTo());
    }

    public static boolean isSameChunk(Location one, Location two) {
        if (one.getBlockX() >> 4 != two.getBlockX() >> 4) {
            return false;
        }
        if (one.getBlockZ() >> 4 != two.getBlockZ() >> 4) {
            return false;
        }
        return one.getWorld() == two.getWorld();
    }

    public static Float getYaw(BlockFace face) {
        switch (face) {
            case NORTH: {
                return Float.valueOf(0.0f);
            }
            case EAST: {
                return Float.valueOf(90.0f);
            }
            case SOUTH: {
                return Float.valueOf(180.0f);
            }
            case WEST: {
                return Float.valueOf(270.0f);
            }
            case UP: {
                return null;
            }
            case DOWN: {
                return null;
            }
            case NORTH_EAST: {
                return Float.valueOf(45.0f);
            }
            case NORTH_WEST: {
                return Float.valueOf(315.0f);
            }
            case SOUTH_EAST: {
                return Float.valueOf(135.0f);
            }
            case SOUTH_WEST: {
                return Float.valueOf(225.0f);
            }
            case WEST_NORTH_WEST: {
                return Float.valueOf(292.5f);
            }
            case NORTH_NORTH_WEST: {
                return Float.valueOf(337.5f);
            }
            case NORTH_NORTH_EAST: {
                return Float.valueOf(22.5f);
            }
            case EAST_NORTH_EAST: {
                return Float.valueOf(67.5f);
            }
            case EAST_SOUTH_EAST: {
                return Float.valueOf(112.5f);
            }
            case SOUTH_SOUTH_EAST: {
                return Float.valueOf(157.5f);
            }
            case SOUTH_SOUTH_WEST: {
                return Float.valueOf(202.5f);
            }
            case WEST_SOUTH_WEST: {
                return Float.valueOf(247.5f);
            }
            case SELF: {
                return null;
            }
        }
        return null;
    }

    public static boolean isArchery(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity instanceof Arrow;
    }

    public static boolean isArchery(EntityDamageByEntityEvent event) {
        return MUtil.isArchery(event.getDamager());
    }

    public static boolean isArchery(EntityDamageEvent event) {
        if (!(event instanceof EntityDamageByEntityEvent)) {
            return false;
        }
        return MUtil.isArchery((EntityDamageByEntityEvent)event);
    }

    public static boolean isSword(Material material) {
        return SWORD_MATERIALS.contains(material);
    }

    public static boolean isSword(ItemStack item) {
        if (item == null) {
            return false;
        }
        return MUtil.isSword(item.getType());
    }

    public static boolean isSword(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity lentity = (LivingEntity)entity;
        return MUtil.isSword(lentity.getEquipment().getItemInHand());
    }

    public static boolean isSword(EntityDamageByEntityEvent event) {
        return MUtil.isSword(event.getDamager());
    }

    public static boolean isSword(EntityDamageEvent event) {
        if (!(event instanceof EntityDamageByEntityEvent)) {
            return false;
        }
        return MUtil.isSword((EntityDamageByEntityEvent)event);
    }

    public static boolean isAxe(Material material) {
        return AXE_MATERIALS.contains(material);
    }

    public static boolean isAxe(ItemStack item) {
        if (item == null) {
            return false;
        }
        return MUtil.isAxe(item.getType());
    }

    public static boolean isAxe(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity lentity = (LivingEntity)entity;
        return MUtil.isAxe(lentity.getEquipment().getItemInHand());
    }

    public static boolean isAxe(EntityDamageByEntityEvent event) {
        return MUtil.isAxe(event.getDamager());
    }

    public static boolean isAxe(EntityDamageEvent event) {
        if (!(event instanceof EntityDamageByEntityEvent)) {
            return false;
        }
        return MUtil.isAxe((EntityDamageByEntityEvent)event);
    }

    public static boolean isUnarmed(ItemStack item) {
        if (item == null) {
            return true;
        }
        return InventoryUtil.isNothing(item);
    }

    public static boolean isUnarmed(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity lentity = (LivingEntity)entity;
        return MUtil.isUnarmed(lentity.getEquipment().getItemInHand());
    }

    public static boolean isUnarmed(EntityDamageByEntityEvent event) {
        return MUtil.isUnarmed(event.getDamager());
    }

    public static boolean isUnarmed(EntityDamageEvent event) {
        if (!(event instanceof EntityDamageByEntityEvent)) {
            return false;
        }
        return MUtil.isUnarmed((EntityDamageByEntityEvent)event);
    }

    public static boolean isAxe(BlockBreakEvent event) {
        return MUtil.isAxe(event.getPlayer().getItemInHand());
    }

    public static boolean isPickaxe(Material material) {
        return PICKAXE_MATERIALS.contains(material);
    }

    public static boolean isPickaxe(ItemStack item) {
        if (item == null) {
            return false;
        }
        return MUtil.isPickaxe(item.getType());
    }

    public static boolean isPickaxe(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity lentity = (LivingEntity)entity;
        return MUtil.isPickaxe(lentity.getEquipment().getItemInHand());
    }

    public static boolean isPickaxe(BlockBreakEvent event) {
        return MUtil.isPickaxe(event.getPlayer().getItemInHand());
    }

    public static boolean isSpade(Material material) {
        return SPADE_MATERIALS.contains(material);
    }

    public static boolean isSpade(ItemStack item) {
        if (item == null) {
            return false;
        }
        return MUtil.isSpade(item.getType());
    }

    public static boolean isSpade(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity lentity = (LivingEntity)entity;
        return MUtil.isSpade(lentity.getEquipment().getItemInHand());
    }

    public static boolean isSpade(BlockBreakEvent event) {
        return MUtil.isSpade(event.getPlayer().getItemInHand());
    }

    public static Material getEatenMaterial(PlayerInteractEvent event) {
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK) {
            return null;
        }
        Material ret = null;
        if (action == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock().getType() == Material.CAKE_BLOCK) {
            ret = Material.CAKE_BLOCK;
        } else if (FOOD_MATERIALS.contains(event.getMaterial())) {
            ret = event.getMaterial();
        }
        return ret;
    }

    public static boolean isCombatEvent(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK && event.getCause() != EntityDamageEvent.DamageCause.PROJECTILE) {
            return false;
        }
        return event instanceof EntityDamageByEntityEvent;
    }

    public static boolean isCloseCombatEvent(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
            return false;
        }
        return event instanceof EntityDamageByEntityEvent;
    }

    public static Entity getLiableDamager(EntityDamageEvent event) {
        Projectile projectile;
        ProjectileSource projectileSource;
        if (!(event instanceof EntityDamageByEntityEvent)) {
            return null;
        }
        EntityDamageByEntityEvent edbeEvent = (EntityDamageByEntityEvent)event;
        Entity ret = edbeEvent.getDamager();
        if (ret instanceof Projectile && (projectileSource = (projectile = (Projectile)ret).getShooter()) instanceof Entity) {
            ret = (Entity)projectileSource;
        }
        return ret;
    }

    public static String kickReason(PlayerQuitEvent event) {
        return MassiveCoreEngineMain.kickedPlayerReasons.get(event.getPlayer().getName());
    }

    public static boolean causedByKick(PlayerQuitEvent event) {
        return MUtil.kickReason(event) != null;
    }

    public static int getPotionEffectBits(ItemStack item) {
        return item.getDurability() & 0x3F;
    }

    public static boolean isWaterPotion(ItemStack item) {
        return MUtil.getPotionEffectBits(item) == 0;
    }

    public static List<PotionEffect> getPotionEffects(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.getType() != Material.POTION) {
            return null;
        }
        ArrayList<PotionEffect> ret = new ArrayList<PotionEffect>();
        if (MUtil.isWaterPotion(itemStack)) {
            return ret;
        }
        Potion potion = Potion.fromDamage((int)MUtil.getPotionEffectBits(itemStack));
        ret.addAll(potion.getEffects());
        PotionMeta meta = (PotionMeta)itemStack.getItemMeta();
        if (meta.hasCustomEffects()) {
            ret.addAll(meta.getCustomEffects());
        }
        return ret;
    }

    public static boolean isHarmfulPotion(PotionEffectType potionEffectType) {
        return HARMFUL_POTION_EFFECTS.contains(potionEffectType);
    }

    public static boolean isHarmfulPotion(PotionEffect potionEffect) {
        if (potionEffect == null) {
            return false;
        }
        return MUtil.isHarmfulPotion(potionEffect.getType());
    }

    public static boolean isHarmfulPotion(ItemStack itemStack) {
        List<PotionEffect> potionEffects = MUtil.getPotionEffects(itemStack);
        if (potionEffects == null) {
            return false;
        }
        for (PotionEffect potionEffect : potionEffects) {
            if (!MUtil.isHarmfulPotion(potionEffect)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHarmfulPotion(ThrownPotion thrownPotion) {
        return MUtil.isHarmfulPotion(thrownPotion.getItem());
    }

    public static Set<String> getLoadedWorldNames() {
        return MassiveCoreEngineWorldNameSet.get().getWorldNames();
    }

    @SafeVarargs
    public static <T> List<T> list(T ... items) {
        return new MassiveList<T>(Arrays.asList(items));
    }

    @SafeVarargs
    public static <T> Set<T> set(T ... items) {
        return new MassiveSet<T>(Arrays.asList(items));
    }

    public static Set<String> treeset(String ... items) {
        return new MassiveTreeSet((Object)CaseInsensitiveComparator.get(), (Collection<String>)Arrays.asList(items));
    }

    public static <K, V> Map<K, V> map(K key1, V value1, Object ... objects) {
        LinkedHashMap<Object, Object> ret = new LinkedHashMap<Object, Object>();
        ret.put(key1, value1);
        Iterator<Object> iter = Arrays.asList(objects).iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Object value = iter.next();
            ret.put(key, value);
        }
        return ret;
    }

    public static <K, V> Map<V, K> flippedMap(Map<K, V> map) {
        LinkedHashMap<V, K> ret = new LinkedHashMap<V, K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V value = entry.getValue();
            K key = entry.getKey();
            if (value == null) continue;
            ret.put(value, key);
        }
        return ret;
    }

    public static <K, V> Map<V, Set<K>> reverseIndex(Map<K, V> map) {
        LinkedHashMap<V, HashSet<K>> ret = new LinkedHashMap<V, HashSet<K>>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            HashSet<K> set = (HashSet<K>)ret.get(value);
            if (set == null) {
                set = new HashSet<K>();
                ret.put(value, set);
            }
            set.add(key);
        }
        return ret;
    }

    public static <T> T removeByIndex(Collection<T> coll, int index) {
        if (coll == null) {
            throw new NullPointerException("coll");
        }
        if (coll instanceof List) {
            return (T)((List)coll).remove(index);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("index < 0");
        }
        if (index >= coll.size()) {
            throw new IndexOutOfBoundsException("index > collection size");
        }
        int i = -1;
        Iterator<T> iter = coll.iterator();
        while (iter.hasNext()) {
            T ret = iter.next();
            if (++i != index) continue;
            iter.remove();
            return ret;
        }
        return null;
    }

    public static <T> T random(Collection<T> coll) {
        if (coll.size() == 0) {
            return null;
        }
        if (coll.size() == 1) {
            return coll.iterator().next();
        }
        int index = MassiveCore.random.nextInt(coll.size());
        ArrayList<T> list = null;
        list = coll instanceof List ? (ArrayList<T>)coll : new ArrayList<T>(coll);
        return (T)list.get(index);
    }

    public static <T> List<T> random(Collection<T> coll, int count) {
        ArrayList<T> ret = new ArrayList<T>(coll);
        if (count < 0) {
            count = 0;
        }
        while (ret.size() > count) {
            int index = MassiveCore.random.nextInt(ret.size());
            ret.remove(index);
        }
        return ret;
    }

    public static boolean equals(Object herp, Object derp) {
        if (herp == null) {
            return derp == null;
        }
        if (derp == null) {
            return false;
        }
        return herp.equals(derp);
    }

    public static <T> int compare(Comparable<T> herp, T derp) {
        Integer ret = MUtil.compareNulls(herp, derp);
        if (ret != null) {
            return ret;
        }
        return herp.compareTo(derp);
    }

    public static Integer compareNulls(Object one, Object two) {
        if (one == null && two == null) {
            return 0;
        }
        if (one == null) {
            return -1;
        }
        if (two == null) {
            return 1;
        }
        return null;
    }

    public static Integer compareWithList(Object one, Object two, List<? extends Object> list) {
        int oneIndex = list.indexOf(one);
        int twoIndex = list.indexOf(two);
        if (oneIndex != -1 && twoIndex != -1) {
            return oneIndex - twoIndex;
        }
        if (oneIndex != -1) {
            return -1;
        }
        if (twoIndex != -1) {
            return 1;
        }
        return null;
    }

    public static <K, V extends Comparable<? super V>> SortedSet<Map.Entry<K, V>> entriesSortedByValues(Map<K, V> map) {
        return MUtil.entriesSortedByValues(map, true);
    }

    public static <K, V extends Comparable<? super V>> SortedSet<Map.Entry<K, V>> entriesSortedByValues(Map<K, V> map, final boolean ascending) {
        TreeSet<Map.Entry<K, V>> sortedEntries = new TreeSet<Map.Entry<K, V>>(new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> e1, Map.Entry<K, V> e2) {
                int res = ascending ? ((Comparable)e1.getValue()).compareTo(e2.getValue()) : ((Comparable)e2.getValue()).compareTo(e1.getValue());
                return res != 0 ? res : 1;
            }
        });
        sortedEntries.addAll(map.entrySet());
        return sortedEntries;
    }

    public static <T extends Number> T limitNumber(T d, T min, T max) {
        if (min instanceof Number && d.doubleValue() < min.doubleValue()) {
            return min;
        }
        if (max instanceof Number && d.doubleValue() > max.doubleValue()) {
            return max;
        }
        return d;
    }

    public static long probabilityRound(double val) {
        long ret = (long)Math.floor(val);
        double prob = val % 1.0;
        if (MassiveCore.random.nextDouble() < prob) {
            ++ret;
        }
        return ret;
    }

    protected static Map<String, Set<Extractor>> getPropertiesExtractors(Class<?> propertyClass) {
        Map<String, Set<Extractor>> ret = classesPropertiesExtractors.get(propertyClass);
        if (ret == null) {
            ret = new HashMap<String, Set<Extractor>>();
            classesPropertiesExtractors.put(propertyClass, ret);
        }
        return ret;
    }

    protected static Set<Extractor> getExtractors(Class<?> propertyClass, String propertyName) {
        Map<String, Set<Extractor>> propertiesExtractors = MUtil.getPropertiesExtractors(propertyClass);
        Set<Extractor> ret = propertiesExtractors.get(propertyName);
        if (ret == null) {
            ret = new HashSet<Extractor>();
            propertiesExtractors.put(propertyName, ret);
        }
        return ret;
    }

    public static <T> T extract(Class<T> propertyClass, String propertyName, Object o) {
        Extractor extractor;
        Object ret = null;
        Iterator<Extractor> iterator = MUtil.getExtractors(propertyClass, propertyName).iterator();
        while (iterator.hasNext() && (ret = (extractor = iterator.next()).extract(o)) == null) {
        }
        return (T)ret;
    }

    public static <T> void registerExtractor(Class<T> clazz, String propertyName, Extractor extractor) {
        MUtil.getExtractors(clazz, propertyName).add(extractor);
    }

    static {
        MUtil.registerExtractor(CommandSender.class, "sender", ExtractorSender.get());
        MUtil.registerExtractor(String.class, "senderId", ExtractorSenderId.get());
        MUtil.registerExtractor(Player.class, "player", ExtractorPlayer.get());
        MUtil.registerExtractor(String.class, "playerName", ExtractorPlayerName.get());
        MUtil.registerExtractor(World.class, "world", ExtractorWorld.get());
        MUtil.registerExtractor(String.class, "worldName", ExtractorWorldName.get());
        MUtil.registerExtractor(String.class, "accountId", ExtractorSenderName.get());
    }
}

