/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.util;

import com.massivecraft.massivecore.MassiveCore;
import com.massivecraft.massivecore.event.EventMassiveCorePermissionDeniedFormat;
import com.massivecraft.massivecore.util.Txt;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;

public class PermUtil {
    public static boolean has(Permissible permissable, Permission permission) {
        return PermUtil.has(permissable, permission.getName());
    }

    public static boolean has(Permissible permissable, String perm) {
        if (permissable == null) {
            return false;
        }
        return permissable.hasPermission(perm);
    }

    public static boolean has(Permissible permissable, Permission permission, boolean verbose) {
        return PermUtil.has(permissable, permission.getName(), verbose);
    }

    public static boolean has(Permissible permissible, String perm, boolean verbose) {
        if (PermUtil.has(permissible, perm)) {
            return true;
        }
        if (verbose && permissible != null && permissible instanceof CommandSender) {
            CommandSender sender = (CommandSender)permissible;
            sender.sendMessage(PermUtil.getDeniedMessage(perm));
        }
        return false;
    }

    public static String getDescription(String perm) {
        if (perm == null) {
            return "do that";
        }
        Permission permission = Bukkit.getPluginManager().getPermission(perm);
        return PermUtil.getDescription(permission);
    }

    public static String getDescription(Permission perm) {
        if (perm == null) {
            return "do that";
        }
        String desc = perm.getDescription();
        if (desc == null || desc.length() == 0) {
            return "do that";
        }
        return desc;
    }

    public static String getDeniedFormat(String perm) {
        EventMassiveCorePermissionDeniedFormat event = new EventMassiveCorePermissionDeniedFormat(perm);
        event.run();
        String ret = event.getFormat();
        if (ret == null) {
            ret = "<b>You don't have permission to %s.";
        }
        return ret;
    }

    public static String getDeniedFormat(Permission perm) {
        return PermUtil.getDeniedFormat(perm == null ? null : perm.getName());
    }

    public static String getDeniedMessage(String perm) {
        return Txt.parse(PermUtil.getDeniedFormat(perm), PermUtil.getDescription(perm));
    }

    public static String getDeniedMessage(Permission perm) {
        return Txt.parse(PermUtil.getDeniedFormat(perm), PermUtil.getDescription(perm));
    }

    public static <T> T pickFirstVal(Permissible permissible, Map<String, T> perm2val) {
        if (perm2val == null) {
            return null;
        }
        T ret = null;
        for (Map.Entry<String, T> entry : perm2val.entrySet()) {
            ret = entry.getValue();
            if (!PermUtil.has(permissible, entry.getKey())) continue;
            break;
        }
        return ret;
    }

    public static void ensureHas(Permissible permissible, String permissionName) {
        if (permissible.hasPermission(permissionName)) {
            return;
        }
        permissible.addAttachment((Plugin)MassiveCore.get(), permissionName, true);
    }

    public static void ensureHas(Permissible permissible, Permission permission) {
        PermUtil.ensureHas(permissible, permission.getName());
    }

    public static void set(Permission permission, String description) {
        permission.setDescription(description);
    }

    public static void set(Permission permission, PermissionDefault defaultValue) {
        if (defaultValue == null) {
            return;
        }
        if (permission.getDefault() == defaultValue) {
            return;
        }
        permission.setDefault(defaultValue);
    }

    public static void set(Permission permission, Map<String, Boolean> children) {
        if (children == null) {
            return;
        }
        if (permission.getChildren().equals(children)) {
            return;
        }
        permission.getChildren().clear();
        permission.getChildren().putAll(children);
        permission.recalculatePermissibles();
    }

    public static void set(Permission permission, String description, PermissionDefault defaultValue) {
        PermUtil.set(permission, defaultValue);
        PermUtil.set(permission, description);
    }

    public static void set(Permission permission, String description, Map<String, Boolean> children) {
        PermUtil.set(permission, children);
        PermUtil.set(permission, description);
    }

    public static void set(Permission permission, PermissionDefault defaultValue, Map<String, Boolean> children) {
        boolean childrenChanged = false;
        boolean defaultChanged = false;
        if (!permission.getChildren().equals(children)) {
            permission.getChildren().clear();
            permission.getChildren().putAll(children);
            childrenChanged = true;
        }
        if (permission.getDefault() != defaultValue) {
            permission.setDefault(defaultValue);
            defaultChanged = true;
        }
        if (childrenChanged && !defaultChanged) {
            permission.recalculatePermissibles();
        }
    }

    public static void set(Permission permission, String description, PermissionDefault defaultValue, Map<String, Boolean> children) {
        PermUtil.set(permission, defaultValue, children);
        PermUtil.set(permission, description);
    }

    public static Permission get(boolean create, boolean update, String name, String description, PermissionDefault defaultValue, Map<String, Boolean> children) {
        Permission ret = Bukkit.getPluginManager().getPermission(name);
        if (ret == null) {
            if (create) {
                ret = new Permission(name, description, defaultValue, children);
                Bukkit.getPluginManager().addPermission(ret);
            }
        } else if (update) {
            PermUtil.set(ret, description, defaultValue, children);
        }
        return ret;
    }

    public static Permission get(boolean create, String name) {
        Permission ret = Bukkit.getPluginManager().getPermission(name);
        if (ret == null && create) {
            ret = new Permission(name);
            Bukkit.getPluginManager().addPermission(ret);
        }
        return ret;
    }

    public static Permission get(boolean create, boolean update, String name, String description) {
        Permission ret = Bukkit.getPluginManager().getPermission(name);
        if (ret == null) {
            if (create) {
                ret = new Permission(name, description);
                Bukkit.getPluginManager().addPermission(ret);
            }
        } else if (update) {
            PermUtil.set(ret, description);
        }
        return ret;
    }

    public static Permission get(boolean create, boolean update, String name, PermissionDefault defaultValue) {
        Permission ret = Bukkit.getPluginManager().getPermission(name);
        if (ret == null) {
            if (create) {
                ret = new Permission(name, defaultValue);
                Bukkit.getPluginManager().addPermission(ret);
            }
        } else if (update) {
            PermUtil.set(ret, defaultValue);
        }
        return ret;
    }

    public static Permission get(boolean create, boolean update, String name, Map<String, Boolean> children) {
        Permission ret = Bukkit.getPluginManager().getPermission(name);
        if (ret == null) {
            if (create) {
                ret = new Permission(name, children);
                Bukkit.getPluginManager().addPermission(ret);
            }
        } else if (update) {
            PermUtil.set(ret, children);
        }
        return ret;
    }

    public static Permission get(boolean create, boolean update, String name, String description, PermissionDefault defaultValue) {
        Permission ret = Bukkit.getPluginManager().getPermission(name);
        if (ret == null) {
            if (create) {
                ret = new Permission(name, description, defaultValue);
                Bukkit.getPluginManager().addPermission(ret);
            }
        } else if (update) {
            PermUtil.set(ret, description, defaultValue);
        }
        return ret;
    }

    public static Permission get(boolean create, boolean update, String name, String description, Map<String, Boolean> children) {
        Permission ret = Bukkit.getPluginManager().getPermission(name);
        if (ret == null) {
            if (create) {
                ret = new Permission(name, description, children);
                Bukkit.getPluginManager().addPermission(ret);
            }
        } else if (update) {
            PermUtil.set(ret, description, children);
        }
        return ret;
    }

    public static Permission get(boolean create, boolean update, String name, PermissionDefault defaultValue, Map<String, Boolean> children) {
        Permission ret = Bukkit.getPluginManager().getPermission(name);
        if (ret == null) {
            if (create) {
                ret = new Permission(name, defaultValue, children);
                Bukkit.getPluginManager().addPermission(ret);
            }
        } else if (update) {
            PermUtil.set(ret, defaultValue, children);
        }
        return ret;
    }
}

