/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.util;

import com.massivecraft.massivecore.EngineAbstract;
import com.massivecraft.massivecore.MassiveCore;
import com.massivecraft.massivecore.event.EventMassiveCoreAfterPlayerRespawn;
import com.massivecraft.massivecore.event.EventMassiveCoreAfterPlayerTeleport;
import com.massivecraft.massivecore.event.EventMassiveCorePlayerUpdate;
import com.massivecraft.massivecore.util.MUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;

public class PlayerUtil
extends EngineAbstract {
    private static PlayerUtil i = new PlayerUtil();
    private static Set<UUID> joinedPlayerIds = new ConcurrentSkipListSet<UUID>();
    private static Map<UUID, Long> idToLastMoveMillis = new HashMap<UUID, Long>();
    private static Map<UUID, Long> idToLastDamageMillis = new HashMap<UUID, Long>();
    private static Map<UUID, PlayerDeathEvent> idToDeathEvent = new HashMap<UUID, PlayerDeathEvent>();
    private static Map<String, EntityDamageByEntityEvent> idToDamageEvent = new HashMap<String, EntityDamageByEntityEvent>();
    private static Map<UUID, PlayerAnimationEvent> idToArmSwingEvent = new HashMap<UUID, PlayerAnimationEvent>();
    public static Map<UUID, Long> idToLastFlyActive = new HashMap<UUID, Long>();
    public static final float DEFAULT_FLY_SPEED = 0.1f;

    public static PlayerUtil get() {
        return i;
    }

    @Override
    public void activate() {
        super.activate();
        idToDeathEvent.clear();
        idToDamageEvent.clear();
        idToArmSwingEvent.clear();
        joinedPlayerIds.clear();
        for (Player player : MUtil.getOnlinePlayers()) {
            joinedPlayerIds.add(player.getUniqueId());
        }
        idToLastMoveMillis.clear();
    }

    @Override
    public Plugin getPlugin() {
        return MassiveCore.get();
    }

    @Override
    public Long getPeriod() {
        return 1L;
    }

    @Override
    public void run() {
        idToDeathEvent.clear();
        idToDamageEvent.clear();
        idToArmSwingEvent.clear();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void isJoined(PlayerJoinEvent event) {
        final UUID id = event.getPlayer().getUniqueId();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MassiveCore.get(), new Runnable(){

            @Override
            public void run() {
                joinedPlayerIds.add(id);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void isJoined(PlayerQuitEvent event) {
        UUID id = event.getPlayer().getUniqueId();
        joinedPlayerIds.remove(id);
    }

    public static boolean isJoined(Player player) {
        if (player == null) {
            throw new NullPointerException("player was null");
        }
        UUID id = player.getUniqueId();
        return joinedPlayerIds.contains(id);
    }

    public static void setLastMoveMillis(Player player, long millis) {
        if (player == null) {
            return;
        }
        idToLastMoveMillis.put(player.getUniqueId(), millis);
    }

    public static void setLastMoveMillis(Player player) {
        PlayerUtil.setLastMoveMillis(player, System.currentTimeMillis());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void setLastMoveMillis(PlayerMoveEvent event) {
        if (MUtil.isSameBlock(event)) {
            return;
        }
        PlayerUtil.setLastMoveMillis(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void setLastMoveMillis(PlayerJoinEvent event) {
        PlayerUtil.setLastMoveMillis(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void setLastMoveMillis(PlayerChangedWorldEvent event) {
        PlayerUtil.setLastMoveMillis(event.getPlayer());
    }

    public static long getLastMoveMillis(Player player) {
        if (player == null) {
            return 0L;
        }
        Long ret = idToLastMoveMillis.get(player.getUniqueId());
        if (ret == null) {
            return 0L;
        }
        return ret;
    }

    public static long getStandStillMillis(Player player) {
        if (player == null) {
            return 0L;
        }
        if (player.isDead()) {
            return 0L;
        }
        if (!player.isOnline()) {
            return 0L;
        }
        Long ret = idToLastMoveMillis.get(player.getUniqueId());
        if (ret == null) {
            return 0L;
        }
        ret = System.currentTimeMillis() - ret;
        return ret;
    }

    public static void setLastDamageMillis(Player player, long millis) {
        if (player == null) {
            return;
        }
        idToLastDamageMillis.put(player.getUniqueId(), millis);
    }

    public static void setLastDamageMillis(Player player) {
        PlayerUtil.setLastDamageMillis(player, System.currentTimeMillis());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void setLastDamageMillis(EntityDamageEvent event) {
        if (event.getDamage() <= 0.0) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        PlayerUtil.setLastDamageMillis(player);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void setLastDamageMillis(PlayerDeathEvent event) {
        PlayerUtil.setLastDamageMillis(event.getEntity());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void setLastDamageMillis(PlayerRespawnEvent event) {
        PlayerUtil.setLastDamageMillis(event.getPlayer());
    }

    public static long getLastDamageMillis(Player player) {
        if (player == null) {
            return 0L;
        }
        Long ret = idToLastDamageMillis.get(player.getUniqueId());
        if (ret == null) {
            return 0L;
        }
        return ret;
    }

    public static long getNoDamageMillis(Player player) {
        if (player == null) {
            return 0L;
        }
        if (player.isDead()) {
            return 0L;
        }
        if (!player.isOnline()) {
            return 0L;
        }
        return System.currentTimeMillis() - PlayerUtil.getLastDamageMillis(player);
    }

    public static boolean isDuplicateDeathEvent(PlayerDeathEvent event) {
        UUID id = event.getEntity().getUniqueId();
        PlayerDeathEvent current = idToDeathEvent.get(id);
        if (current != null) {
            return current != event;
        }
        idToDeathEvent.put(id, event);
        return false;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void isDuplicateDeathEventLowest(PlayerDeathEvent event) {
        PlayerUtil.isDuplicateDeathEvent(event);
    }

    public static boolean isDuplicateDamageEvent(EntityDamageByEntityEvent event) {
        Entity damager = MUtil.getLiableDamager((EntityDamageEvent)event);
        Entity damagee = event.getEntity();
        if (damager == null) {
            return false;
        }
        if (damagee == null) {
            return false;
        }
        String id = damager.getUniqueId().toString() + damagee.getUniqueId().toString();
        EntityDamageByEntityEvent current = idToDamageEvent.get(id);
        if (current != null) {
            return current != event;
        }
        idToDamageEvent.put(id, event);
        return false;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void isDuplicateDamageEventLowest(EntityDamageByEntityEvent event) {
        PlayerUtil.isDuplicateDamageEvent(event);
    }

    public static boolean isDuplicateArmSwingEvent(PlayerAnimationEvent event) {
        if (event.getAnimationType() != PlayerAnimationType.ARM_SWING) {
            return false;
        }
        UUID id = event.getPlayer().getUniqueId();
        PlayerAnimationEvent current = idToArmSwingEvent.get(id);
        if (current != null) {
            return current != event;
        }
        idToArmSwingEvent.put(id, event);
        return false;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void isDuplicateArmSwingEventLowest(PlayerAnimationEvent event) {
        PlayerUtil.isDuplicateArmSwingEvent(event);
    }

    public static void sendHealthFoodUpdatePacket(Player player) {
        player.setHealthScaled(player.isHealthScaled());
    }

    public static void update(Player player) {
        EventMassiveCorePlayerUpdate event = new EventMassiveCorePlayerUpdate(player);
        event.run();
        PlayerUtil.setMaxHealth(player, event.getMaxHealth());
        PlayerUtil.setFlyAllowed(player, event.isFlyAllowed());
        PlayerUtil.setFlyActive(player, event.isFlyActive());
        PlayerUtil.setFlySpeed(player, event.getFlySpeed());
    }

    public static void reset(Player player) {
        PlayerUtil.setMaxHealth(player, PlayerUtil.getMaxHealthDefault(player));
        PlayerUtil.setFlyAllowed(player, PlayerUtil.isFlyAllowedDefault(player));
        PlayerUtil.setFlyActive(player, PlayerUtil.isFlyActiveDefault(player));
        PlayerUtil.setFlySpeed(player, PlayerUtil.getFlySpeedDefault(player));
        PlayerUtil.update(player);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void reset(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.isDead()) {
            return;
        }
        PlayerUtil.reset(player);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void update(EventMassiveCoreAfterPlayerTeleport event) {
        Player player = event.getPlayer();
        if (player.isDead()) {
            return;
        }
        PlayerUtil.update(player);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void update(EventMassiveCoreAfterPlayerRespawn event) {
        Player player = event.getPlayer();
        if (player.isDead()) {
            return;
        }
        PlayerUtil.update(player);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void update(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (player.isDead()) {
            return;
        }
        PlayerUtil.update(player);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void update(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (player.isDead()) {
            return;
        }
        if (event.getFrom().getBlock().equals(event.getTo().getBlock())) {
            return;
        }
        PlayerUtil.update(player);
    }

    public static boolean setMaxHealth(Player player, double maxHealth) {
        if (PlayerUtil.getMaxHealth(player) == maxHealth) {
            return false;
        }
        player.setMaxHealth(maxHealth);
        return true;
    }

    public static double getMaxHealth(Player player) {
        return player.getMaxHealth();
    }

    public static double getMaxHealthDefault(Player player) {
        return 20.0;
    }

    public static boolean setFlyAllowed(Player player, boolean allowed) {
        if (PlayerUtil.isFlyAllowed(player) == allowed) {
            return false;
        }
        player.setFallDistance(0.0f);
        player.setAllowFlight(allowed);
        player.setFallDistance(0.0f);
        return true;
    }

    public static boolean isFlyAllowed(Player player) {
        return player.getAllowFlight();
    }

    public static boolean isFlyAllowedDefault(Player player) {
        return player.getGameMode() == GameMode.CREATIVE;
    }

    public static Long getLastFlyActive(Player player) {
        return idToLastFlyActive.get(player.getUniqueId());
    }

    public static void setLastFlyActive(Player player, Long millis) {
        idToLastFlyActive.put(player.getUniqueId(), millis);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void negateNoCheatPlusBug(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        Long lastActive = PlayerUtil.getLastFlyActive(player);
        if (lastActive == null) {
            return;
        }
        if (System.currentTimeMillis() - lastActive > 2000L) {
            return;
        }
        event.setCancelled(true);
    }

    public static boolean setFlyActive(Player player, boolean active) {
        if (active) {
            PlayerUtil.setLastFlyActive(player, System.currentTimeMillis());
        }
        if (PlayerUtil.isFlyActive(player) == active) {
            return false;
        }
        player.setFallDistance(0.0f);
        player.setFlying(active);
        player.setFallDistance(0.0f);
        return true;
    }

    public static boolean isFlyActive(Player player) {
        return player.isFlying();
    }

    public static boolean isFlyActiveDefault(Player player) {
        return player.getGameMode() == GameMode.CREATIVE;
    }

    public static boolean setFlySpeed(Player player, float speed) {
        if (PlayerUtil.getFlySpeed(player) == speed) {
            return false;
        }
        player.setFallDistance(0.0f);
        player.setFlySpeed(speed);
        player.setFallDistance(0.0f);
        return true;
    }

    public static float getFlySpeed(Player player) {
        return player.getFlySpeed();
    }

    public static float getFlySpeedDefault(Player player) {
        return 0.1f;
    }
}

