/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.util;

import com.massivecraft.massivecore.util.PermUtil;
import com.massivecraft.massivecore.util.Txt;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.permissions.Permissible;

public class SignUtil {
    public static final String SPECIAL_PREFIX_LENIENT = "[";
    public static final String SPECIAL_PREFIX_STRICT = "[" + ChatColor.DARK_GREEN.toString();
    public static final String SPECIAL_SUFFIX_LENIENT = "]";
    public static final String SPECIAL_SUFFIX_STRICT = ChatColor.BLACK.toString() + "]";

    public static String getSanitizedSpecialTitle(String title) {
        if (title == null) {
            throw new NullPointerException("title");
        }
        title = title.trim();
        title = ChatColor.stripColor((String)title);
        title = Txt.upperCaseFirst(title);
        return title;
    }

    public static String getSpecialLine(String title) {
        if (title == null) {
            throw new NullPointerException("title");
        }
        title = SignUtil.getSanitizedSpecialTitle(title);
        return SPECIAL_PREFIX_STRICT + title + SPECIAL_SUFFIX_STRICT;
    }

    public static String getSpecialTitle(String line, boolean strict) {
        if (line == null) {
            throw new NullPointerException("line");
        }
        String prefix = SPECIAL_PREFIX_STRICT;
        String suffix = SPECIAL_SUFFIX_STRICT;
        if (!strict) {
            line = line.trim();
            line = ChatColor.stripColor((String)line);
            prefix = SPECIAL_PREFIX_LENIENT;
            suffix = SPECIAL_SUFFIX_LENIENT;
        }
        if (!line.startsWith(prefix)) {
            return null;
        }
        if (!line.endsWith(suffix)) {
            return null;
        }
        String title = line.substring(prefix.length(), line.length() - suffix.length());
        title = SignUtil.getSanitizedSpecialTitle(title);
        return title;
    }

    public static String getSpecialTitle(String[] lines, boolean strict) {
        if (lines == null) {
            throw new NullPointerException("lines");
        }
        String line = lines[0];
        return SignUtil.getSpecialTitle(line, strict);
    }

    public static String getSpecialTitle(Sign sign, boolean strict) {
        if (sign == null) {
            throw new NullPointerException("sign");
        }
        String[] lines = sign.getLines();
        return SignUtil.getSpecialTitle(lines, strict);
    }

    public static String getSpecialTitle(Block block, boolean strict) {
        if (block == null) {
            throw new NullPointerException("block");
        }
        Sign sign = SignUtil.getSign(block);
        if (sign == null) {
            return null;
        }
        return SignUtil.getSpecialTitle(sign, strict);
    }

    public static boolean handleSpecialPermissionFix(SignChangeEvent event, String title, String permissionNode) {
        if (event == null) {
            throw new NullPointerException("event");
        }
        if (title == null) {
            throw new NullPointerException("title");
        }
        if (permissionNode == null) {
            throw new NullPointerException("permissionNode");
        }
        Player player = event.getPlayer();
        String lenientTitle = SignUtil.getSpecialTitle(event.getLines(), false);
        if (lenientTitle == null) {
            return false;
        }
        if (!title.equalsIgnoreCase(lenientTitle)) {
            return false;
        }
        if (!PermUtil.has((Permissible)player, permissionNode, true)) {
            event.setCancelled(true);
            return false;
        }
        event.setLine(0, SignUtil.getSpecialLine(title));
        return true;
    }

    public static Block getSpecialPillarTop(Block block) {
        World world = block.getWorld();
        int maxHeight = world.getMaxHeight();
        while (SignUtil.isSign(block) && block.getY() < maxHeight) {
            if (SignUtil.getSpecialTitle(block, true) != null) {
                return block;
            }
            block = block.getRelative(0, 1, 0);
        }
        return null;
    }

    public static List<Block> getSpecialPillarFromTop(Block block) {
        if (block == null) {
            throw new NullPointerException("block");
        }
        if (SignUtil.getSpecialTitle(block, true) == null) {
            throw new InvalidParameterException("block");
        }
        ArrayList<Block> ret = new ArrayList<Block>();
        do {
            ret.add(block);
        } while (SignUtil.isSign(block = block.getRelative(0, -1, 0)) && SignUtil.getSpecialTitle(block, true) == null);
        return ret;
    }

    public static List<Block> getSpecialPillar(Block block) {
        if (block == null) {
            throw new NullPointerException("block");
        }
        if ((block = SignUtil.getSpecialPillarTop(block)) == null) {
            return null;
        }
        return SignUtil.getSpecialPillarFromTop(block);
    }

    public static List<String> getSpecialPillarLines(Block block, String title) {
        String specialLine;
        String specialTitle;
        if (block == null) {
            throw new NullPointerException("block");
        }
        List<Block> blocks = SignUtil.getSpecialPillar(block);
        if (blocks == null) {
            return null;
        }
        List<String> lines = SignUtil.getLines(blocks);
        if (lines == null) {
            return null;
        }
        if (title != null && !title.equalsIgnoreCase(specialTitle = SignUtil.getSpecialTitle(specialLine = lines.remove(0), true))) {
            return null;
        }
        return lines;
    }

    public static List<String> getSpecialPillarLines(PlayerInteractEvent event, String title) {
        if (event == null) {
            throw new NullPointerException("event");
        }
        if (title == null) {
            throw new NullPointerException("title");
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return null;
        }
        List<String> lines = SignUtil.getSpecialPillarLines(block, title);
        if (lines == null) {
            return null;
        }
        return lines;
    }

    public static boolean isSign(Material material) {
        if (material == null) {
            throw new NullPointerException("material");
        }
        if (material == Material.SIGN) {
            return true;
        }
        if (material == Material.SIGN_POST) {
            return true;
        }
        return material == Material.WALL_SIGN;
    }

    public static boolean isSign(Block block) {
        if (block == null) {
            throw new NullPointerException("block");
        }
        return SignUtil.isSign(block.getType());
    }

    public static Sign getSign(Block block) {
        BlockState blockState = block.getState();
        if (!(blockState instanceof Sign)) {
            return null;
        }
        return (Sign)blockState;
    }

    public static List<String> getLines(List<Block> blocks) {
        if (blocks == null) {
            throw new NullPointerException("blocks");
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (Block block : blocks) {
            List<String> lines = SignUtil.getLines(block);
            if (lines == null) continue;
            ret.addAll(lines);
        }
        return ret;
    }

    public static List<String> getLines(Block block) {
        if (block == null) {
            throw new NullPointerException("block");
        }
        Sign sign = SignUtil.getSign(block);
        if (sign == null) {
            return null;
        }
        return SignUtil.getLines(sign);
    }

    public static List<String> getLines(Sign sign) {
        if (sign == null) {
            throw new NullPointerException("sign");
        }
        return new ArrayList<String>(Arrays.asList(sign.getLines()));
    }
}

