/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.util;

import java.util.Collection;
import java.util.Random;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.bukkit.Effect;
import org.bukkit.Location;

public class SmokeUtil {
    public static Random random = new Random();
    public static MutableBoolean fakeExplosion = new MutableBoolean(false);

    public static void spawnSingle(Location location, int direction) {
        if (location == null) {
            return;
        }
        location.getWorld().playEffect(location, Effect.SMOKE, direction);
    }

    public static void spawnSingle(Location location) {
        SmokeUtil.spawnSingle(location, 4);
    }

    public static void spawnSingleRandom(Location location) {
        SmokeUtil.spawnSingle(location, random.nextInt(9));
    }

    public static void spawnCloudSimple(Location location) {
        for (int i = 0; i <= 8; ++i) {
            SmokeUtil.spawnSingle(location, i);
        }
    }

    public static void spawnCloudSimple(Collection<Location> locations) {
        for (Location location : locations) {
            SmokeUtil.spawnCloudSimple(location);
        }
    }

    public static void spawnCloudRandom(Location location, float thickness) {
        int singles = (int)Math.floor(thickness * 9.0f);
        for (int i = 0; i < singles; ++i) {
            SmokeUtil.spawnSingleRandom(location);
        }
    }

    public static void spawnCloudRandom(Collection<Location> locations, float thickness) {
        for (Location location : locations) {
            SmokeUtil.spawnCloudRandom(location, thickness);
        }
    }

    public static void fakeExplosion(Location location) {
        SmokeUtil.fakeExplosion(location, 4.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fakeExplosion(Location location, float power) {
        MutableBoolean mutableBoolean = fakeExplosion;
        synchronized (mutableBoolean) {
            fakeExplosion.setValue(true);
            location.getWorld().createExplosion(location.getX(), location.getY(), location.getZ(), power, false, false);
            fakeExplosion.setValue(false);
        }
    }

    @Deprecated
    public static void fakeExplosion(Location location, int viewDistance) {
        SmokeUtil.fakeExplosion(location);
    }
}

