/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.util;

import com.massivecraft.massivecore.util.TimeUnit;
import com.massivecraft.massivecore.util.Txt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeDiffUtil {
    public static final Pattern patternFull = Pattern.compile("^(?:([^a-zA-Z]+)([a-zA-Z]*))+$");
    public static final Pattern patternPart = Pattern.compile("([^a-zA-Z]+)([a-zA-Z]*)");
    public static final String FORMAT_ENTRY_VERBOOSE = Txt.parse("<v>%1$d<k>%3$s");
    public static final String FORMAT_COMMA_VERBOOSE = "%s, ";
    public static final String FORMAT_AND_VERBOOSE = " %sand ";
    public static final String FORMAT_ENTRY_MINIMAL = Txt.parse("<v>%1$d<k>%2$s");
    public static final String FORMAT_COMMA_MINIMAL = "%s";
    public static final String FORMAT_AND_MINIMAL = "%s";

    public static long millis(TimeUnit timeUnit, long count) {
        return timeUnit.millis * count;
    }

    public static long millis(TimeUnit timeUnit) {
        return TimeDiffUtil.millis(timeUnit, 1L);
    }

    public static long millis(Map<TimeUnit, Long> unitcounts, long count) {
        long ret = 0L;
        for (Map.Entry<TimeUnit, Long> entry : unitcounts.entrySet()) {
            ret += TimeDiffUtil.millis(entry.getKey(), entry.getValue() * count);
        }
        return ret;
    }

    public static long millis(Map<TimeUnit, Long> unitcounts) {
        return TimeDiffUtil.millis(unitcounts, 1L);
    }

    public static long millis(String formated, long count) throws Exception {
        LinkedHashMap<TimeUnit, Long> unitcount = TimeDiffUtil.unitcounts(formated);
        return TimeDiffUtil.millis(unitcount, count);
    }

    public static long millis(String formated) throws Exception {
        return TimeDiffUtil.millis(formated, 1L);
    }

    public static LinkedHashMap<TimeUnit, Long> unitcounts(String formated) throws Exception {
        if (formated == null) {
            throw new NullPointerException("The string can't be null.");
        }
        Matcher matcherFull = patternFull.matcher(formated);
        if (!matcherFull.matches()) {
            throw new NullPointerException("Invalid time diff format.");
        }
        LinkedHashMap<TimeUnit, Long> ret = new LinkedHashMap<TimeUnit, Long>();
        if (formated.equals("0")) {
            return ret;
        }
        Matcher matcherPart = patternPart.matcher(formated);
        while (matcherPart.find()) {
            String countString = matcherPart.group(1);
            String countStringFixed = countString.replaceAll("[\\+\\s]", "");
            long count = 0L;
            try {
                count = Long.parseLong(countStringFixed);
            }
            catch (Exception e) {
                throw new Exception("\"" + countString + "\" is not a valid integer.");
            }
            String unitString = matcherPart.group(2);
            TimeUnit unit = TimeUnit.get(unitString);
            if (unit == null) {
                throw new Exception("\"" + unit + "\" is not a valid time unit.");
            }
            if (ret.put(unit, count) == null) continue;
            throw new Exception("Multiple " + unit.singularName + " entries is not allowed.");
        }
        return ret;
    }

    public static LinkedHashMap<TimeUnit, Long> unitcounts(long millis, TreeSet<TimeUnit> units) {
        long millisLeft = Math.abs(millis);
        LinkedHashMap<TimeUnit, Long> ret = new LinkedHashMap<TimeUnit, Long>();
        for (TimeUnit unit : units) {
            long count = (long)Math.floor(millisLeft / unit.millis);
            if (count < 1L) continue;
            millisLeft -= unit.millis * count;
            ret.put(unit, count);
        }
        return ret;
    }

    public static LinkedHashMap<TimeUnit, Long> unitcounts(long millis) {
        return TimeDiffUtil.unitcounts(millis, TimeUnit.getAll());
    }

    public static LinkedHashMap<TimeUnit, Long> limit(LinkedHashMap<TimeUnit, Long> unitcounts, int limit) {
        LinkedHashMap<TimeUnit, Long> ret = new LinkedHashMap<TimeUnit, Long>();
        Iterator<Map.Entry<TimeUnit, Long>> iter = unitcounts.entrySet().iterator();
        for (int i = 0; iter.hasNext() && i < limit; ++i) {
            Map.Entry<TimeUnit, Long> entry = iter.next();
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    public static String formated(TimeUnit unit, long count, String formatEntry) {
        return String.format(formatEntry, count, unit.getUnitString(count), unit.getNameString(count));
    }

    public static String formated(Map<TimeUnit, Long> unitcounts, String entryFormat, String commaFormat, String andFormat, String color) {
        String comma = String.format(commaFormat, Txt.parse(color));
        String and = String.format(andFormat, Txt.parse(color));
        if (unitcounts.isEmpty()) {
            return TimeDiffUtil.formated(TimeUnit.SECOND, 0L, entryFormat);
        }
        ArrayList<String> parts = new ArrayList<String>();
        for (Map.Entry<TimeUnit, Long> entry : unitcounts.entrySet()) {
            parts.add(TimeDiffUtil.formated(entry.getKey(), entry.getValue(), entryFormat));
        }
        return Txt.implodeCommaAnd(parts, comma, and);
    }

    public static String formatedVerboose(TimeUnit unit, long count) {
        return TimeDiffUtil.formated(unit, count, FORMAT_ENTRY_VERBOOSE);
    }

    public static String formatedVerboose(Map<TimeUnit, Long> unitcounts, String color) {
        return TimeDiffUtil.formated(unitcounts, FORMAT_ENTRY_VERBOOSE, FORMAT_COMMA_VERBOOSE, FORMAT_AND_VERBOOSE, color);
    }

    public static String formatedVerboose(Map<TimeUnit, Long> unitcounts) {
        return TimeDiffUtil.formatedVerboose(unitcounts, "<i>");
    }

    public static String formatedMinimal(TimeUnit unit, long count) {
        return TimeDiffUtil.formated(unit, count, FORMAT_ENTRY_MINIMAL);
    }

    public static String formatedMinimal(Map<TimeUnit, Long> unitcounts, String color) {
        return TimeDiffUtil.formated(unitcounts, FORMAT_ENTRY_MINIMAL, "%s", "%s", color);
    }

    public static String formatedMinimal(Map<TimeUnit, Long> unitcounts) {
        return TimeDiffUtil.formatedMinimal(unitcounts, "");
    }
}

