/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;

public class TimeUnit
implements Comparable<TimeUnit> {
    public static final long MILLIS_PER_MILLISECOND = 1L;
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final long MILLIS_PER_WEEK = 604800000L;
    public static final long MILLIS_PER_MONTH = 2678400000L;
    public static final long MILLIS_PER_MONTHUP = 2764800000L;
    public static final long MILLIS_PER_YEAR = 31536000000L;
    public static final TimeUnit YEAR = new TimeUnit(31536000000L, "year", "years", "year", "years", "y", "year", "years");
    public static final TimeUnit MONTH = new TimeUnit(2678400000L, "month", "months", "month", "months", "month", "months");
    public static final TimeUnit WEEK = new TimeUnit(604800000L, "week", "weeks", "week", "weeks", "w", "week", "weeks");
    public static final TimeUnit DAY = new TimeUnit(86400000L, "day", "days", "day", "days", "d", "day", "days");
    public static final TimeUnit HOUR = new TimeUnit(3600000L, "hour", "hours", "h", "h", "h", "hs", "hour", "hours");
    public static final TimeUnit MINUTE = new TimeUnit(60000L, "minute", "minutes", "min", "min", "m", "min", "mins", "minute", "minutes");
    public static final TimeUnit SECOND = new TimeUnit(1000L, "second", "seconds", "s", "s", "s", "sec", "secs", "second", "seconds");
    public static final TimeUnit MILLISECOND = new TimeUnit(1L, "millisecond", "milliseconds", "ms", "ms", "millis", "millisec", "millisecs", "millisecond", "milliseconds", "ms", "msec", "msecs", "msecond", "mseconds");
    private static final TreeSet<TimeUnit> all = new TreeSet();
    public final long millis;
    public final String singularName;
    public final String pluralName;
    public final String singularUnit;
    public final String pluralUnit;
    public final Collection<String> aliases;

    public static TreeSet<TimeUnit> getAll() {
        return new TreeSet<TimeUnit>((SortedSet<TimeUnit>)all);
    }

    public static TreeSet<TimeUnit> getAllBut(TimeUnit ... timeUnits) {
        TreeSet<TimeUnit> ret = new TreeSet<TimeUnit>((SortedSet<TimeUnit>)all);
        for (TimeUnit timeUnit : timeUnits) {
            ret.remove(timeUnit);
        }
        return ret;
    }

    public static TreeSet<TimeUnit> getAllButMillis() {
        return TimeUnit.getAllBut(MILLISECOND);
    }

    public static TreeSet<TimeUnit> getAllButMillisAndSeconds() {
        return TimeUnit.getAllBut(MILLISECOND, SECOND);
    }

    public static TreeSet<TimeUnit> getAllButMillisSecondsAndMinutes() {
        return TimeUnit.getAllBut(MILLISECOND, SECOND, MINUTE);
    }

    public static TreeSet<TimeUnit> getSpecific(TimeUnit ... timeUnits) {
        TreeSet<TimeUnit> ret = new TreeSet<TimeUnit>(Arrays.asList(timeUnits));
        return ret;
    }

    public static TimeUnit get(String timeUnitString) {
        if (timeUnitString == null) {
            return null;
        }
        String timeUnitStringLowerCase = timeUnitString.toLowerCase();
        for (TimeUnit timeUnit : all) {
            for (String alias : timeUnit.aliases) {
                if (!alias.equals(timeUnitStringLowerCase)) continue;
                return timeUnit;
            }
        }
        return null;
    }

    public static boolean register(TimeUnit timeUnit) {
        return all.add(timeUnit);
    }

    private TimeUnit(long millis, String singularName, String pluralName, String singularUnit, String pluralUnit, String ... aliases) {
        this.millis = millis;
        this.singularName = singularName;
        this.pluralName = pluralName;
        this.singularUnit = singularUnit;
        this.pluralUnit = pluralUnit;
        this.aliases = new ArrayList<String>(Arrays.asList(aliases));
    }

    public String getUnitString(long amount) {
        if (amount == 1L) {
            return this.singularUnit;
        }
        return this.pluralUnit;
    }

    public String getNameString(long amount) {
        if (amount == 1L) {
            return this.singularName;
        }
        return this.pluralName;
    }

    public String toString() {
        return this.singularName;
    }

    @Override
    public int compareTo(TimeUnit that) {
        return Long.valueOf(this.millis).compareTo(that.millis) * -1;
    }

    public final boolean equals(Object other) {
        if (!(other instanceof TimeUnit)) {
            return false;
        }
        return this.millis == ((TimeUnit)other).millis;
    }

    public final int hashCode() {
        return (int)(this.millis ^ this.millis >>> 32);
    }

    static {
        TimeUnit.register(YEAR);
        TimeUnit.register(MONTH);
        TimeUnit.register(WEEK);
        TimeUnit.register(DAY);
        TimeUnit.register(HOUR);
        TimeUnit.register(MINUTE);
        TimeUnit.register(SECOND);
        TimeUnit.register(MILLISECOND);
    }
}

