/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.util;

import com.massivecraft.massivecore.util.MUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Txt {
    public static final int PAGEHEIGHT_PLAYER = 9;
    public static final int PAGEHEIGHT_CONSOLE = 50;
    public static final Map<String, String> parseReplacements;
    public static final Pattern parsePattern;
    public static final long millisPerSecond = 1000L;
    public static final long millisPerMinute = 60000L;
    public static final long millisPerHour = 3600000L;
    public static final long millisPerDay = 86400000L;
    public static final long millisPerWeek = 604800000L;
    public static final long millisPerMonth = 2678400000L;
    public static final long millisPerYear = 31536000000L;
    public static final Set<String> vowel;
    public static final Map<String, Long> unitMillis;
    public static final String START_COLORS_REGEX = "^((?:\u00a7.)+).*$";
    public static final Pattern START_COLORS_PATTERN;
    private static final String titleizeLine;
    private static final int titleizeBalance = -1;

    private Txt() {
    }

    public static String parse(String string) {
        StringBuffer ret = new StringBuffer();
        Matcher matcher = parsePattern.matcher(string);
        while (matcher.find()) {
            matcher.appendReplacement(ret, parseReplacements.get(matcher.group(0)));
        }
        matcher.appendTail(ret);
        return ret.toString();
    }

    public static String parse(String string, Object ... args) {
        return String.format(Txt.parse(string), args);
    }

    public static ArrayList<String> parse(Collection<String> strings) {
        ArrayList<String> ret = new ArrayList<String>(strings.size());
        for (String string : strings) {
            ret.add(Txt.parse(string));
        }
        return ret;
    }

    public static ArrayList<String> wrap(String string) {
        return new ArrayList<String>(Arrays.asList(string.split("\\r?\\n")));
    }

    public static ArrayList<String> wrap(Collection<String> strings) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String string : strings) {
            ret.addAll(Txt.wrap(string));
        }
        return ret;
    }

    public static ArrayList<String> parseWrap(String string) {
        return Txt.wrap(Txt.parse(string));
    }

    public static ArrayList<String> parseWrap(Collection<String> strings) {
        return Txt.wrap(Txt.parse(strings));
    }

    public static String upperCaseFirst(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String repeat(String string, int times) {
        if (times <= 0) {
            return "";
        }
        return string + Txt.repeat(string, times - 1);
    }

    public static String implode(Object[] list, String glue, String format) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < list.length; ++i) {
            String str;
            Object item = list[i];
            String string = str = item == null ? "NULL" : item.toString();
            if (i != 0) {
                ret.append(glue);
            }
            if (format != null) {
                ret.append(String.format(format, str));
                continue;
            }
            ret.append(str);
        }
        return ret.toString();
    }

    public static String implode(Object[] list, String glue) {
        return Txt.implode(list, glue, null);
    }

    public static String implode(Collection<? extends Object> coll, String glue, String format) {
        return Txt.implode(coll.toArray(new Object[0]), glue, format);
    }

    public static String implode(Collection<? extends Object> coll, String glue) {
        return Txt.implode(coll, glue, null);
    }

    public static String implodeCommaAndDot(Collection<? extends Object> objects, String format, String comma, String and, String dot) {
        if (objects.size() == 0) {
            return "";
        }
        if (objects.size() == 1) {
            return Txt.implode(objects, comma, format);
        }
        ArrayList<? extends Object> ourObjects = new ArrayList<Object>(objects);
        String lastItem = ourObjects.get(ourObjects.size() - 1).toString();
        String nextToLastItem = ourObjects.get(ourObjects.size() - 2).toString();
        if (format != null) {
            lastItem = String.format(format, lastItem);
            nextToLastItem = String.format(format, nextToLastItem);
        }
        String merge = nextToLastItem + and + lastItem;
        ourObjects.set(ourObjects.size() - 2, merge);
        ourObjects.remove(ourObjects.size() - 1);
        return Txt.implode(ourObjects, comma, format) + dot;
    }

    public static String implodeCommaAndDot(Collection<? extends Object> objects, String comma, String and, String dot) {
        return Txt.implodeCommaAndDot(objects, null, comma, and, dot);
    }

    public static String implodeCommaAnd(Collection<? extends Object> objects, String comma, String and) {
        return Txt.implodeCommaAndDot(objects, comma, and, "");
    }

    public static String implodeCommaAndDot(Collection<? extends Object> objects, String color) {
        return Txt.implodeCommaAndDot(objects, color + ", ", color + " and ", color + ".");
    }

    public static String implodeCommaAnd(Collection<? extends Object> objects, String color) {
        return Txt.implodeCommaAndDot(objects, color + ", ", color + " and ", "");
    }

    public static String implodeCommaAndDot(Collection<? extends Object> objects) {
        return Txt.implodeCommaAndDot(objects, "");
    }

    public static String implodeCommaAnd(Collection<? extends Object> objects) {
        return Txt.implodeCommaAnd(objects, "");
    }

    public static Integer indexOfFirstDigit(String str) {
        Integer ret = null;
        for (int i = 0; i < str.length(); ++i) {
            boolean isDigit;
            char c = str.charAt(i);
            boolean bl = isDigit = c >= '0' && c <= '9';
            if (!isDigit) continue;
            ret = i;
            break;
        }
        return ret;
    }

    public static String removeLeadingCommandDust(String string) {
        return string.replaceAll("^[/\\s]+", "");
    }

    public static Map.Entry<String, String> divideOnFirstSpace(String string) {
        String[] parts = string.split("\\s+", 2);
        String first = parts[0];
        String second = null;
        if (parts.length > 1) {
            second = parts[1];
        }
        return new AbstractMap.SimpleEntry<String, String>(first, second);
    }

    public static boolean isVowel(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        return vowel.contains(str.substring(0, 1));
    }

    public static String aan(String noun) {
        return Txt.isVowel(noun) ? "an" : "a";
    }

    public static String getStartColors(String string) {
        Matcher matcher = START_COLORS_PATTERN.matcher(string);
        if (!matcher.find()) {
            return "";
        }
        return matcher.group(1);
    }

    public static String getNicedEnumString(String str) {
        ArrayList<String> parts = new ArrayList<String>();
        for (String part : str.toLowerCase().split("_")) {
            parts.add(Txt.upperCaseFirst(part));
        }
        return Txt.implode(parts, " ");
    }

    public static String getNicedEnum(Object enumObject) {
        return Txt.getNicedEnumString(enumObject.toString());
    }

    public static String getMaterialName(Material material) {
        return Txt.getNicedEnum(material);
    }

    public static String titleize(String str) {
        String center = ".[ " + Txt.parse("<l>") + str + Txt.parse("<a>") + " ].";
        int centerlen = ChatColor.stripColor((String)center).length();
        int pivot = titleizeLine.length() / 2;
        int eatLeft = centerlen / 2 - -1;
        int eatRight = centerlen - eatLeft + -1;
        if (eatLeft < pivot) {
            return Txt.parse("<a>") + titleizeLine.substring(0, pivot - eatLeft) + center + titleizeLine.substring(pivot + eatRight);
        }
        return Txt.parse("<a>") + center;
    }

    public static ArrayList<String> getPage(List<String> lines, int pageHumanBased, String title) {
        return Txt.getPage(lines, pageHumanBased, title, 9);
    }

    public static ArrayList<String> getPage(List<String> lines, int pageHumanBased, String title, CommandSender sender) {
        return Txt.getPage(lines, pageHumanBased, title, sender instanceof Player ? 9 : 50);
    }

    public static ArrayList<String> getPage(List<String> lines, int pageHumanBased, String title, int pageheight) {
        ArrayList<String> ret = new ArrayList<String>();
        int pageZeroBased = pageHumanBased - 1;
        int pagecount = (int)Math.ceil((double)lines.size() / (double)pageheight);
        ret.add(Txt.titleize(title + Txt.parse("<a>") + " " + pageHumanBased + "/" + pagecount));
        if (pagecount == 0) {
            ret.add(Txt.parse("<i>Sorry. No Pages available."));
            return ret;
        }
        if (pageZeroBased < 0 || pageHumanBased > pagecount) {
            ret.add(Txt.parse("<i>Invalid page. Must be between 1 and " + pagecount));
            return ret;
        }
        int from = pageZeroBased * pageheight;
        int to = from + pageheight;
        if (to > lines.size()) {
            to = lines.size();
        }
        ret.addAll(lines.subList(from, to));
        return ret;
    }

    public static String getTimeDeltaDescriptionRelNow(long millis) {
        String ret = "";
        double millisLeft = Math.abs(millis);
        ArrayList<String> unitCountParts = new ArrayList<String>();
        for (Map.Entry<String, Long> entry : unitMillis.entrySet()) {
            if (unitCountParts.size() == 3) break;
            String unitName = entry.getKey();
            long unitSize = entry.getValue();
            long unitCount = (long)Math.floor(millisLeft / (double)unitSize);
            if (unitCount < 1L) continue;
            millisLeft -= (double)(unitSize * unitCount);
            unitCountParts.add(unitCount + " " + unitName);
        }
        if (unitCountParts.size() == 0) {
            return "just now";
        }
        ret = ret + Txt.implodeCommaAnd(unitCountParts);
        ret = ret + " ";
        ret = millis <= 0L ? ret + "ago" : ret + "from now";
        return ret;
    }

    public static String removeSmartQuotes(String string) {
        if (string == null) {
            return null;
        }
        string = string.replace("\u2018", "'");
        string = string.replace("\u2019", "'");
        string = string.replace("\u201c", "\"");
        string = string.replace("\u201d", "\"");
        string = string.replace("\u2024", ".");
        string = string.replace("\u2025", "..");
        string = string.replace("\u2026", "...");
        return string;
    }

    public static String getBestCIStart(Collection<String> candidates, String start) {
        String ret = null;
        int best = 0;
        start = start.toLowerCase();
        int minlength = start.length();
        for (String candidate : candidates) {
            if (candidate.length() < minlength || !candidate.toLowerCase().startsWith(start)) continue;
            int lendiff = candidate.length() - minlength;
            if (lendiff == 0) {
                return candidate;
            }
            if (lendiff >= best && best != 0) continue;
            best = lendiff;
            ret = candidate;
        }
        return ret;
    }

    public static List<String> tokenizeArguments(String str) {
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder token = null;
        boolean escaping = false;
        boolean citing = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (token == null) {
                token = new StringBuilder();
            }
            if (escaping) {
                escaping = false;
                token.append(c);
                continue;
            }
            if (c == '\\') {
                escaping = true;
                continue;
            }
            if (c == '\"') {
                if (citing || token.length() > 0) {
                    ret.add(token.toString());
                    token = null;
                }
                citing = !citing;
                continue;
            }
            if (!citing && c == ' ') {
                if (token.length() <= 0) continue;
                ret.add(token.toString());
                token = null;
                continue;
            }
            token.append(c);
        }
        if (token != null) {
            ret.add(token.toString());
        }
        return ret;
    }

    static {
        vowel = MUtil.set("A", "E", "I", "O", "U", "Y", "\u00c5", "\u00c4", "\u00d6", "\u00c6", "\u00d8", "a", "e", "i", "o", "u", "y", "\u00e5", "\u00e4", "\u00f6", "\u00e6", "\u00f8");
        unitMillis = MUtil.map("years", 31536000000L, "months", 2678400000L, "weeks", 604800000L, "days", 86400000L, "hours", 3600000L, "minutes", 60000L, "seconds", 1000L);
        parseReplacements = new HashMap<String, String>();
        parseReplacements.put("<empty>", "");
        parseReplacements.put("<black>", "\u00a70");
        parseReplacements.put("<navy>", "\u00a71");
        parseReplacements.put("<green>", "\u00a72");
        parseReplacements.put("<teal>", "\u00a73");
        parseReplacements.put("<red>", "\u00a74");
        parseReplacements.put("<purple>", "\u00a75");
        parseReplacements.put("<gold>", "\u00a76");
        parseReplacements.put("<silver>", "\u00a77");
        parseReplacements.put("<gray>", "\u00a78");
        parseReplacements.put("<blue>", "\u00a79");
        parseReplacements.put("<lime>", "\u00a7a");
        parseReplacements.put("<aqua>", "\u00a7b");
        parseReplacements.put("<rose>", "\u00a7c");
        parseReplacements.put("<pink>", "\u00a7d");
        parseReplacements.put("<yellow>", "\u00a7e");
        parseReplacements.put("<white>", "\u00a7f");
        parseReplacements.put("<magic>", "\u00a7k");
        parseReplacements.put("<bold>", "\u00a7l");
        parseReplacements.put("<strong>", "\u00a7l");
        parseReplacements.put("<strike>", "\u00a7m");
        parseReplacements.put("<strikethrough>", "\u00a7m");
        parseReplacements.put("<under>", "\u00a7n");
        parseReplacements.put("<underline>", "\u00a7n");
        parseReplacements.put("<italic>", "\u00a7o");
        parseReplacements.put("<em>", "\u00a7o");
        parseReplacements.put("<reset>", "\u00a7r");
        parseReplacements.put("<l>", "\u00a72");
        parseReplacements.put("<logo>", "\u00a72");
        parseReplacements.put("<a>", "\u00a76");
        parseReplacements.put("<art>", "\u00a76");
        parseReplacements.put("<n>", "\u00a77");
        parseReplacements.put("<notice>", "\u00a77");
        parseReplacements.put("<i>", "\u00a7e");
        parseReplacements.put("<info>", "\u00a7e");
        parseReplacements.put("<g>", "\u00a7a");
        parseReplacements.put("<good>", "\u00a7a");
        parseReplacements.put("<b>", "\u00a7c");
        parseReplacements.put("<bad>", "\u00a7c");
        parseReplacements.put("<k>", "\u00a7b");
        parseReplacements.put("<key>", "\u00a7b");
        parseReplacements.put("<v>", "\u00a7d");
        parseReplacements.put("<value>", "\u00a7d");
        parseReplacements.put("<h>", "\u00a7d");
        parseReplacements.put("<highlight>", "\u00a7d");
        parseReplacements.put("<c>", "\u00a7b");
        parseReplacements.put("<command>", "\u00a7b");
        parseReplacements.put("<p>", "\u00a73");
        parseReplacements.put("<parameter>", "\u00a73");
        parseReplacements.put("&&", "&");
        parseReplacements.put("\u00a7\u00a7", "\u00a7");
        for (int i = 48; i <= 122; ++i) {
            char c = (char)i;
            parseReplacements.put("\u00a7" + c, "\u00a7" + c);
            parseReplacements.put("&" + c, "\u00a7" + c);
            if (i != 57) continue;
            i = 96;
        }
        StringBuilder patternStringBuilder = new StringBuilder();
        for (String find : parseReplacements.keySet()) {
            patternStringBuilder.append('(');
            patternStringBuilder.append(Pattern.quote(find));
            patternStringBuilder.append(")|");
        }
        String patternString = patternStringBuilder.toString();
        patternString = patternString.substring(0, patternString.length() - 1);
        parsePattern = Pattern.compile(patternString);
        START_COLORS_PATTERN = Pattern.compile(START_COLORS_REGEX);
        titleizeLine = Txt.repeat("_", 52);
    }
}

