/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.util.extractor;

import com.massivecraft.massivecore.mixin.Mixin;
import com.massivecraft.massivecore.ps.PS;
import com.massivecraft.massivecore.util.IdUtil;
import com.massivecraft.massivecore.util.MUtil;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;

public class ExtractorLogic {
    public static CommandSender sender(String o) {
        return IdUtil.getSender(o);
    }

    public static CommandSender sender(PlayerEvent o) {
        return o.getPlayer();
    }

    public static CommandSender sender(BlockBreakEvent o) {
        return o.getPlayer();
    }

    public static CommandSender sender(BlockDamageEvent o) {
        return o.getPlayer();
    }

    public static CommandSender sender(BlockIgniteEvent o) {
        return o.getPlayer();
    }

    public static CommandSender sender(BlockPlaceEvent o) {
        return o.getPlayer();
    }

    public static CommandSender sender(SignChangeEvent o) {
        return o.getPlayer();
    }

    public static CommandSender sender(EnchantItemEvent o) {
        return o.getEnchanter();
    }

    public static CommandSender sender(PrepareItemEnchantEvent o) {
        return o.getEnchanter();
    }

    public static CommandSender sender(Entity o) {
        if (o instanceof CommandSender) {
            return (CommandSender)o;
        }
        return null;
    }

    public static CommandSender sender(EntityEvent o) {
        return ExtractorLogic.sender(o.getEntity());
    }

    public static CommandSender sender(InventoryClickEvent o) {
        return ExtractorLogic.sender((Entity)o.getWhoClicked());
    }

    public static CommandSender sender(InventoryCloseEvent o) {
        return ExtractorLogic.sender((Entity)o.getPlayer());
    }

    public static CommandSender sender(InventoryOpenEvent o) {
        return ExtractorLogic.sender((Entity)o.getPlayer());
    }

    public static CommandSender sender(HangingBreakByEntityEvent o) {
        return ExtractorLogic.sender(o.getRemover());
    }

    public static CommandSender sender(VehicleDamageEvent o) {
        return ExtractorLogic.sender(o.getAttacker());
    }

    public static CommandSender sender(VehicleDestroyEvent o) {
        return ExtractorLogic.sender(o.getAttacker());
    }

    public static CommandSender sender(VehicleEnterEvent o) {
        return ExtractorLogic.sender(o.getEntered());
    }

    public static CommandSender sender(VehicleExitEvent o) {
        return ExtractorLogic.sender((Entity)o.getExited());
    }

    public static CommandSender sender(VehicleEvent o) {
        return ExtractorLogic.sender(o.getVehicle().getPassenger());
    }

    public static CommandSender senderFromObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof CommandSender) {
            return (CommandSender)o;
        }
        if (o instanceof String) {
            return ExtractorLogic.sender((String)o);
        }
        if (o instanceof PlayerEvent) {
            return ExtractorLogic.sender((PlayerEvent)o);
        }
        if (o instanceof BlockBreakEvent) {
            return ExtractorLogic.sender((BlockBreakEvent)o);
        }
        if (o instanceof BlockDamageEvent) {
            return ExtractorLogic.sender((BlockDamageEvent)o);
        }
        if (o instanceof BlockIgniteEvent) {
            return ExtractorLogic.sender((BlockIgniteEvent)o);
        }
        if (o instanceof BlockPlaceEvent) {
            return ExtractorLogic.sender((BlockPlaceEvent)o);
        }
        if (o instanceof SignChangeEvent) {
            return ExtractorLogic.sender((SignChangeEvent)o);
        }
        if (o instanceof EnchantItemEvent) {
            return ExtractorLogic.sender((EnchantItemEvent)o);
        }
        if (o instanceof PrepareItemEnchantEvent) {
            return ExtractorLogic.sender((PrepareItemEnchantEvent)o);
        }
        if (o instanceof Entity) {
            return ExtractorLogic.sender((Entity)o);
        }
        if (o instanceof EntityEvent) {
            return ExtractorLogic.sender((EntityEvent)o);
        }
        if (o instanceof InventoryClickEvent) {
            return ExtractorLogic.sender((InventoryClickEvent)o);
        }
        if (o instanceof InventoryCloseEvent) {
            return ExtractorLogic.sender((InventoryCloseEvent)o);
        }
        if (o instanceof InventoryOpenEvent) {
            return ExtractorLogic.sender((InventoryOpenEvent)o);
        }
        if (o instanceof HangingBreakByEntityEvent) {
            return ExtractorLogic.sender((HangingBreakByEntityEvent)o);
        }
        if (o instanceof VehicleDamageEvent) {
            return ExtractorLogic.sender((VehicleDamageEvent)o);
        }
        if (o instanceof VehicleDestroyEvent) {
            return ExtractorLogic.sender((VehicleDestroyEvent)o);
        }
        if (o instanceof VehicleEnterEvent) {
            return ExtractorLogic.sender((VehicleEnterEvent)o);
        }
        if (o instanceof VehicleExitEvent) {
            return ExtractorLogic.sender((VehicleExitEvent)o);
        }
        if (o instanceof VehicleEvent) {
            return ExtractorLogic.sender((VehicleEvent)o);
        }
        return null;
    }

    public static Player playerFromObject(Object o) {
        CommandSender sender = ExtractorLogic.senderFromObject(o);
        if (sender instanceof Player) {
            return (Player)sender;
        }
        return null;
    }

    public static String senderIdFromObject(Object o) {
        if (o == null) {
            return null;
        }
        String id = IdUtil.getId(o);
        if (id != null) {
            return id;
        }
        CommandSender sender = ExtractorLogic.senderFromObject(o);
        if (sender == null) {
            return null;
        }
        return IdUtil.getId(sender);
    }

    public static String senderNameFromObject(Object o) {
        if (o == null) {
            return null;
        }
        String name = IdUtil.getName(o);
        if (name != null) {
            return name;
        }
        CommandSender sender = ExtractorLogic.senderFromObject(o);
        if (sender == null) {
            return null;
        }
        return IdUtil.getName(sender);
    }

    public static String playerNameFromObject(Object o) {
        String senderId = ExtractorLogic.senderNameFromObject(o);
        return senderId;
    }

    public static World world(Block o) {
        return o.getWorld();
    }

    public static World world(Location o) {
        return o.getWorld();
    }

    public static World world(Entity o) {
        return o.getWorld();
    }

    public static World world(PlayerEvent o) {
        return ExtractorLogic.world((Entity)o.getPlayer());
    }

    public static World world(PS o) {
        try {
            return o.asBukkitWorld(true);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static World worldFromObject(Object o) {
        if (o instanceof World) {
            return (World)o;
        }
        if (o instanceof Block) {
            return ExtractorLogic.world((Block)o);
        }
        if (o instanceof Location) {
            return ExtractorLogic.world((Location)o);
        }
        if (o instanceof Entity) {
            return ExtractorLogic.world((Entity)o);
        }
        if (o instanceof PlayerEvent) {
            return ExtractorLogic.world((PlayerEvent)o);
        }
        if (o instanceof PS) {
            return ExtractorLogic.world((PS)o);
        }
        return null;
    }

    public static String worldNameFromObject(Object o) {
        if (o instanceof String) {
            String ret;
            String string = (String)o;
            if (MUtil.isValidUUID(string) && (ret = ExtractorLogic.worldNameViaPsMixin(string)) != null) {
                return ret;
            }
            return string;
        }
        if (o instanceof PS) {
            return ((PS)o).getWorld();
        }
        World world = ExtractorLogic.worldFromObject(o);
        if (world != null) {
            return world.getName();
        }
        String ret = ExtractorLogic.worldNameViaPsMixin(o);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    public static String worldNameViaPsMixin(Object senderObject) {
        if (senderObject == null) {
            return null;
        }
        PS ps = Mixin.getSenderPs(senderObject);
        if (ps == null) {
            return null;
        }
        return ps.getWorld();
    }
}

