/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.bson;

import com.massivecraft.massivecore.xlib.bson.BSONCallback;
import com.massivecraft.massivecore.xlib.bson.BSONDecoder;
import com.massivecraft.massivecore.xlib.bson.BSONException;
import com.massivecraft.massivecore.xlib.bson.BSONObject;
import com.massivecraft.massivecore.xlib.bson.LazyBSONCallback;
import com.massivecraft.massivecore.xlib.bson.io.Bits;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class LazyBSONDecoder
implements BSONDecoder {
    static final Logger LOG = Logger.getLogger(LazyBSONDecoder.class.getName());
    private static int BYTES_IN_INTEGER = 4;

    @Override
    public BSONObject readObject(byte[] b) {
        try {
            return this.readObject(new ByteArrayInputStream(b));
        }
        catch (IOException ioe) {
            throw new BSONException("should be impossible", ioe);
        }
    }

    @Override
    public BSONObject readObject(InputStream in) throws IOException {
        LazyBSONCallback c = new LazyBSONCallback();
        this.decode(in, (BSONCallback)c);
        return (BSONObject)c.get();
    }

    @Override
    public int decode(byte[] b, BSONCallback callback) {
        try {
            return this.decode(new ByteArrayInputStream(b), callback);
        }
        catch (IOException ioe) {
            throw new BSONException("should be impossible", ioe);
        }
    }

    @Override
    public int decode(InputStream in, BSONCallback callback) throws IOException {
        byte[] objSizeBuffer = new byte[BYTES_IN_INTEGER];
        Bits.readFully(in, objSizeBuffer, 0, BYTES_IN_INTEGER);
        int objSize = Bits.readInt(objSizeBuffer);
        byte[] data = new byte[objSize];
        System.arraycopy(objSizeBuffer, 0, data, 0, BYTES_IN_INTEGER);
        Bits.readFully(in, data, BYTES_IN_INTEGER, objSize - BYTES_IN_INTEGER);
        callback.gotBinary(null, (byte)0, data);
        return objSize;
    }
}

