/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.bson.util.Assertions;
import com.massivecraft.massivecore.xlib.mongodb.ChangeListener;
import com.massivecraft.massivecore.xlib.mongodb.Cluster;
import com.massivecraft.massivecore.xlib.mongodb.ClusterDescription;
import com.massivecraft.massivecore.xlib.mongodb.ClusterDescriptionChangedEvent;
import com.massivecraft.massivecore.xlib.mongodb.ClusterEvent;
import com.massivecraft.massivecore.xlib.mongodb.ClusterListener;
import com.massivecraft.massivecore.xlib.mongodb.ClusterSettings;
import com.massivecraft.massivecore.xlib.mongodb.ClusterType;
import com.massivecraft.massivecore.xlib.mongodb.ClusterableServer;
import com.massivecraft.massivecore.xlib.mongodb.ClusterableServerFactory;
import com.massivecraft.massivecore.xlib.mongodb.Connection;
import com.massivecraft.massivecore.xlib.mongodb.Loggers;
import com.massivecraft.massivecore.xlib.mongodb.MongoIncompatibleDriverException;
import com.massivecraft.massivecore.xlib.mongodb.MongoInterruptedException;
import com.massivecraft.massivecore.xlib.mongodb.MongoTimeoutException;
import com.massivecraft.massivecore.xlib.mongodb.Server;
import com.massivecraft.massivecore.xlib.mongodb.ServerAddress;
import com.massivecraft.massivecore.xlib.mongodb.ServerDescription;
import com.massivecraft.massivecore.xlib.mongodb.ServerSelector;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

abstract class BaseCluster
implements Cluster {
    private static final Logger LOGGER = Loggers.getLogger("cluster");
    private final AtomicReference<CountDownLatch> phase = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
    private final ClusterableServerFactory serverFactory;
    private final ThreadLocal<Random> random = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };
    private final String clusterId;
    private final ClusterSettings settings;
    private final ClusterListener clusterListener;
    private volatile boolean isClosed;
    private volatile ClusterDescription description;

    public BaseCluster(String clusterId, ClusterSettings settings, ClusterableServerFactory serverFactory, ClusterListener clusterListener) {
        this.clusterId = Assertions.notNull("clusterId", clusterId);
        this.settings = Assertions.notNull("settings", settings);
        this.serverFactory = Assertions.notNull("serverFactory", serverFactory);
        this.clusterListener = Assertions.notNull("clusterListener", clusterListener);
        clusterListener.clusterOpened(new ClusterEvent(clusterId));
    }

    @Override
    public Server getServer(ServerSelector serverSelector, long maxWaitTime, TimeUnit timeUnit) {
        Assertions.isTrue("open", !this.isClosed());
        try {
            CountDownLatch currentPhase = this.phase.get();
            ClusterDescription curDescription = this.description;
            List<ServerDescription> serverDescriptions = serverSelector.choose(curDescription);
            boolean selectionFailureLogged = false;
            long startTimeNanos = System.nanoTime();
            long endTimeNanos = startTimeNanos + TimeUnit.NANOSECONDS.convert(maxWaitTime, timeUnit);
            long curTimeNanos = startTimeNanos;
            while (true) {
                ClusterableServer server;
                this.throwIfIncompatible(curDescription);
                if (!serverDescriptions.isEmpty() && (server = this.getRandomServer(new ArrayList<ServerDescription>(serverDescriptions))) != null) {
                    return new WrappedServer(server);
                }
                if (curTimeNanos > endTimeNanos) {
                    throw new MongoTimeoutException(String.format("Timed out while waiting for a server that matches %s after %d ms", serverSelector, TimeUnit.MILLISECONDS.convert(maxWaitTime, timeUnit)));
                }
                if (!selectionFailureLogged) {
                    LOGGER.info(String.format("No server chosen by %s from cluster description %s. Waiting for %d ms before timing out", serverSelector, curDescription, TimeUnit.MILLISECONDS.convert(maxWaitTime, timeUnit)));
                    selectionFailureLogged = true;
                }
                this.connect();
                currentPhase.await(Math.min(endTimeNanos - curTimeNanos, this.serverFactory.getSettings().getHeartbeatConnectRetryFrequency(TimeUnit.NANOSECONDS)), TimeUnit.NANOSECONDS);
                curTimeNanos = System.nanoTime();
                currentPhase = this.phase.get();
                curDescription = this.description;
                serverDescriptions = serverSelector.choose(curDescription);
            }
        }
        catch (InterruptedException e) {
            throw new MongoInterruptedException(String.format("Interrupted while waiting for a server that matches %s ", serverSelector), e);
        }
    }

    @Override
    public ClusterDescription getDescription(long maxWaitTime, TimeUnit timeUnit) {
        Assertions.isTrue("open", !this.isClosed());
        try {
            CountDownLatch currentPhase = this.phase.get();
            ClusterDescription curDescription = this.description;
            boolean selectionFailureLogged = false;
            long startTimeNanos = System.nanoTime();
            long endTimeNanos = startTimeNanos + TimeUnit.NANOSECONDS.convert(maxWaitTime, timeUnit);
            long curTimeNanos = startTimeNanos;
            while (curDescription.getType() == ClusterType.Unknown) {
                if (curTimeNanos > endTimeNanos) {
                    throw new MongoTimeoutException(String.format("Timed out while waiting to connect after %d ms", TimeUnit.MILLISECONDS.convert(maxWaitTime, timeUnit)));
                }
                if (!selectionFailureLogged) {
                    LOGGER.info(String.format("Cluster description not yet available. Waiting for %d ms before timing out", TimeUnit.MILLISECONDS.convert(maxWaitTime, timeUnit)));
                    selectionFailureLogged = true;
                }
                this.connect();
                currentPhase.await(Math.min(endTimeNanos - curTimeNanos, this.serverFactory.getSettings().getHeartbeatConnectRetryFrequency(TimeUnit.NANOSECONDS)), TimeUnit.NANOSECONDS);
                curTimeNanos = System.nanoTime();
                currentPhase = this.phase.get();
                curDescription = this.description;
            }
            return curDescription;
        }
        catch (InterruptedException e) {
            throw new MongoInterruptedException(String.format("Interrupted while waiting to connect", new Object[0]), e);
        }
    }

    public ClusterSettings getSettings() {
        return this.settings;
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.isClosed = true;
            this.phase.get().countDown();
            this.clusterListener.clusterClosed(new ClusterEvent(this.clusterId));
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    protected abstract ClusterableServer getServer(ServerAddress var1);

    protected abstract void connect();

    protected synchronized void updateDescription(ClusterDescription newDescription) {
        LOGGER.fine(String.format("Updating cluster description to  %s", newDescription.getShortDescription()));
        this.description = newDescription;
        CountDownLatch current = this.phase.getAndSet(new CountDownLatch(1));
        current.countDown();
    }

    protected void fireChangeEvent() {
        this.clusterListener.clusterDescriptionChanged(new ClusterDescriptionChangedEvent(this.clusterId, this.description));
    }

    private ClusterableServer getRandomServer(List<ServerDescription> serverDescriptions) {
        while (!serverDescriptions.isEmpty()) {
            int serverPos = this.getRandom().nextInt(serverDescriptions.size());
            ClusterableServer server = this.getServer(serverDescriptions.get(serverPos).getAddress());
            if (server != null) {
                return server;
            }
            serverDescriptions.remove(serverPos);
        }
        return null;
    }

    private void throwIfIncompatible(ClusterDescription curDescription) {
        if (!curDescription.isCompatibleWithDriver()) {
            throw new MongoIncompatibleDriverException(String.format("This version of the driver is not compatible with one or more of the servers to which it is connected: %s", curDescription));
        }
    }

    protected Random getRandom() {
        return this.random.get();
    }

    protected ClusterableServer createServer(ServerAddress serverAddress, ChangeListener<ServerDescription> serverStateListener) {
        ClusterableServer server = this.serverFactory.create(serverAddress);
        server.addChangeListener(serverStateListener);
        return server;
    }

    private static final class WrappedServer
    implements Server {
        private final ClusterableServer wrapped;

        public WrappedServer(ClusterableServer server) {
            this.wrapped = server;
        }

        @Override
        public ServerDescription getDescription() {
            return this.wrapped.getDescription();
        }

        @Override
        public Connection getConnection(long maxWaitTime, TimeUnit timeUnit) {
            return this.wrapped.getConnection(maxWaitTime, timeUnit);
        }

        @Override
        public void invalidate() {
            this.wrapped.invalidate();
        }
    }
}

