/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.mongodb.BulkWriteOperation;
import com.massivecraft.massivecore.xlib.mongodb.DBObject;
import com.massivecraft.massivecore.xlib.mongodb.ReplaceRequest;
import com.massivecraft.massivecore.xlib.mongodb.UpdateRequest;

public class BulkUpdateRequestBuilder {
    private final BulkWriteOperation bulkWriteOperation;
    private final DBObject query;
    private final boolean upsert;

    BulkUpdateRequestBuilder(BulkWriteOperation bulkWriteOperation, DBObject query, boolean upsert) {
        this.bulkWriteOperation = bulkWriteOperation;
        this.query = query;
        this.upsert = upsert;
    }

    public void replaceOne(DBObject document) {
        this.bulkWriteOperation.addRequest(new ReplaceRequest(this.query, this.upsert, document));
    }

    public void update(DBObject update) {
        this.bulkWriteOperation.addRequest(new UpdateRequest(this.query, this.upsert, update, true));
    }

    public void updateOne(DBObject update) {
        this.bulkWriteOperation.addRequest(new UpdateRequest(this.query, this.upsert, update, false));
    }
}

