/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.bson.util.Assertions;
import com.massivecraft.massivecore.xlib.mongodb.BulkWriteRequestBuilder;
import com.massivecraft.massivecore.xlib.mongodb.BulkWriteResult;
import com.massivecraft.massivecore.xlib.mongodb.DBCollection;
import com.massivecraft.massivecore.xlib.mongodb.DBObject;
import com.massivecraft.massivecore.xlib.mongodb.InsertRequest;
import com.massivecraft.massivecore.xlib.mongodb.WriteConcern;
import com.massivecraft.massivecore.xlib.mongodb.WriteRequest;
import java.util.ArrayList;
import java.util.List;

public class BulkWriteOperation {
    private final boolean ordered;
    private final DBCollection collection;
    private final List<WriteRequest> requests = new ArrayList<WriteRequest>();
    private boolean closed;

    BulkWriteOperation(boolean ordered, DBCollection collection) {
        this.ordered = ordered;
        this.collection = collection;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void insert(DBObject document) {
        Assertions.isTrue("already executed", !this.closed);
        this.addRequest(new InsertRequest(document));
    }

    public BulkWriteRequestBuilder find(DBObject query) {
        Assertions.isTrue("already executed", !this.closed);
        return new BulkWriteRequestBuilder(this, query);
    }

    public BulkWriteResult execute() {
        Assertions.isTrue("already executed", !this.closed);
        this.closed = true;
        return this.collection.executeBulkWriteOperation(this.ordered, this.requests);
    }

    public BulkWriteResult execute(WriteConcern writeConcern) {
        Assertions.isTrue("already executed", !this.closed);
        this.closed = true;
        return this.collection.executeBulkWriteOperation(this.ordered, this.requests, writeConcern);
    }

    void addRequest(WriteRequest request) {
        Assertions.isTrue("already executed", !this.closed);
        this.requests.add(request);
    }
}

