/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.mongodb.Cluster;
import com.massivecraft.massivecore.xlib.mongodb.ClusterConnectionMode;
import com.massivecraft.massivecore.xlib.mongodb.ClusterListener;
import com.massivecraft.massivecore.xlib.mongodb.ClusterSettings;
import com.massivecraft.massivecore.xlib.mongodb.DefaultClusterableServerFactory;
import com.massivecraft.massivecore.xlib.mongodb.Mongo;
import com.massivecraft.massivecore.xlib.mongodb.MultiServerCluster;
import com.massivecraft.massivecore.xlib.mongodb.NoOpClusterListener;
import com.massivecraft.massivecore.xlib.mongodb.ServerSettings;
import com.massivecraft.massivecore.xlib.mongodb.SingleServerCluster;

final class Clusters {
    private Clusters() {
    }

    public static Cluster create(String clusterId, ClusterSettings settings, ServerSettings serverSettings, ClusterListener clusterListener, Mongo mongo) {
        DefaultClusterableServerFactory serverFactory = new DefaultClusterableServerFactory(clusterId, serverSettings, mongo);
        if (settings.getMode() == ClusterConnectionMode.Single) {
            return new SingleServerCluster(clusterId, settings, serverFactory, clusterListener != null ? clusterListener : new NoOpClusterListener());
        }
        if (settings.getMode() == ClusterConnectionMode.Multiple) {
            return new MultiServerCluster(clusterId, settings, serverFactory, clusterListener != null ? clusterListener : new NoOpClusterListener());
        }
        throw new UnsupportedOperationException("Unsupported cluster mode: " + (Object)((Object)settings.getMode()));
    }
}

