/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.mongodb.BasicDBObject;
import com.massivecraft.massivecore.xlib.mongodb.CommandFailureException;
import com.massivecraft.massivecore.xlib.mongodb.MongoException;
import com.massivecraft.massivecore.xlib.mongodb.MongoExecutionTimeoutException;
import com.massivecraft.massivecore.xlib.mongodb.ServerAddress;
import com.massivecraft.massivecore.xlib.mongodb.WriteConcernException;
import java.util.List;

public class CommandResult
extends BasicDBObject {
    private final ServerAddress _host;
    private static final long serialVersionUID = 1L;

    CommandResult(ServerAddress serverAddress) {
        if (serverAddress == null) {
            throw new IllegalArgumentException("server address is null");
        }
        this._host = serverAddress;
        this.put("serverUsed", (Object)serverAddress.toString());
    }

    public boolean ok() {
        Object okValue = this.get("ok");
        if (okValue instanceof Boolean) {
            return (Boolean)okValue;
        }
        if (okValue instanceof Number) {
            return ((Number)okValue).intValue() == 1;
        }
        return false;
    }

    public String getErrorMessage() {
        Object errorMessage = this.get("errmsg");
        if (errorMessage == null) {
            return null;
        }
        return errorMessage.toString();
    }

    public MongoException getException() {
        if (!this.ok()) {
            if (this.getCode() == 50) {
                return new MongoExecutionTimeoutException(this.getCode(), this.getErrorMessage());
            }
            return new CommandFailureException(this);
        }
        if (this.hasErr()) {
            return this.getWriteException();
        }
        return null;
    }

    private MongoException getWriteException() {
        int code = this.getCode();
        if (code == 11000 || code == 11001 || code == 12582) {
            return new MongoException.DuplicateKey(this);
        }
        return new WriteConcernException(this);
    }

    int getCode() {
        int code = this.getInt("code", -1);
        if (code == -1 && this.get("errObjects") != null) {
            for (BasicDBObject curErrorDocument : (List)this.get("errObjects")) {
                if (!this.get("err").equals(curErrorDocument.get("err"))) continue;
                code = curErrorDocument.getInt("code", -1);
                break;
            }
        }
        return code;
    }

    boolean hasErr() {
        String err = this.getString("err");
        return err != null && err.length() > 0;
    }

    public void throwOnError() {
        if (!this.ok() || this.hasErr()) {
            throw this.getException();
        }
    }

    public ServerAddress getServerUsed() {
        return this._host;
    }
}

