/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.mongodb.ConnectionEvent;
import com.massivecraft.massivecore.xlib.mongodb.ConnectionPoolListenerAdapter;
import com.massivecraft.massivecore.xlib.mongodb.ConnectionPoolOpenedEvent;
import com.massivecraft.massivecore.xlib.mongodb.ConnectionPoolSettings;
import com.massivecraft.massivecore.xlib.mongodb.ConnectionPoolStatisticsMBean;
import com.massivecraft.massivecore.xlib.mongodb.ConnectionPoolWaitQueueEvent;
import com.massivecraft.massivecore.xlib.mongodb.ServerAddress;
import java.util.concurrent.atomic.AtomicInteger;

final class ConnectionPoolStatistics
extends ConnectionPoolListenerAdapter
implements ConnectionPoolStatisticsMBean {
    private final ServerAddress serverAddress;
    private final ConnectionPoolSettings settings;
    private final AtomicInteger size = new AtomicInteger();
    private final AtomicInteger checkedOutCount = new AtomicInteger();
    private final AtomicInteger waitQueueSize = new AtomicInteger();

    public ConnectionPoolStatistics(ConnectionPoolOpenedEvent event) {
        this.serverAddress = event.getServerAddress();
        this.settings = event.getSettings();
    }

    @Override
    public String getHost() {
        return this.serverAddress.getHost();
    }

    @Override
    public int getPort() {
        return this.serverAddress.getPort();
    }

    @Override
    public int getMinSize() {
        return this.settings.getMinSize();
    }

    @Override
    public int getMaxSize() {
        return this.settings.getMaxSize();
    }

    @Override
    public int getSize() {
        return this.size.get();
    }

    @Override
    public int getCheckedOutCount() {
        return this.checkedOutCount.get();
    }

    @Override
    public int getWaitQueueSize() {
        return this.waitQueueSize.get();
    }

    @Override
    public void connectionCheckedOut(ConnectionEvent event) {
        this.checkedOutCount.incrementAndGet();
    }

    @Override
    public void connectionCheckedIn(ConnectionEvent event) {
        this.checkedOutCount.decrementAndGet();
    }

    @Override
    public void connectionAdded(ConnectionEvent event) {
        this.size.incrementAndGet();
    }

    @Override
    public void connectionRemoved(ConnectionEvent event) {
        this.size.decrementAndGet();
    }

    @Override
    public void waitQueueEntered(ConnectionPoolWaitQueueEvent event) {
        this.waitQueueSize.incrementAndGet();
    }

    @Override
    public void waitQueueExited(ConnectionPoolWaitQueueEvent event) {
        this.waitQueueSize.decrementAndGet();
    }
}

