/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.mongodb.BasicDBObject;
import com.massivecraft.massivecore.xlib.mongodb.Bytes;
import com.massivecraft.massivecore.xlib.mongodb.CommandResult;
import com.massivecraft.massivecore.xlib.mongodb.DB;
import com.massivecraft.massivecore.xlib.mongodb.DBCollectionImpl;
import com.massivecraft.massivecore.xlib.mongodb.DBConnector;
import com.massivecraft.massivecore.xlib.mongodb.DBObject;
import com.massivecraft.massivecore.xlib.mongodb.DBPort;
import com.massivecraft.massivecore.xlib.mongodb.DBTCPConnector;
import com.massivecraft.massivecore.xlib.mongodb.Mongo;
import com.massivecraft.massivecore.xlib.mongodb.MongoCredential;
import com.massivecraft.massivecore.xlib.mongodb.OutMessage;
import com.massivecraft.massivecore.xlib.mongodb.ServerAddress;
import com.massivecraft.massivecore.xlib.mongodb.ServerVersion;
import com.massivecraft.massivecore.xlib.mongodb.WriteConcern;
import com.massivecraft.massivecore.xlib.mongodb.WriteResult;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;

@Deprecated
public class DBApiLayer
extends DB {
    static final int NUM_CURSORS_BEFORE_KILL = 100;
    static final int NUM_CURSORS_PER_BATCH = 20000;
    final String _root;
    final String _rootPlusDot;
    final DBTCPConnector _connector;
    final ConcurrentHashMap<String, DBCollectionImpl> _collections = new ConcurrentHashMap();
    ConcurrentLinkedQueue<DeadCursor> _deadCursorIds = new ConcurrentLinkedQueue();

    DBTCPConnector getConnector() {
        return this._connector;
    }

    protected DBApiLayer(Mongo mongo, String name, DBConnector connector) {
        super(mongo, name);
        if (connector == null) {
            throw new IllegalArgumentException("need a connector: " + name);
        }
        this._root = name;
        this._rootPlusDot = this._root + ".";
        this._connector = (DBTCPConnector)connector;
    }

    @Override
    public void requestStart() {
        this._connector.requestStart();
    }

    @Override
    public void requestDone() {
        this._connector.requestDone();
    }

    @Override
    public void requestEnsureConnection() {
        this._connector.requestEnsureConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteResult addUser(String username, char[] passwd, boolean readOnly) {
        this.requestStart();
        try {
            if (this.useUserCommands(this._connector.getPrimaryPort())) {
                CommandResult userInfoResult = this.command(new BasicDBObject("usersInfo", username));
                userInfoResult.throwOnError();
                DBObject userCommandDocument = this.getUserCommandDocument(username, passwd, readOnly, ((List)userInfoResult.get("users")).isEmpty() ? "createUser" : "updateUser");
                CommandResult commandResult = this.command(userCommandDocument);
                commandResult.throwOnError();
                WriteResult writeResult = new WriteResult(commandResult, this.getWriteConcern());
                return writeResult;
            }
            WriteResult writeResult = super.addUser(username, passwd, readOnly);
            return writeResult;
        }
        finally {
            this.requestDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteResult removeUser(String username) {
        this.requestStart();
        try {
            if (this.useUserCommands(this._connector.getPrimaryPort())) {
                CommandResult res = this.command(new BasicDBObject("dropUser", username));
                res.throwOnError();
                WriteResult writeResult = new WriteResult(res, this.getWriteConcern());
                return writeResult;
            }
            WriteResult writeResult = super.removeUser(username);
            return writeResult;
        }
        finally {
            this.requestDone();
        }
    }

    private DBObject getUserCommandDocument(String username, char[] passwd, boolean readOnly, String commandName) {
        return new BasicDBObject(commandName, username).append("pwd", this._hash(username, passwd)).append("digestPassword", false).append("roles", Arrays.asList(this.getUserRoleName(readOnly)));
    }

    private String getUserRoleName(boolean readOnly) {
        return this.getName().equals("admin") ? (readOnly ? "readAnyDatabase" : "root") : (readOnly ? "read" : "dbOwner");
    }

    @Override
    protected DBCollectionImpl doGetCollection(String name) {
        DBCollectionImpl c = this._collections.get(name);
        if (c != null) {
            return c;
        }
        c = new DBCollectionImpl(this, name);
        DBCollectionImpl old = this._collections.putIfAbsent(name, c);
        return old != null ? old : c;
    }

    @Override
    public void cleanCursors(boolean force) {
        DeadCursor c;
        int sz = this._deadCursorIds.size();
        if (sz == 0 || !force && sz < 100) {
            return;
        }
        Bytes.LOGGER.info("going to kill cursors : " + sz);
        HashMap<ServerAddress, LinkedList<Long>> m = new HashMap<ServerAddress, LinkedList<Long>>();
        while ((c = this._deadCursorIds.poll()) != null) {
            LinkedList<Long> x = (LinkedList<Long>)m.get(c.host);
            if (x == null) {
                x = new LinkedList<Long>();
                m.put(c.host, x);
            }
            x.add(c.id);
        }
        for (Map.Entry e : m.entrySet()) {
            try {
                this.killCursors((ServerAddress)e.getKey(), (List)e.getValue());
            }
            catch (Throwable t) {
                Bytes.LOGGER.log(Level.WARNING, "can't clean cursors", t);
                for (Long x : (List)e.getValue()) {
                    this._deadCursorIds.add(new DeadCursor(x, (ServerAddress)e.getKey()));
                }
            }
        }
    }

    void killCursors(ServerAddress addr, List<Long> all) {
        if (all == null || all.size() == 0) {
            return;
        }
        OutMessage om = OutMessage.killCursors(this._mongo, Math.min(20000, all.size()));
        int soFar = 0;
        int totalSoFar = 0;
        for (Long l : all) {
            om.writeLong(l);
            ++totalSoFar;
            if (++soFar < 20000) continue;
            this._connector.say(this, om, WriteConcern.NONE);
            om = OutMessage.killCursors(this._mongo, Math.min(20000, all.size() - totalSoFar));
            soFar = 0;
        }
        this._connector.say((DB)this, om, WriteConcern.NONE, addr);
    }

    @Override
    CommandResult doAuthenticate(MongoCredential credentials) {
        return this._connector.authenticate(credentials);
    }

    private boolean useUserCommands(DBPort port) {
        return this._connector.getServerDescription(port.getAddress()).getVersion().compareTo(new ServerVersion(2, 6)) >= 0;
    }

    void addDeadCursor(DeadCursor deadCursor) {
        this._deadCursorIds.add(deadCursor);
    }

    static class DeadCursor {
        final long id;
        final ServerAddress host;

        DeadCursor(long a, ServerAddress b) {
            this.id = a;
            this.host = b;
        }
    }
}

