/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.bson.io.PoolOutputBuffer;
import com.massivecraft.massivecore.xlib.bson.types.ObjectId;
import com.massivecraft.massivecore.xlib.bson.util.Assertions;
import com.massivecraft.massivecore.xlib.mongodb.AcknowledgedBulkWriteResult;
import com.massivecraft.massivecore.xlib.mongodb.AggregationOptions;
import com.massivecraft.massivecore.xlib.mongodb.BaseWriteCommandMessage;
import com.massivecraft.massivecore.xlib.mongodb.BasicDBList;
import com.massivecraft.massivecore.xlib.mongodb.BasicDBObject;
import com.massivecraft.massivecore.xlib.mongodb.BulkWriteBatchCombiner;
import com.massivecraft.massivecore.xlib.mongodb.BulkWriteError;
import com.massivecraft.massivecore.xlib.mongodb.BulkWriteException;
import com.massivecraft.massivecore.xlib.mongodb.BulkWriteResult;
import com.massivecraft.massivecore.xlib.mongodb.BulkWriteUpsert;
import com.massivecraft.massivecore.xlib.mongodb.CommandFailureException;
import com.massivecraft.massivecore.xlib.mongodb.CommandResult;
import com.massivecraft.massivecore.xlib.mongodb.Cursor;
import com.massivecraft.massivecore.xlib.mongodb.DBApiLayer;
import com.massivecraft.massivecore.xlib.mongodb.DBCollection;
import com.massivecraft.massivecore.xlib.mongodb.DBCursor;
import com.massivecraft.massivecore.xlib.mongodb.DBDecoder;
import com.massivecraft.massivecore.xlib.mongodb.DBEncoder;
import com.massivecraft.massivecore.xlib.mongodb.DBObject;
import com.massivecraft.massivecore.xlib.mongodb.DBPort;
import com.massivecraft.massivecore.xlib.mongodb.DBTCPConnector;
import com.massivecraft.massivecore.xlib.mongodb.DefaultDBDecoder;
import com.massivecraft.massivecore.xlib.mongodb.DefaultDBEncoder;
import com.massivecraft.massivecore.xlib.mongodb.DeleteCommandMessage;
import com.massivecraft.massivecore.xlib.mongodb.IndexMap;
import com.massivecraft.massivecore.xlib.mongodb.InsertCommandMessage;
import com.massivecraft.massivecore.xlib.mongodb.InsertRequest;
import com.massivecraft.massivecore.xlib.mongodb.MessageSettings;
import com.massivecraft.massivecore.xlib.mongodb.ModifyRequest;
import com.massivecraft.massivecore.xlib.mongodb.MongoException;
import com.massivecraft.massivecore.xlib.mongodb.MongoInternalException;
import com.massivecraft.massivecore.xlib.mongodb.MongoNamespace;
import com.massivecraft.massivecore.xlib.mongodb.OutMessage;
import com.massivecraft.massivecore.xlib.mongodb.ParallelScanOptions;
import com.massivecraft.massivecore.xlib.mongodb.QueryResultIterator;
import com.massivecraft.massivecore.xlib.mongodb.ReadPreference;
import com.massivecraft.massivecore.xlib.mongodb.RemoveRequest;
import com.massivecraft.massivecore.xlib.mongodb.Response;
import com.massivecraft.massivecore.xlib.mongodb.ServerAddress;
import com.massivecraft.massivecore.xlib.mongodb.ServerDescription;
import com.massivecraft.massivecore.xlib.mongodb.ServerVersion;
import com.massivecraft.massivecore.xlib.mongodb.UpdateCommandMessage;
import com.massivecraft.massivecore.xlib.mongodb.UpdateRequest;
import com.massivecraft.massivecore.xlib.mongodb.WriteCommandResultHelper;
import com.massivecraft.massivecore.xlib.mongodb.WriteConcern;
import com.massivecraft.massivecore.xlib.mongodb.WriteConcernError;
import com.massivecraft.massivecore.xlib.mongodb.WriteConcernException;
import com.massivecraft.massivecore.xlib.mongodb.WriteRequest;
import com.massivecraft.massivecore.xlib.mongodb.WriteResult;
import com.massivecraft.massivecore.xlib.mongodb.util.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class DBCollectionImpl
extends DBCollection {
    private static final int QUERY_DOCUMENT_HEADROOM = 16384;
    private final DBApiLayer db;
    private final String namespace;
    private static final Logger TRACE_LOGGER = Logger.getLogger("com.mongodb.TRACE");
    private static final Level TRACE_LEVEL = Boolean.getBoolean("DB.TRACE") ? Level.INFO : Level.FINEST;

    DBCollectionImpl(DBApiLayer db, String name) {
        super(db, name);
        this.namespace = db._root + "." + name;
        this.db = db;
    }

    @Override
    QueryResultIterator find(DBObject ref, DBObject fields, int numToSkip, int batchSize, int limit, int options, ReadPreference readPref, DBDecoder decoder) {
        return this.find(ref, fields, numToSkip, batchSize, limit, options, readPref, decoder, DefaultDBEncoder.FACTORY.create());
    }

    @Override
    QueryResultIterator find(DBObject ref, DBObject fields, int numToSkip, int batchSize, int limit, int options, ReadPreference readPref, DBDecoder decoder, DBEncoder encoder) {
        if (ref == null) {
            ref = new BasicDBObject();
        }
        if (this.willTrace()) {
            this.trace("find: " + this.namespace + " " + JSON.serialize(ref));
        }
        OutMessage query = OutMessage.query(this, options, numToSkip, QueryResultIterator.chooseBatchSize(batchSize, limit, 0), ref, fields, readPref, encoder, this.db.getMongo().getMaxBsonObjectSize() + 16384);
        Response res = this.db.getConnector().call(this._db, this, query, null, 2, readPref, decoder);
        return new QueryResultIterator(this.db, this, res, batchSize, limit, options, decoder);
    }

    @Override
    public Cursor aggregate(List<DBObject> pipeline, AggregationOptions options, ReadPreference readPreference) {
        if (options == null) {
            throw new IllegalArgumentException("options can not be null");
        }
        DBObject last = pipeline.get(pipeline.size() - 1);
        DBObject command = this.prepareCommand(pipeline, options);
        CommandResult res = this._db.command(command, this.getOptions(), readPreference);
        res.throwOnError();
        String outCollection = (String)last.get("$out");
        if (outCollection != null) {
            DBCollection collection = this._db.getCollection(outCollection);
            return new DBCursor(collection, new BasicDBObject(), null, ReadPreference.primary());
        }
        Integer batchSize = options.getBatchSize();
        return new QueryResultIterator(res, this.db, this, batchSize == null ? 0 : batchSize, this.getDecoder(), res.getServerUsed());
    }

    @Override
    public List<Cursor> parallelScan(ParallelScanOptions options) {
        CommandResult res = this._db.command((DBObject)new BasicDBObject("parallelCollectionScan", this.getName()).append("numCursors", options.getNumCursors()), options.getReadPreference());
        res.throwOnError();
        ArrayList<Cursor> cursors = new ArrayList<Cursor>();
        for (DBObject cursorDocument : (List)res.get("cursors")) {
            cursors.add(new QueryResultIterator(cursorDocument, this.db, this, options.getBatchSize(), this.getDecoder(), res.getServerUsed()));
        }
        return cursors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    BulkWriteResult executeBulkWriteOperation(boolean ordered, List<WriteRequest> writeRequests, WriteConcern writeConcern, DBEncoder encoder) {
        Assertions.isTrue("no operations", !writeRequests.isEmpty());
        if (writeConcern == null) {
            throw new IllegalArgumentException("Write concern can not be null");
        }
        if (encoder == null) {
            encoder = DefaultDBEncoder.FACTORY.create();
        }
        DBPort port = this.db.getConnector().getPrimaryPort();
        try {
            BulkWriteBatchCombiner bulkWriteBatchCombiner = new BulkWriteBatchCombiner(port.getAddress(), writeConcern);
            for (Run run : this.getRunGenerator(ordered, writeRequests, writeConcern, encoder, port)) {
                try {
                    BulkWriteResult result = run.execute(port);
                    if (!result.isAcknowledged()) continue;
                    bulkWriteBatchCombiner.addResult(result, run.indexMap);
                }
                catch (BulkWriteException e) {
                    bulkWriteBatchCombiner.addErrorResult(e, run.indexMap);
                    if (!bulkWriteBatchCombiner.shouldStopSendingMoreBatches()) continue;
                    break;
                }
            }
            BulkWriteResult bulkWriteResult = bulkWriteBatchCombiner.getResult();
            return bulkWriteResult;
        }
        finally {
            this.db.getConnector().releasePort(port);
        }
    }

    @Override
    public WriteResult insert(List<DBObject> list, WriteConcern concern, DBEncoder encoder) {
        return this.insert(list, true, concern, encoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WriteResult insert(List<DBObject> list, boolean shouldApply, WriteConcern concern, DBEncoder encoder) {
        if (concern == null) {
            throw new IllegalArgumentException("Write concern can not be null");
        }
        if (encoder == null) {
            encoder = DefaultDBEncoder.FACTORY.create();
        }
        if (this.willTrace()) {
            for (DBObject writeResult : list) {
                this.trace("save:  " + this.namespace + " " + JSON.serialize(writeResult));
            }
        }
        DBPort port = this.db.getConnector().getPrimaryPort();
        try {
            if (this.useWriteCommands(concern, port)) {
                try {
                    WriteResult writeResult = this.translateBulkWriteResult(this.insertWithCommandProtocol(list, concern, encoder, port, shouldApply), WriteRequest.Type.INSERT, concern, port.getAddress());
                    return writeResult;
                }
                catch (BulkWriteException bulkWriteException) {
                    throw this.translateBulkWriteException(bulkWriteException, WriteRequest.Type.INSERT);
                }
            }
            WriteResult writeResult = this.insertWithWriteProtocol(list, concern, encoder, port, shouldApply);
            return writeResult;
        }
        finally {
            this.db.getConnector().releasePort(port);
        }
    }

    @Override
    public WriteResult remove(DBObject query, WriteConcern concern, DBEncoder encoder) {
        return this.remove(query, true, concern, encoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteResult remove(DBObject query, boolean multi, WriteConcern concern, DBEncoder encoder) {
        if (concern == null) {
            throw new IllegalArgumentException("Write concern can not be null");
        }
        if (encoder == null) {
            encoder = DefaultDBEncoder.FACTORY.create();
        }
        if (this.willTrace()) {
            this.trace("remove: " + this.namespace + " " + JSON.serialize(query));
        }
        DBPort port = this.db.getConnector().getPrimaryPort();
        try {
            if (this.useWriteCommands(concern, port)) {
                try {
                    WriteResult writeResult = this.translateBulkWriteResult(this.removeWithCommandProtocol(Arrays.asList(new RemoveRequest(query, multi)), concern, encoder, port), WriteRequest.Type.REMOVE, concern, port.getAddress());
                    return writeResult;
                }
                catch (BulkWriteException e) {
                    throw this.translateBulkWriteException(e, WriteRequest.Type.REMOVE);
                }
            }
            WriteResult writeResult = this.db.getConnector().say(this._db, OutMessage.remove(this, encoder, query, multi), concern, port);
            return writeResult;
        }
        finally {
            this.db.getConnector().releasePort(port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteResult update(DBObject query, DBObject o, boolean upsert, boolean multi, WriteConcern concern, DBEncoder encoder) {
        String key;
        if (o == null) {
            throw new IllegalArgumentException("update can not be null");
        }
        if (concern == null) {
            throw new IllegalArgumentException("Write concern can not be null");
        }
        if (encoder == null) {
            encoder = DefaultDBEncoder.FACTORY.create();
        }
        if (!o.keySet().isEmpty() && !(key = o.keySet().iterator().next()).startsWith("$")) {
            this._checkObject(o, false, false);
        }
        if (this.willTrace()) {
            this.trace("update: " + this.namespace + " " + JSON.serialize(query) + " " + JSON.serialize(o));
        }
        DBPort port = this.db.getConnector().getPrimaryPort();
        try {
            if (this.useWriteCommands(concern, port)) {
                try {
                    BulkWriteResult bulkWriteResult = this.updateWithCommandProtocol(Arrays.asList(new UpdateRequest(query, upsert, o, multi)), concern, encoder, port);
                    WriteResult writeResult = this.translateBulkWriteResult(bulkWriteResult, WriteRequest.Type.UPDATE, concern, port.getAddress());
                    return writeResult;
                }
                catch (BulkWriteException e) {
                    throw this.translateBulkWriteException(e, WriteRequest.Type.UPDATE);
                }
            }
            WriteResult writeResult = this.db.getConnector().say(this._db, OutMessage.update(this, encoder, upsert, multi, query, o), concern, port);
            return writeResult;
        }
        finally {
            this.db.getConnector().releasePort(port);
        }
    }

    @Override
    public void drop() {
        this.db._collections.remove(this.getName());
        super.drop();
    }

    @Override
    public void doapply(DBObject o) {
    }

    private WriteResult translateBulkWriteResult(BulkWriteResult bulkWriteResult, WriteRequest.Type type, WriteConcern writeConcern, ServerAddress serverAddress) {
        CommandResult commandResult = new CommandResult(serverAddress);
        this.addBulkWriteResultToCommandResult(bulkWriteResult, type, commandResult);
        return new WriteResult(commandResult, writeConcern);
    }

    private MongoException translateBulkWriteException(BulkWriteException e, WriteRequest.Type type) {
        BulkWriteError lastError = e.getWriteErrors().isEmpty() ? null : e.getWriteErrors().get(e.getWriteErrors().size() - 1);
        CommandResult commandResult = new CommandResult(e.getServerAddress());
        this.addBulkWriteResultToCommandResult(e.getWriteResult(), type, commandResult);
        if (e.getWriteConcernError() != null) {
            commandResult.putAll(e.getWriteConcernError().getDetails());
        }
        if (lastError != null) {
            commandResult.put("err", (Object)lastError.getMessage());
            commandResult.put("code", (Object)lastError.getCode());
            commandResult.putAll(lastError.getDetails());
        } else if (e.getWriteConcernError() != null) {
            commandResult.put("err", (Object)e.getWriteConcernError().getMessage());
            commandResult.put("code", (Object)e.getWriteConcernError().getCode());
        }
        return commandResult.getException();
    }

    private void addBulkWriteResultToCommandResult(BulkWriteResult bulkWriteResult, WriteRequest.Type type, CommandResult commandResult) {
        commandResult.put("ok", (Object)1);
        if (type == WriteRequest.Type.INSERT) {
            commandResult.put("n", (Object)0);
        } else if (type == WriteRequest.Type.REMOVE) {
            commandResult.put("n", (Object)bulkWriteResult.getRemovedCount());
        } else if (type == WriteRequest.Type.UPDATE || type == WriteRequest.Type.REPLACE) {
            commandResult.put("n", (Object)(bulkWriteResult.getMatchedCount() + bulkWriteResult.getUpserts().size()));
            if (bulkWriteResult.getMatchedCount() > 0) {
                commandResult.put("updatedExisting", (Object)true);
            } else {
                commandResult.put("updatedExisting", (Object)false);
            }
            if (!bulkWriteResult.getUpserts().isEmpty()) {
                commandResult.put("upserted", bulkWriteResult.getUpserts().get(0).getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createIndex(DBObject keys, DBObject options, DBEncoder encoder) {
        block7: {
            DBTCPConnector connector = this.db.getConnector();
            final DBPort port = this.db.getConnector().getPrimaryPort();
            try {
                DBObject index = this.defaultOptions(keys);
                index.putAll(options);
                index.put("key", keys);
                if (connector.getServerDescription(port.getAddress()).getVersion().compareTo(new ServerVersion(2, 6)) >= 0) {
                    final BasicDBObject createIndexes = new BasicDBObject("createIndexes", this.getName());
                    BasicDBList list = new BasicDBList();
                    list.add(index);
                    createIndexes.put("indexes", (Object)list);
                    CommandResult commandResult = connector.doOperation(this.db, port, new DBPort.Operation<CommandResult>(){

                        @Override
                        public CommandResult execute() throws IOException {
                            return port.runCommand(DBCollectionImpl.this.db, createIndexes);
                        }
                    });
                    try {
                        commandResult.throwOnError();
                        break block7;
                    }
                    catch (CommandFailureException e) {
                        if (e.getCode() == 11000) {
                            throw new MongoException.DuplicateKey(commandResult);
                        }
                        throw e;
                    }
                }
                this.db.doGetCollection("system.indexes").insertWithWriteProtocol(Arrays.asList(index), WriteConcern.SAFE, DefaultDBEncoder.FACTORY.create(), port, false);
            }
            finally {
                connector.releasePort(port);
            }
        }
    }

    private BulkWriteResult insertWithCommandProtocol(List<DBObject> list, WriteConcern writeConcern, DBEncoder encoder, DBPort port, boolean shouldApply) {
        if (shouldApply) {
            this.applyRulesForInsert(list);
        }
        InsertCommandMessage message = new InsertCommandMessage(this.getNamespace(), writeConcern, list, DefaultDBEncoder.FACTORY.create(), encoder, this.getMessageSettings(port));
        return this.writeWithCommandProtocol(port, WriteRequest.Type.INSERT, message, writeConcern);
    }

    private void applyRulesForInsert(List<DBObject> list) {
        for (DBObject o : list) {
            this._checkObject(o, false, false);
            this.apply(o);
            Object id = o.get("_id");
            if (!(id instanceof ObjectId)) continue;
            ((ObjectId)id).notNew();
        }
    }

    private BulkWriteResult removeWithCommandProtocol(List<RemoveRequest> removeList, WriteConcern writeConcern, DBEncoder encoder, DBPort port) {
        DeleteCommandMessage message = new DeleteCommandMessage(this.getNamespace(), writeConcern, removeList, DefaultDBEncoder.FACTORY.create(), encoder, this.getMessageSettings(port));
        return this.writeWithCommandProtocol(port, WriteRequest.Type.REMOVE, message, writeConcern);
    }

    private BulkWriteResult updateWithCommandProtocol(List<ModifyRequest> updates, WriteConcern writeConcern, DBEncoder encoder, DBPort port) {
        UpdateCommandMessage message = new UpdateCommandMessage(this.getNamespace(), writeConcern, updates, DefaultDBEncoder.FACTORY.create(), encoder, this.getMessageSettings(port));
        return this.writeWithCommandProtocol(port, WriteRequest.Type.UPDATE, message, writeConcern);
    }

    private BulkWriteResult writeWithCommandProtocol(DBPort port, WriteRequest.Type type, BaseWriteCommandMessage message, WriteConcern writeConcern) {
        BaseWriteCommandMessage nextMessage;
        int batchNum = 0;
        int currentRangeStartIndex = 0;
        BulkWriteBatchCombiner bulkWriteBatchCombiner = new BulkWriteBatchCombiner(port.getAddress(), writeConcern);
        do {
            int itemCount = (nextMessage = this.sendWriteCommandMessage(message, ++batchNum, port)) != null ? message.getItemCount() - nextMessage.getItemCount() : message.getItemCount();
            IndexMap indexMap = IndexMap.create(currentRangeStartIndex, itemCount);
            CommandResult commandResult = this.receiveWriteCommandMessage(port);
            if (this.willTrace() && nextMessage != null || batchNum > 1) {
                this.getLogger().fine(String.format("Received response for batch %d", batchNum));
            }
            if (WriteCommandResultHelper.hasError(commandResult)) {
                bulkWriteBatchCombiner.addErrorResult(WriteCommandResultHelper.getBulkWriteException(type, commandResult), indexMap);
            } else {
                bulkWriteBatchCombiner.addResult(WriteCommandResultHelper.getBulkWriteResult(type, commandResult), indexMap);
            }
            currentRangeStartIndex += itemCount;
        } while ((message = nextMessage) != null && !bulkWriteBatchCombiner.shouldStopSendingMoreBatches());
        return bulkWriteBatchCombiner.getResult();
    }

    private boolean useWriteCommands(WriteConcern concern, DBPort port) {
        return concern.callGetLastError() && this.db.getConnector().getServerDescription(port.getAddress()).getVersion().compareTo(new ServerVersion(2, 6)) >= 0;
    }

    private MessageSettings getMessageSettings(DBPort port) {
        ServerDescription serverDescription = this.db.getConnector().getServerDescription(port.getAddress());
        return MessageSettings.builder().maxDocumentSize(serverDescription.getMaxDocumentSize()).maxMessageSize(serverDescription.getMaxMessageSize()).maxWriteBatchSize(serverDescription.getMaxWriteBatchSize()).build();
    }

    private int getMaxWriteBatchSize(DBPort port) {
        return this.db.getConnector().getServerDescription(port.getAddress()).getMaxWriteBatchSize();
    }

    private MongoNamespace getNamespace() {
        return new MongoNamespace(this.getDB().getName(), this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseWriteCommandMessage sendWriteCommandMessage(BaseWriteCommandMessage message, int batchNum, final DBPort port) {
        final PoolOutputBuffer buffer = new PoolOutputBuffer();
        try {
            BaseWriteCommandMessage nextMessage = message.encode(buffer);
            if (nextMessage != null || batchNum > 1) {
                this.getLogger().fine(String.format("Sending batch %d", batchNum));
            }
            this.db.getConnector().doOperation(this.getDB(), port, new DBPort.Operation<Void>(){

                @Override
                public Void execute() throws IOException {
                    buffer.pipe(port.getOutputStream());
                    return null;
                }
            });
            BaseWriteCommandMessage baseWriteCommandMessage = nextMessage;
            return baseWriteCommandMessage;
        }
        finally {
            buffer.reset();
        }
    }

    private CommandResult receiveWriteCommandMessage(final DBPort port) {
        return this.db.getConnector().doOperation(this.getDB(), port, new DBPort.Operation<CommandResult>(){

            @Override
            public CommandResult execute() throws IOException {
                Response response = new Response(port.getAddress(), null, port.getInputStream(), DefaultDBDecoder.FACTORY.create());
                CommandResult writeCommandResult = new CommandResult(port.getAddress());
                writeCommandResult.putAll(response.get(0));
                writeCommandResult.throwOnError();
                return writeCommandResult;
            }
        });
    }

    private WriteResult insertWithWriteProtocol(List<DBObject> list, WriteConcern concern, DBEncoder encoder, DBPort port, boolean shouldApply) {
        if (shouldApply) {
            this.applyRulesForInsert(list);
        }
        WriteResult last = null;
        int cur = 0;
        int maxsize = this.db._mongo.getMaxBsonObjectSize();
        while (cur < list.size()) {
            OutMessage om = OutMessage.insert(this, encoder, concern);
            while (cur < list.size()) {
                DBObject o = list.get(cur);
                om.putObject(o);
                if (om.size() > 2 * maxsize) {
                    ++cur;
                    break;
                }
                ++cur;
            }
            last = this.db.getConnector().say(this._db, om, concern, port);
        }
        return last;
    }

    private Iterable<Run> getRunGenerator(boolean ordered, List<WriteRequest> writeRequests, WriteConcern writeConcern, DBEncoder encoder, DBPort port) {
        if (ordered) {
            return new OrderedRunGenerator(writeRequests, writeConcern, encoder, port);
        }
        return new UnorderedRunGenerator(writeRequests, writeConcern, encoder, port);
    }

    private boolean willTrace() {
        return TRACE_LOGGER.isLoggable(TRACE_LEVEL);
    }

    private void trace(String s) {
        TRACE_LOGGER.log(TRACE_LEVEL, s);
    }

    private Logger getLogger() {
        return TRACE_LOGGER;
    }

    private class Run {
        private final List<WriteRequest> writeRequests = new ArrayList<WriteRequest>();
        private final WriteRequest.Type type;
        private final WriteConcern writeConcern;
        private final DBEncoder encoder;
        private IndexMap indexMap;

        Run(WriteRequest.Type type, WriteConcern writeConcern, DBEncoder encoder) {
            this.type = type;
            this.indexMap = IndexMap.create();
            this.writeConcern = writeConcern;
            this.encoder = encoder;
        }

        void add(WriteRequest writeRequest, int originalIndex) {
            this.indexMap = this.indexMap.add(this.writeRequests.size(), originalIndex);
            this.writeRequests.add(writeRequest);
        }

        public int size() {
            return this.writeRequests.size();
        }

        BulkWriteResult execute(DBPort port) {
            if (this.type == WriteRequest.Type.UPDATE) {
                return this.executeUpdates(this.getWriteRequestsAsModifyRequests(), port);
            }
            if (this.type == WriteRequest.Type.REPLACE) {
                return this.executeReplaces(this.getWriteRequestsAsModifyRequests(), port);
            }
            if (this.type == WriteRequest.Type.INSERT) {
                return this.executeInserts(this.getWriteRequestsAsInsertRequests(), port);
            }
            if (this.type == WriteRequest.Type.REMOVE) {
                return this.executeRemoves(this.getWriteRequestsAsRemoveRequests(), port);
            }
            throw new MongoInternalException(String.format("Unsupported write of type %s", new Object[]{this.type}));
        }

        private List getWriteRequestsAsRaw() {
            return this.writeRequests;
        }

        private List<RemoveRequest> getWriteRequestsAsRemoveRequests() {
            return this.getWriteRequestsAsRaw();
        }

        private List<InsertRequest> getWriteRequestsAsInsertRequests() {
            return this.getWriteRequestsAsRaw();
        }

        private List<ModifyRequest> getWriteRequestsAsModifyRequests() {
            return this.getWriteRequestsAsRaw();
        }

        BulkWriteResult executeUpdates(final List<ModifyRequest> updateRequests, final DBPort port) {
            for (ModifyRequest request : updateRequests) {
                for (String key : request.getUpdateDocument().keySet()) {
                    if (key.startsWith("$")) continue;
                    throw new IllegalArgumentException("Update document keys must start with $: " + key);
                }
            }
            return new RunExecutor(port){

                @Override
                BulkWriteResult executeWriteCommandProtocol() {
                    return DBCollectionImpl.this.updateWithCommandProtocol(updateRequests, Run.this.writeConcern, Run.this.encoder, port);
                }

                @Override
                WriteResult executeWriteProtocol(int i) {
                    ModifyRequest update = (ModifyRequest)updateRequests.get(i);
                    WriteResult writeResult = DBCollectionImpl.this.update(update.getQuery(), update.getUpdateDocument(), update.isUpsert(), update.isMulti(), Run.this.writeConcern, Run.this.encoder);
                    return this.addMissingUpserted(update, writeResult);
                }

                @Override
                WriteRequest.Type getType() {
                    return WriteRequest.Type.UPDATE;
                }
            }.execute();
        }

        BulkWriteResult executeReplaces(final List<ModifyRequest> replaceRequests, final DBPort port) {
            for (ModifyRequest request : replaceRequests) {
                DBCollectionImpl.this._checkObject(request.getUpdateDocument(), false, false);
            }
            return new RunExecutor(port){

                @Override
                BulkWriteResult executeWriteCommandProtocol() {
                    return DBCollectionImpl.this.updateWithCommandProtocol(replaceRequests, Run.this.writeConcern, Run.this.encoder, port);
                }

                @Override
                WriteResult executeWriteProtocol(int i) {
                    ModifyRequest update = (ModifyRequest)replaceRequests.get(i);
                    WriteResult writeResult = DBCollectionImpl.this.update(update.getQuery(), update.getUpdateDocument(), update.isUpsert(), update.isMulti(), Run.this.writeConcern, Run.this.encoder);
                    return this.addMissingUpserted(update, writeResult);
                }

                @Override
                WriteRequest.Type getType() {
                    return WriteRequest.Type.REPLACE;
                }
            }.execute();
        }

        BulkWriteResult executeRemoves(final List<RemoveRequest> removeRequests, final DBPort port) {
            return new RunExecutor(port){

                @Override
                BulkWriteResult executeWriteCommandProtocol() {
                    return DBCollectionImpl.this.removeWithCommandProtocol(removeRequests, Run.this.writeConcern, Run.this.encoder, port);
                }

                @Override
                WriteResult executeWriteProtocol(int i) {
                    RemoveRequest removeRequest = (RemoveRequest)removeRequests.get(i);
                    return DBCollectionImpl.this.remove(removeRequest.getQuery(), removeRequest.isMulti(), Run.this.writeConcern, Run.this.encoder);
                }

                @Override
                WriteRequest.Type getType() {
                    return WriteRequest.Type.REMOVE;
                }
            }.execute();
        }

        BulkWriteResult executeInserts(final List<InsertRequest> insertRequests, final DBPort port) {
            return new RunExecutor(port){

                @Override
                BulkWriteResult executeWriteCommandProtocol() {
                    ArrayList<DBObject> documents = new ArrayList<DBObject>(insertRequests.size());
                    for (InsertRequest cur : insertRequests) {
                        documents.add(cur.getDocument());
                    }
                    return DBCollectionImpl.this.insertWithCommandProtocol(documents, Run.this.writeConcern, Run.this.encoder, port, true);
                }

                @Override
                WriteResult executeWriteProtocol(int i) {
                    return DBCollectionImpl.this.insert(Arrays.asList(((InsertRequest)insertRequests.get(i)).getDocument()), Run.this.writeConcern, Run.this.encoder);
                }

                @Override
                WriteRequest.Type getType() {
                    return WriteRequest.Type.INSERT;
                }
            }.execute();
        }

        private abstract class RunExecutor {
            private final DBPort port;

            RunExecutor(DBPort port) {
                this.port = port;
            }

            abstract BulkWriteResult executeWriteCommandProtocol();

            abstract WriteResult executeWriteProtocol(int var1);

            abstract WriteRequest.Type getType();

            BulkWriteResult getResult(WriteResult writeResult) {
                int count = this.getCount(writeResult);
                List<BulkWriteUpsert> upsertedItems = this.getUpsertedItems(writeResult);
                Integer modifiedCount = this.getType() == WriteRequest.Type.UPDATE || this.getType() == WriteRequest.Type.REPLACE ? null : Integer.valueOf(0);
                return new AcknowledgedBulkWriteResult(this.getType(), count - upsertedItems.size(), modifiedCount, upsertedItems);
            }

            BulkWriteResult execute() {
                if (DBCollectionImpl.this.useWriteCommands(Run.this.writeConcern, this.port)) {
                    return this.executeWriteCommandProtocol();
                }
                return this.executeWriteProtocol();
            }

            private BulkWriteResult executeWriteProtocol() {
                BulkWriteBatchCombiner bulkWriteBatchCombiner = new BulkWriteBatchCombiner(this.port.getAddress(), Run.this.writeConcern);
                for (int i = 0; i < Run.this.writeRequests.size(); ++i) {
                    IndexMap indexMap = IndexMap.create(i, 1);
                    try {
                        WriteResult writeResult = this.executeWriteProtocol(i);
                        if (!Run.this.writeConcern.callGetLastError()) continue;
                        bulkWriteBatchCombiner.addResult(this.getResult(writeResult), indexMap);
                        continue;
                    }
                    catch (WriteConcernException writeException) {
                        if (this.isWriteConcernError(writeException.getCommandResult())) {
                            bulkWriteBatchCombiner.addResult(this.getResult(new WriteResult(writeException.getCommandResult(), Run.this.writeConcern)), indexMap);
                            bulkWriteBatchCombiner.addWriteConcernErrorResult(this.getWriteConcernError(writeException.getCommandResult()));
                        } else {
                            bulkWriteBatchCombiner.addWriteErrorResult(this.getBulkWriteError(writeException), indexMap);
                        }
                        if (bulkWriteBatchCombiner.shouldStopSendingMoreBatches()) break;
                    }
                }
                return bulkWriteBatchCombiner.getResult();
            }

            private int getCount(WriteResult writeResult) {
                return this.getType() == WriteRequest.Type.INSERT ? 1 : writeResult.getN();
            }

            List<BulkWriteUpsert> getUpsertedItems(WriteResult writeResult) {
                return writeResult.getUpsertedId() == null ? Collections.emptyList() : Arrays.asList(new BulkWriteUpsert(0, writeResult.getUpsertedId()));
            }

            private BulkWriteError getBulkWriteError(WriteConcernException writeException) {
                return new BulkWriteError(writeException.getCode(), writeException.getCommandResult().getString("err"), this.getErrorResponseDetails(writeException.getCommandResult()), 0);
            }

            private boolean isWriteConcernError(CommandResult commandResult) {
                return commandResult.get("wtimeout") != null;
            }

            private WriteConcernError getWriteConcernError(CommandResult commandResult) {
                return new WriteConcernError(commandResult.getCode(), this.getWriteConcernErrorMessage(commandResult), this.getErrorResponseDetails(commandResult));
            }

            private String getWriteConcernErrorMessage(CommandResult commandResult) {
                return commandResult.getString("err");
            }

            private DBObject getErrorResponseDetails(DBObject response) {
                BasicDBObject details = new BasicDBObject();
                for (String key : response.keySet()) {
                    if (Arrays.asList("ok", "err", "code").contains(key)) continue;
                    details.put(key, response.get(key));
                }
                return details;
            }

            WriteResult addMissingUpserted(ModifyRequest update, WriteResult writeResult) {
                if (update.isUpsert() && Run.this.writeConcern.callGetLastError() && !writeResult.isUpdateOfExisting() && writeResult.getUpsertedId() == null) {
                    DBObject updateDocument = update.getUpdateDocument();
                    DBObject query = update.getQuery();
                    if (updateDocument.containsField("_id")) {
                        CommandResult commandResult = writeResult.getLastError();
                        commandResult.put("upserted", updateDocument.get("_id"));
                        return new WriteResult(commandResult, writeResult.getLastConcern());
                    }
                    if (query.containsField("_id")) {
                        CommandResult commandResult = writeResult.getLastError();
                        commandResult.put("upserted", query.get("_id"));
                        return new WriteResult(commandResult, writeResult.getLastConcern());
                    }
                }
                return writeResult;
            }
        }
    }

    private class UnorderedRunGenerator
    implements Iterable<Run> {
        private final List<WriteRequest> writeRequests;
        private final WriteConcern writeConcern;
        private final DBEncoder encoder;
        private final int maxBatchWriteSize;

        public UnorderedRunGenerator(List<WriteRequest> writeRequests, WriteConcern writeConcern, DBEncoder encoder, DBPort port) {
            this.writeRequests = writeRequests;
            this.writeConcern = writeConcern.continueOnError(true);
            this.encoder = encoder;
            this.maxBatchWriteSize = DBCollectionImpl.this.getMaxWriteBatchSize(port);
        }

        @Override
        public Iterator<Run> iterator() {
            return new Iterator<Run>(){
                private final Map<WriteRequest.Type, Run> runs = new TreeMap<WriteRequest.Type, Run>(new Comparator<WriteRequest.Type>(){

                    @Override
                    public int compare(WriteRequest.Type first, WriteRequest.Type second) {
                        return first.compareTo(second);
                    }
                });
                private int curIndex;

                @Override
                public boolean hasNext() {
                    return this.curIndex < UnorderedRunGenerator.this.writeRequests.size() || !this.runs.isEmpty();
                }

                @Override
                public Run next() {
                    while (this.curIndex < UnorderedRunGenerator.this.writeRequests.size()) {
                        WriteRequest writeRequest = (WriteRequest)UnorderedRunGenerator.this.writeRequests.get(this.curIndex);
                        Run run = this.runs.get((Object)writeRequest.getType());
                        if (run == null) {
                            run = new Run(writeRequest.getType(), UnorderedRunGenerator.this.writeConcern, UnorderedRunGenerator.this.encoder);
                            this.runs.put(run.type, run);
                        }
                        run.add(writeRequest, this.curIndex);
                        ++this.curIndex;
                        if (run.size() != UnorderedRunGenerator.this.maxBatchWriteSize) continue;
                        return this.runs.remove((Object)run.type);
                    }
                    return this.runs.remove((Object)this.runs.keySet().iterator().next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not implemented");
                }
            };
        }
    }

    private class OrderedRunGenerator
    implements Iterable<Run> {
        private final List<WriteRequest> writeRequests;
        private final WriteConcern writeConcern;
        private final DBEncoder encoder;
        private final int maxBatchWriteSize;

        public OrderedRunGenerator(List<WriteRequest> writeRequests, WriteConcern writeConcern, DBEncoder encoder, DBPort port) {
            this.writeRequests = writeRequests;
            this.writeConcern = writeConcern.continueOnError(false);
            this.encoder = encoder;
            this.maxBatchWriteSize = DBCollectionImpl.this.getMaxWriteBatchSize(port);
        }

        @Override
        public Iterator<Run> iterator() {
            return new Iterator<Run>(){
                private int curIndex;

                @Override
                public boolean hasNext() {
                    return this.curIndex < OrderedRunGenerator.this.writeRequests.size();
                }

                @Override
                public Run next() {
                    Run run = new Run(((WriteRequest)OrderedRunGenerator.this.writeRequests.get(this.curIndex)).getType(), OrderedRunGenerator.this.writeConcern, OrderedRunGenerator.this.encoder);
                    int startIndexOfNextRun = this.getStartIndexOfNextRun();
                    for (int i = this.curIndex; i < startIndexOfNextRun; ++i) {
                        run.add((WriteRequest)OrderedRunGenerator.this.writeRequests.get(i), i);
                    }
                    this.curIndex = startIndexOfNextRun;
                    return run;
                }

                private int getStartIndexOfNextRun() {
                    WriteRequest.Type type = ((WriteRequest)OrderedRunGenerator.this.writeRequests.get(this.curIndex)).getType();
                    for (int i = this.curIndex; i < OrderedRunGenerator.this.writeRequests.size(); ++i) {
                        if (i != this.curIndex + OrderedRunGenerator.this.maxBatchWriteSize && ((WriteRequest)OrderedRunGenerator.this.writeRequests.get(i)).getType() == type) continue;
                        return i;
                    }
                    return OrderedRunGenerator.this.writeRequests.size();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not implemented");
                }
            };
        }
    }
}

