/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.mongodb.DB;
import com.massivecraft.massivecore.xlib.mongodb.DBCollection;
import com.massivecraft.massivecore.xlib.mongodb.DBObject;
import com.massivecraft.massivecore.xlib.mongodb.MongoException;
import com.massivecraft.massivecore.xlib.mongodb.MongoInternalException;
import java.io.Serializable;

public class DBRefBase
implements Serializable {
    private static final long serialVersionUID = 3031885741395465814L;
    final Object _id;
    final String _ns;
    final transient DB _db;
    private boolean _loadedPointedTo = false;
    private DBObject _pointedTo;

    public DBRefBase(DB db, String ns, Object id) {
        this._db = db;
        this._ns = ns.intern();
        this._id = id;
    }

    protected DBRefBase() {
        this._id = null;
        this._ns = null;
        this._db = null;
    }

    public DBObject fetch() throws MongoException {
        if (this._loadedPointedTo) {
            return this._pointedTo;
        }
        if (this._db == null) {
            throw new MongoInternalException("no db");
        }
        DBCollection coll = this._db.getCollectionFromString(this._ns);
        this._pointedTo = coll.findOne(this._id);
        this._loadedPointedTo = true;
        return this._pointedTo;
    }

    public String toString() {
        return "{ \"$ref\" : \"" + this._ns + "\", \"$id\" : \"" + this._id + "\" }";
    }

    public Object getId() {
        return this._id;
    }

    public String getRef() {
        return this._ns;
    }

    public DB getDB() {
        return this._db;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBRefBase dbRefBase = (DBRefBase)o;
        if (this._id != null ? !this._id.equals(dbRefBase._id) : dbRefBase._id != null) {
            return false;
        }
        return !(this._ns != null ? !this._ns.equals(dbRefBase._ns) : dbRefBase._ns != null);
    }

    public int hashCode() {
        int result = this._id != null ? this._id.hashCode() : 0;
        result = 31 * result + (this._ns != null ? this._ns.hashCode() : 0);
        return result;
    }
}

