/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.mongodb.ClusterableServer;
import com.massivecraft.massivecore.xlib.mongodb.ClusterableServerFactory;
import com.massivecraft.massivecore.xlib.mongodb.ConnectionPoolSettings;
import com.massivecraft.massivecore.xlib.mongodb.DBPortFactory;
import com.massivecraft.massivecore.xlib.mongodb.DefaultServer;
import com.massivecraft.massivecore.xlib.mongodb.JMXConnectionPoolListener;
import com.massivecraft.massivecore.xlib.mongodb.Mongo;
import com.massivecraft.massivecore.xlib.mongodb.MongoOptions;
import com.massivecraft.massivecore.xlib.mongodb.PooledConnectionProvider;
import com.massivecraft.massivecore.xlib.mongodb.ServerAddress;
import com.massivecraft.massivecore.xlib.mongodb.ServerSettings;
import java.util.concurrent.TimeUnit;

class DefaultClusterableServerFactory
implements ClusterableServerFactory {
    private final String clusterId;
    private ServerSettings settings;
    private final Mongo mongo;

    public DefaultClusterableServerFactory(String clusterId, ServerSettings settings, Mongo mongo) {
        this.clusterId = clusterId;
        this.settings = settings;
        this.mongo = mongo;
    }

    @Override
    public ClusterableServer create(ServerAddress serverAddress) {
        MongoOptions options = this.mongo.getMongoOptions();
        ConnectionPoolSettings connectionPoolSettings = ConnectionPoolSettings.builder().minSize(options.minConnectionsPerHost).maxSize(options.getConnectionsPerHost()).maxConnectionIdleTime(options.maxConnectionIdleTime, TimeUnit.MILLISECONDS).maxConnectionLifeTime(options.maxConnectionLifeTime, TimeUnit.MILLISECONDS).maxWaitQueueSize(options.getConnectionsPerHost() * options.getThreadsAllowedToBlockForConnectionMultiplier()).maxWaitTime(options.getMaxWaitTime(), TimeUnit.MILLISECONDS).build();
        return new DefaultServer(serverAddress, this.settings, this.clusterId, new PooledConnectionProvider(this.clusterId, serverAddress, new DBPortFactory(options), connectionPoolSettings, new JMXConnectionPoolListener(this.mongo.getMongoOptions().getDescription())), this.mongo);
    }

    @Override
    public ServerSettings getSettings() {
        return this.settings;
    }
}

