/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.bson.BSONObject;
import com.massivecraft.massivecore.xlib.bson.BasicBSONEncoder;
import com.massivecraft.massivecore.xlib.bson.io.OutputBuffer;
import com.massivecraft.massivecore.xlib.bson.types.ObjectId;
import com.massivecraft.massivecore.xlib.mongodb.DBEncoder;
import com.massivecraft.massivecore.xlib.mongodb.DBEncoderFactory;
import com.massivecraft.massivecore.xlib.mongodb.DBRefBase;

public class DefaultDBEncoder
extends BasicBSONEncoder
implements DBEncoder {
    public static DBEncoderFactory FACTORY = new DefaultFactory();

    @Override
    public int writeObject(OutputBuffer buf, BSONObject o) {
        this.set(buf);
        int x = super.putObject(o);
        this.done();
        return x;
    }

    @Override
    protected boolean putSpecial(String name, Object val) {
        if (val instanceof DBRefBase) {
            this.putDBRef(name, (DBRefBase)val);
            return true;
        }
        return false;
    }

    @Deprecated
    protected void putDBPointer(String name, String ns, ObjectId oid) {
        this._put((byte)12, name);
        this._putValueString(ns);
        this._buf.writeInt(oid._time());
        this._buf.writeInt(oid._machine());
        this._buf.writeInt(oid._inc());
    }

    protected void putDBRef(String name, DBRefBase ref) {
        this._put((byte)3, name);
        int sizePos = this._buf.getPosition();
        this._buf.writeInt(0);
        this._putObjectField("$ref", ref.getRef());
        this._putObjectField("$id", ref.getId());
        this._buf.write(0);
        this._buf.writeInt(sizePos, this._buf.getPosition() - sizePos);
    }

    public String toString() {
        return "DefaultDBEncoder";
    }

    static class DefaultFactory
    implements DBEncoderFactory {
        DefaultFactory() {
        }

        @Override
        public DBEncoder create() {
            return new DefaultDBEncoder();
        }

        public String toString() {
            return "DefaultDBEncoder.DefaultFactory";
        }
    }
}

