/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.bson.util.Assertions;
import com.massivecraft.massivecore.xlib.mongodb.ChangeEvent;
import com.massivecraft.massivecore.xlib.mongodb.ChangeListener;
import com.massivecraft.massivecore.xlib.mongodb.ClusterableServer;
import com.massivecraft.massivecore.xlib.mongodb.Connection;
import com.massivecraft.massivecore.xlib.mongodb.Mongo;
import com.massivecraft.massivecore.xlib.mongodb.PooledConnectionProvider;
import com.massivecraft.massivecore.xlib.mongodb.ServerAddress;
import com.massivecraft.massivecore.xlib.mongodb.ServerConnectionState;
import com.massivecraft.massivecore.xlib.mongodb.ServerDescription;
import com.massivecraft.massivecore.xlib.mongodb.ServerMonitor;
import com.massivecraft.massivecore.xlib.mongodb.ServerSettings;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

class DefaultServer
implements ClusterableServer {
    private final ServerAddress serverAddress;
    private final ServerMonitor serverMonitor;
    private final PooledConnectionProvider connectionProvider;
    private final Map<ChangeListener<ServerDescription>, Boolean> changeListeners = new ConcurrentHashMap<ChangeListener<ServerDescription>, Boolean>();
    private final ChangeListener<ServerDescription> serverStateListener;
    private volatile ServerDescription description;
    private volatile boolean isClosed;

    public DefaultServer(ServerAddress serverAddress, ServerSettings settings, String clusterId, PooledConnectionProvider connectionProvider, Mongo mongo) {
        this.serverAddress = Assertions.notNull("serverAddress", serverAddress);
        this.description = ServerDescription.builder().state(ServerConnectionState.Connecting).address(serverAddress).build();
        this.serverStateListener = new DefaultServerStateListener();
        this.connectionProvider = connectionProvider;
        this.serverMonitor = new ServerMonitor(serverAddress, this.serverStateListener, settings.getHeartbeatSocketSettings(), settings, clusterId, mongo, connectionProvider);
        this.serverMonitor.start();
    }

    @Override
    public ServerDescription getDescription() {
        Assertions.isTrue("open", !this.isClosed());
        return this.description;
    }

    @Override
    public Connection getConnection(long maxWaitTime, TimeUnit timeUnit) {
        return this.connectionProvider.get(maxWaitTime, timeUnit);
    }

    @Override
    public void addChangeListener(ChangeListener<ServerDescription> changeListener) {
        Assertions.isTrue("open", !this.isClosed());
        this.changeListeners.put(changeListener, true);
    }

    @Override
    public void invalidate() {
        Assertions.isTrue("open", !this.isClosed());
        this.serverStateListener.stateChanged(new ChangeEvent<ServerDescription>(this.description, ServerDescription.builder().state(ServerConnectionState.Connecting).address(this.serverAddress).build()));
        this.connectionProvider.invalidate();
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.serverMonitor.close();
            this.connectionProvider.close();
            this.isClosed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void connect() {
        this.serverMonitor.connect();
    }

    private final class DefaultServerStateListener
    implements ChangeListener<ServerDescription> {
        private DefaultServerStateListener() {
        }

        @Override
        public void stateChanged(ChangeEvent<ServerDescription> event) {
            DefaultServer.this.description = event.getNewValue();
            for (ChangeListener listener : DefaultServer.this.changeListeners.keySet()) {
                listener.stateChanged(event);
            }
        }
    }
}

