/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.bson.io.OutputBuffer;
import com.massivecraft.massivecore.xlib.mongodb.BSONBinaryWriter;
import com.massivecraft.massivecore.xlib.mongodb.BaseWriteCommandMessage;
import com.massivecraft.massivecore.xlib.mongodb.DBEncoder;
import com.massivecraft.massivecore.xlib.mongodb.DBObject;
import com.massivecraft.massivecore.xlib.mongodb.MessageSettings;
import com.massivecraft.massivecore.xlib.mongodb.MongoNamespace;
import com.massivecraft.massivecore.xlib.mongodb.WriteConcern;
import java.util.List;

class InsertCommandMessage
extends BaseWriteCommandMessage {
    private final List<DBObject> documents;
    private final DBEncoder encoder;

    public InsertCommandMessage(MongoNamespace namespace, WriteConcern writeConcern, List<DBObject> documents, DBEncoder commandEncoder, DBEncoder encoder, MessageSettings settings) {
        super(namespace, writeConcern, commandEncoder, settings);
        this.documents = documents;
        this.encoder = encoder;
    }

    @Override
    protected String getCommandName() {
        return "insert";
    }

    @Override
    protected InsertCommandMessage writeTheWrites(OutputBuffer buffer, int commandStartPosition, BSONBinaryWriter writer) {
        InsertCommandMessage nextMessage = null;
        writer.writeStartArray("documents");
        writer.pushMaxDocumentSize(this.getSettings().getMaxDocumentSize());
        for (int i = 0; i < this.documents.size(); ++i) {
            writer.mark();
            writer.encodeDocument(this.encoder, this.documents.get(i));
            if (!this.exceedsLimits(buffer.getPosition() - commandStartPosition, i + 1)) continue;
            writer.reset();
            nextMessage = new InsertCommandMessage(this.getWriteNamespace(), this.getWriteConcern(), this.documents.subList(i, this.documents.size()), this.getCommandEncoder(), this.encoder, this.getSettings());
            break;
        }
        writer.popMaxDocumentSize();
        writer.writeEndArray();
        return nextMessage;
    }

    @Override
    public int getItemCount() {
        return this.documents.size();
    }
}

