/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.mongodb.ConnectionEvent;
import com.massivecraft.massivecore.xlib.mongodb.ConnectionPoolEvent;
import com.massivecraft.massivecore.xlib.mongodb.ConnectionPoolListener;
import com.massivecraft.massivecore.xlib.mongodb.ConnectionPoolOpenedEvent;
import com.massivecraft.massivecore.xlib.mongodb.ConnectionPoolStatistics;
import com.massivecraft.massivecore.xlib.mongodb.ConnectionPoolStatisticsMBean;
import com.massivecraft.massivecore.xlib.mongodb.ConnectionPoolWaitQueueEvent;
import com.massivecraft.massivecore.xlib.mongodb.ServerAddress;
import com.massivecraft.massivecore.xlib.mongodb.util.management.MBeanServerFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class JMXConnectionPoolListener
implements ConnectionPoolListener {
    private final ConcurrentMap<ClusterIdServerAddressPair, ConnectionPoolStatistics> map = new ConcurrentHashMap<ClusterIdServerAddressPair, ConnectionPoolStatistics>();
    private final String clusterDescription;

    public JMXConnectionPoolListener(String clusterDescription) {
        this.clusterDescription = clusterDescription;
    }

    public String getMBeanObjectName(String clusterId, ServerAddress serverAddress) {
        String adjustedClusterId = clusterId.replace(":", "%3A");
        String adjustedHost = serverAddress.getHost().replace(":", "%3A");
        String objectName = String.format("org.mongodb.driver:type=ConnectionPool,clusterId=%s,host=%s,port=%s", adjustedClusterId, adjustedHost, serverAddress.getPort());
        if (this.clusterDescription != null) {
            String adjustedClusterDescription = this.clusterDescription.replace(":", "%3A");
            objectName = objectName + String.format(",description=%s", adjustedClusterDescription);
        }
        return objectName;
    }

    public ConnectionPoolStatisticsMBean getMBean(String clusterId, ServerAddress serverAddress) {
        return this.getStatistics(clusterId, serverAddress);
    }

    @Override
    public void connectionPoolOpened(ConnectionPoolOpenedEvent event) {
        ConnectionPoolStatistics statistics = new ConnectionPoolStatistics(event);
        this.map.put(new ClusterIdServerAddressPair(event.getClusterId(), event.getServerAddress()), statistics);
        MBeanServerFactory.getMBeanServer().registerMBean(statistics, this.getMBeanObjectName(event.getClusterId(), event.getServerAddress()));
    }

    @Override
    public void connectionPoolClosed(ConnectionPoolEvent event) {
        this.map.remove(new ClusterIdServerAddressPair(event.getClusterId(), event.getServerAddress()));
        MBeanServerFactory.getMBeanServer().unregisterMBean(this.getMBeanObjectName(event.getClusterId(), event.getServerAddress()));
    }

    @Override
    public void connectionCheckedOut(ConnectionEvent event) {
        ConnectionPoolStatistics statistics = this.getStatistics(event);
        if (statistics != null) {
            statistics.connectionCheckedOut(event);
        }
    }

    @Override
    public void connectionCheckedIn(ConnectionEvent event) {
        ConnectionPoolStatistics statistics = this.getStatistics(event);
        if (statistics != null) {
            statistics.connectionCheckedIn(event);
        }
    }

    @Override
    public void waitQueueEntered(ConnectionPoolWaitQueueEvent event) {
        ConnectionPoolListener statistics = this.getStatistics(event);
        if (statistics != null) {
            statistics.waitQueueEntered(event);
        }
    }

    @Override
    public void waitQueueExited(ConnectionPoolWaitQueueEvent event) {
        ConnectionPoolListener statistics = this.getStatistics(event);
        if (statistics != null) {
            statistics.waitQueueExited(event);
        }
    }

    @Override
    public void connectionAdded(ConnectionEvent event) {
        ConnectionPoolStatistics statistics = this.getStatistics(event);
        if (statistics != null) {
            statistics.connectionAdded(event);
        }
    }

    @Override
    public void connectionRemoved(ConnectionEvent event) {
        ConnectionPoolStatistics statistics = this.getStatistics(event);
        if (statistics != null) {
            statistics.connectionRemoved(event);
        }
    }

    private ConnectionPoolStatistics getStatistics(ConnectionEvent event) {
        return this.getStatistics(event.getClusterId(), event.getServerAddress());
    }

    private ConnectionPoolListener getStatistics(ConnectionPoolEvent event) {
        return this.getStatistics(event.getClusterId(), event.getServerAddress());
    }

    private ConnectionPoolStatistics getStatistics(String clusterId, ServerAddress serverAddress) {
        return (ConnectionPoolStatistics)this.map.get(new ClusterIdServerAddressPair(clusterId, serverAddress));
    }

    private static final class ClusterIdServerAddressPair {
        private final String clusterId;
        private final ServerAddress serverAddress;

        private ClusterIdServerAddressPair(String clusterId, ServerAddress serverAddress) {
            this.clusterId = clusterId;
            this.serverAddress = serverAddress;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClusterIdServerAddressPair that = (ClusterIdServerAddressPair)o;
            if (!this.clusterId.equals(that.clusterId)) {
                return false;
            }
            return this.serverAddress.equals(that.serverAddress);
        }

        public int hashCode() {
            int result = this.clusterId.hashCode();
            result = 31 * result + this.serverAddress.hashCode();
            return result;
        }
    }
}

