/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.bson.LazyBSONCallback;
import com.massivecraft.massivecore.xlib.bson.types.ObjectId;
import com.massivecraft.massivecore.xlib.mongodb.DB;
import com.massivecraft.massivecore.xlib.mongodb.DBCallback;
import com.massivecraft.massivecore.xlib.mongodb.DBCollection;
import com.massivecraft.massivecore.xlib.mongodb.DBRef;
import com.massivecraft.massivecore.xlib.mongodb.LazyDBList;
import com.massivecraft.massivecore.xlib.mongodb.LazyDBObject;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class LazyDBCallback
extends LazyBSONCallback
implements DBCallback {
    final DBCollection _collection;
    final DB _db;
    private static final Logger log = Logger.getLogger(LazyDBCallback.class.getName());

    public LazyDBCallback(DBCollection coll) {
        this._collection = coll;
        this._db = this._collection == null ? null : this._collection.getDB();
    }

    @Override
    public Object createObject(byte[] data, int offset) {
        LazyDBObject o = new LazyDBObject(data, offset, (LazyBSONCallback)this);
        Iterator<String> it = o.keySet().iterator();
        if (it.hasNext() && it.next().equals("$ref") && o.containsField("$id")) {
            return new DBRef(this._db, o);
        }
        return o;
    }

    @Override
    public List createArray(byte[] data, int offset) {
        return new LazyDBList(data, offset, (LazyBSONCallback)this);
    }

    @Override
    public Object createDBRef(String ns, ObjectId id) {
        return new DBRef(this._db, ns, id);
    }
}

