/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.bson.BSONObject;
import com.massivecraft.massivecore.xlib.bson.io.OutputBuffer;
import com.massivecraft.massivecore.xlib.mongodb.DBEncoder;
import com.massivecraft.massivecore.xlib.mongodb.LazyDBObject;
import com.massivecraft.massivecore.xlib.mongodb.MongoException;
import java.io.IOException;

public class LazyDBEncoder
implements DBEncoder {
    @Override
    public int writeObject(OutputBuffer buf, BSONObject o) {
        if (!(o instanceof LazyDBObject)) {
            throw new IllegalArgumentException("LazyDBEncoder can only encode BSONObject instances of type LazyDBObject");
        }
        LazyDBObject lazyDBObject = (LazyDBObject)o;
        try {
            lazyDBObject.pipe(buf);
        }
        catch (IOException e) {
            throw new MongoException("Exception serializing a LazyDBObject", e);
        }
        return lazyDBObject.getBSONSize();
    }
}

