/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.bson.util.annotations.Immutable;

@Immutable
final class MongoNamespace {
    private static final String NAMESPACE_TEMPLATE = "%s.%s";
    public static final String COMMAND_COLLECTION_NAME = "$cmd";
    private final String databaseName;
    private final String collectionName;

    public MongoNamespace(String databaseName, String collectionName) {
        if (databaseName == null) {
            throw new IllegalArgumentException("database name can not be null");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Collection name can not be null");
        }
        this.databaseName = databaseName;
        this.collectionName = collectionName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getFullName() {
        return this.getDatabaseName() + "." + this.getCollectionName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoNamespace that = (MongoNamespace)o;
        if (this.collectionName != null ? !this.collectionName.equals(that.collectionName) : that.collectionName != null) {
            return false;
        }
        return !(this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null);
    }

    public String toString() {
        return this.databaseName + "." + this.collectionName;
    }

    public int hashCode() {
        int result = this.databaseName != null ? this.databaseName.hashCode() : 0;
        result = 31 * result + (this.collectionName != null ? this.collectionName.hashCode() : 0);
        return result;
    }

    public static String asNamespaceString(String databaseName, String collectionName) {
        return String.format(NAMESPACE_TEMPLATE, databaseName, collectionName);
    }
}

