/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.mongodb.ClusterConnectionMode;
import com.massivecraft.massivecore.xlib.mongodb.ClusterDescription;
import com.massivecraft.massivecore.xlib.mongodb.ClusterType;
import com.massivecraft.massivecore.xlib.mongodb.ServerAddress;
import com.massivecraft.massivecore.xlib.mongodb.ServerDescription;
import com.massivecraft.massivecore.xlib.mongodb.ServerSelector;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class MongosHAServerSelector
implements ServerSelector {
    private ServerAddress stickTo;
    private Set<ServerAddress> consideredServers = new HashSet<ServerAddress>();

    MongosHAServerSelector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServerDescription> choose(ClusterDescription clusterDescription) {
        if (clusterDescription.getConnectionMode() != ClusterConnectionMode.Multiple || clusterDescription.getType() != ClusterType.Sharded) {
            throw new IllegalArgumentException("This is not a sharded cluster with multiple mongos servers");
        }
        Set<ServerAddress> okServers = this.getOkServers(clusterDescription);
        MongosHAServerSelector mongosHAServerSelector = this;
        synchronized (mongosHAServerSelector) {
            if (!this.consideredServers.containsAll(okServers) || !okServers.contains(this.stickTo)) {
                if (this.stickTo != null && !okServers.contains(this.stickTo)) {
                    this.stickTo = null;
                    this.consideredServers.clear();
                }
                ServerDescription fastestServer = null;
                for (ServerDescription cur : clusterDescription.getAny()) {
                    if (fastestServer != null && cur.getAverageLatencyNanos() >= fastestServer.getAverageLatencyNanos()) continue;
                    fastestServer = cur;
                }
                if (fastestServer != null) {
                    this.stickTo = fastestServer.getAddress();
                    this.consideredServers.addAll(okServers);
                }
            }
            if (this.stickTo == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(clusterDescription.getByServerAddress(this.stickTo));
        }
    }

    public String toString() {
        return "MongosHAServerSelector{" + (this.stickTo == null ? "" : "stickTo=" + this.stickTo) + '}';
    }

    private Set<ServerAddress> getOkServers(ClusterDescription clusterDescription) {
        HashSet<ServerAddress> okServers = new HashSet<ServerAddress>();
        for (ServerDescription cur : clusterDescription.getAny()) {
            okServers.add(cur.getAddress());
        }
        return okServers;
    }
}

