/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.bson.util.Assertions;
import com.massivecraft.massivecore.xlib.mongodb.ConcurrentPool;
import com.massivecraft.massivecore.xlib.mongodb.Connection;
import com.massivecraft.massivecore.xlib.mongodb.ConnectionEvent;
import com.massivecraft.massivecore.xlib.mongodb.ConnectionFactory;
import com.massivecraft.massivecore.xlib.mongodb.ConnectionPoolEvent;
import com.massivecraft.massivecore.xlib.mongodb.ConnectionPoolListener;
import com.massivecraft.massivecore.xlib.mongodb.ConnectionPoolOpenedEvent;
import com.massivecraft.massivecore.xlib.mongodb.ConnectionPoolSettings;
import com.massivecraft.massivecore.xlib.mongodb.ConnectionPoolWaitQueueEvent;
import com.massivecraft.massivecore.xlib.mongodb.Loggers;
import com.massivecraft.massivecore.xlib.mongodb.MongoWaitQueueFullException;
import com.massivecraft.massivecore.xlib.mongodb.ServerAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

class PooledConnectionProvider {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private final ConcurrentPool<Connection> pool;
    private final ConnectionPoolSettings settings;
    private final AtomicInteger waitQueueSize = new AtomicInteger(0);
    private final AtomicInteger generation = new AtomicInteger(0);
    private final ExecutorService sizeMaintenanceTimer;
    private final String clusterId;
    private final ServerAddress serverAddress;
    private final Runnable maintenanceTask;
    private final ConnectionPoolListener connectionPoolListener;
    private final ConnectionFactory connectionFactory;
    private volatile boolean closed;
    private volatile boolean hasWorked;

    public PooledConnectionProvider(String clusterId, ServerAddress serverAddress, ConnectionFactory connectionFactory, ConnectionPoolSettings settings, ConnectionPoolListener connectionPoolListener) {
        this.connectionFactory = connectionFactory;
        this.clusterId = Assertions.notNull("clusterId", clusterId);
        this.serverAddress = Assertions.notNull("serverAddress", serverAddress);
        this.settings = Assertions.notNull("settings", settings);
        ConnectionItemFactory connectionItemFactory = new ConnectionItemFactory();
        this.pool = new ConcurrentPool<Connection>(settings.getMaxSize(), connectionItemFactory);
        this.maintenanceTask = this.createMaintenanceTask();
        this.sizeMaintenanceTimer = this.createTimer();
        this.connectionPoolListener = Assertions.notNull("connectionPoolListener", connectionPoolListener);
        connectionPoolListener.connectionPoolOpened(new ConnectionPoolOpenedEvent(clusterId, serverAddress, settings));
    }

    public Connection get() {
        return this.get(this.settings.getMaxWaitTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection get(long timeout, TimeUnit timeUnit) {
        try {
            if (this.waitQueueSize.incrementAndGet() > this.settings.getMaxWaitQueueSize()) {
                throw new MongoWaitQueueFullException(String.format("Too many threads are already waiting for a connection. Max number of threads (maxWaitQueueSize) of %d has been exceeded.", this.settings.getMaxWaitQueueSize()));
            }
            this.connectionPoolListener.waitQueueEntered(new ConnectionPoolWaitQueueEvent(this.clusterId, this.serverAddress, Thread.currentThread().getId()));
            Connection connection = this.pool.get(timeout, timeUnit);
            this.hasWorked = true;
            while (this.shouldPrune(connection)) {
                this.pool.release(connection, true);
                connection = this.pool.get(timeout, timeUnit);
            }
            this.connectionPoolListener.connectionCheckedOut(new ConnectionEvent(this.clusterId, this.serverAddress));
            Connection connection2 = connection;
            return connection2;
        }
        finally {
            this.waitQueueSize.decrementAndGet();
            this.connectionPoolListener.waitQueueExited(new ConnectionPoolWaitQueueEvent(this.clusterId, this.serverAddress, Thread.currentThread().getId()));
        }
    }

    public void release(Connection connection) {
        if (!this.closed) {
            this.connectionPoolListener.connectionCheckedIn(new ConnectionEvent(this.clusterId, this.serverAddress));
        }
        this.pool.release(connection, connection.isClosed() || this.shouldPrune(connection));
    }

    public boolean hasWorked() {
        return this.hasWorked;
    }

    public void close() {
        if (!this.closed) {
            this.pool.close();
            if (this.sizeMaintenanceTimer != null) {
                this.sizeMaintenanceTimer.shutdownNow();
            }
            this.closed = true;
            this.connectionPoolListener.connectionPoolClosed(new ConnectionPoolEvent(this.clusterId, this.serverAddress));
        }
    }

    public void doMaintenance() {
        if (this.maintenanceTask != null) {
            this.maintenanceTask.run();
        }
    }

    private Runnable createMaintenanceTask() {
        Runnable newMaintenanceTask = null;
        if (this.shouldPrune() || this.shouldEnsureMinSize()) {
            newMaintenanceTask = new Runnable(){

                @Override
                public synchronized void run() {
                    if (PooledConnectionProvider.this.shouldPrune()) {
                        LOGGER.fine(String.format("Pruning pooled connections to %s", PooledConnectionProvider.this.serverAddress));
                        PooledConnectionProvider.this.pool.prune();
                    }
                    if (PooledConnectionProvider.this.shouldEnsureMinSize()) {
                        LOGGER.fine(String.format("Ensuring minimum pooled connections to %s", PooledConnectionProvider.this.serverAddress));
                        PooledConnectionProvider.this.pool.ensureMinSize(PooledConnectionProvider.this.settings.getMinSize());
                    }
                }
            };
        }
        return newMaintenanceTask;
    }

    private ExecutorService createTimer() {
        if (this.maintenanceTask == null) {
            return null;
        }
        ScheduledExecutorService newTimer = Executors.newSingleThreadScheduledExecutor();
        newTimer.scheduleAtFixedRate(this.maintenanceTask, this.settings.getMaintenanceInitialDelay(TimeUnit.MILLISECONDS), this.settings.getMaintenanceFrequency(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        return newTimer;
    }

    private boolean shouldEnsureMinSize() {
        return this.settings.getMinSize() > 0;
    }

    private boolean shouldPrune() {
        return this.settings.getMaxConnectionIdleTime(TimeUnit.MILLISECONDS) > 0L || this.settings.getMaxConnectionLifeTime(TimeUnit.MILLISECONDS) > 0L;
    }

    private boolean shouldPrune(Connection connection) {
        return this.fromPreviousGeneration(connection) || this.pastMaxLifeTime(connection) || this.pastMaxIdleTime(connection);
    }

    private boolean pastMaxIdleTime(Connection connection) {
        return this.expired(connection.getLastUsedAt(), System.currentTimeMillis(), this.settings.getMaxConnectionIdleTime(TimeUnit.MILLISECONDS));
    }

    private boolean pastMaxLifeTime(Connection connection) {
        return this.expired(connection.getOpenedAt(), System.currentTimeMillis(), this.settings.getMaxConnectionLifeTime(TimeUnit.MILLISECONDS));
    }

    private boolean fromPreviousGeneration(Connection connection) {
        return this.generation.get() > connection.getGeneration();
    }

    private boolean expired(long startTime, long curTime, long maxTime) {
        return maxTime != 0L && curTime - startTime > maxTime;
    }

    public void invalidate() {
        this.generation.incrementAndGet();
    }

    private class ConnectionItemFactory
    implements ConcurrentPool.ItemFactory<Connection> {
        private ConnectionItemFactory() {
        }

        @Override
        public Connection create() {
            Connection connection = PooledConnectionProvider.this.connectionFactory.create(PooledConnectionProvider.this.serverAddress, PooledConnectionProvider.this, PooledConnectionProvider.this.generation.get());
            LOGGER.fine(String.format("Opened connection to %s", PooledConnectionProvider.this.serverAddress));
            PooledConnectionProvider.this.connectionPoolListener.connectionAdded(new ConnectionEvent(PooledConnectionProvider.this.clusterId, PooledConnectionProvider.this.serverAddress));
            return connection;
        }

        @Override
        public void close(Connection connection) {
            String reason = PooledConnectionProvider.this.fromPreviousGeneration(connection) ? "there was a socket exception raised on another connection from this pool" : (PooledConnectionProvider.this.pastMaxLifeTime(connection) ? "it is past its maximum allowed life time" : (PooledConnectionProvider.this.pastMaxIdleTime(connection) ? "it is past its maximum allowed idle time" : "the pool has been closed"));
            if (!PooledConnectionProvider.this.closed) {
                PooledConnectionProvider.this.connectionPoolListener.connectionRemoved(new ConnectionEvent(PooledConnectionProvider.this.clusterId, PooledConnectionProvider.this.serverAddress));
            }
            connection.close();
            LOGGER.fine(String.format("Closed connection to %s because %s.", PooledConnectionProvider.this.serverAddress, reason));
        }

        @Override
        public boolean shouldPrune(Connection connection) {
            return PooledConnectionProvider.this.shouldPrune(connection);
        }
    }
}

