/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.bson.io.OutputBuffer;
import com.massivecraft.massivecore.xlib.mongodb.MessageSettings;
import java.util.concurrent.atomic.AtomicInteger;

abstract class RequestMessage {
    static final AtomicInteger REQUEST_ID = new AtomicInteger(1);
    private final String collectionName;
    private MessageSettings settings;
    private final int id;
    private final OpCode opCode;

    public RequestMessage(String collectionName, OpCode opCode, MessageSettings settings) {
        this.collectionName = collectionName;
        this.settings = settings;
        this.id = REQUEST_ID.getAndIncrement();
        this.opCode = opCode;
    }

    protected void writeMessagePrologue(OutputBuffer buffer) {
        buffer.writeInt(0);
        buffer.writeInt(this.id);
        buffer.writeInt(0);
        buffer.writeInt(this.opCode.getValue());
    }

    public int getId() {
        return this.id;
    }

    public OpCode getOpCode() {
        return this.opCode;
    }

    public String getNamespace() {
        return this.getCollectionName() != null ? this.getCollectionName() : null;
    }

    public MessageSettings getSettings() {
        return this.settings;
    }

    public RequestMessage encode(OutputBuffer buffer) {
        int messageStartPosition = buffer.getPosition();
        this.writeMessagePrologue(buffer);
        RequestMessage nextMessage = this.encodeMessageBody(buffer, messageStartPosition);
        this.backpatchMessageLength(messageStartPosition, buffer);
        return nextMessage;
    }

    protected abstract RequestMessage encodeMessageBody(OutputBuffer var1, int var2);

    protected void backpatchMessageLength(int startPosition, OutputBuffer buffer) {
        int messageLength = buffer.getPosition() - startPosition;
        buffer.backpatchSize(messageLength);
    }

    protected String getCollectionName() {
        return this.collectionName;
    }

    static enum OpCode {
        OP_REPLY(1),
        OP_MSG(1000),
        OP_UPDATE(2001),
        OP_INSERT(2002),
        OP_QUERY(2004),
        OP_GETMORE(2005),
        OP_DELETE(2006),
        OP_KILL_CURSORS(2007);

        private final int value;

        private OpCode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

