/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.bson.util.Assertions;
import com.massivecraft.massivecore.xlib.mongodb.BaseCluster;
import com.massivecraft.massivecore.xlib.mongodb.ChangeEvent;
import com.massivecraft.massivecore.xlib.mongodb.ChangeListener;
import com.massivecraft.massivecore.xlib.mongodb.ClusterConnectionMode;
import com.massivecraft.massivecore.xlib.mongodb.ClusterDescription;
import com.massivecraft.massivecore.xlib.mongodb.ClusterListener;
import com.massivecraft.massivecore.xlib.mongodb.ClusterSettings;
import com.massivecraft.massivecore.xlib.mongodb.ClusterType;
import com.massivecraft.massivecore.xlib.mongodb.ClusterableServer;
import com.massivecraft.massivecore.xlib.mongodb.ClusterableServerFactory;
import com.massivecraft.massivecore.xlib.mongodb.Loggers;
import com.massivecraft.massivecore.xlib.mongodb.ServerAddress;
import com.massivecraft.massivecore.xlib.mongodb.ServerDescription;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Logger;

final class SingleServerCluster
extends BaseCluster {
    private static final Logger LOGGER = Loggers.getLogger("cluster");
    private final ClusterableServer server;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleServerCluster(String clusterId, ClusterSettings settings, ClusterableServerFactory serverFactory, ClusterListener clusterListener) {
        super(clusterId, settings, serverFactory, clusterListener);
        Assertions.isTrue("one server in a direct cluster", settings.getHosts().size() == 1);
        Assertions.isTrue("connection mode is single", settings.getMode() == ClusterConnectionMode.Single);
        LOGGER.info(String.format("Cluster created with settings %s", settings.getShortDescription()));
        SingleServerCluster singleServerCluster = this;
        synchronized (singleServerCluster) {
            this.server = this.createServer(settings.getHosts().get(0), new ChangeListener<ServerDescription>(){

                @Override
                public void stateChanged(ChangeEvent<ServerDescription> event) {
                    ServerDescription descriptionToPublish = event.getNewValue();
                    if (event.getNewValue().isOk()) {
                        if (SingleServerCluster.this.getSettings().getRequiredClusterType() != ClusterType.Unknown && SingleServerCluster.this.getSettings().getRequiredClusterType() != event.getNewValue().getClusterType()) {
                            descriptionToPublish = null;
                        } else if (SingleServerCluster.this.getSettings().getRequiredClusterType() == ClusterType.ReplicaSet && SingleServerCluster.this.getSettings().getRequiredReplicaSetName() != null && !SingleServerCluster.this.getSettings().getRequiredReplicaSetName().equals(event.getNewValue().getSetName())) {
                            descriptionToPublish = null;
                        }
                    }
                    SingleServerCluster.this.publishDescription(descriptionToPublish);
                }
            });
            this.publishDescription(this.server.getDescription());
        }
    }

    @Override
    protected void connect() {
        this.server.connect();
    }

    private void publishDescription(ServerDescription serverDescription) {
        ClusterType clusterType = this.getSettings().getRequiredClusterType();
        if (clusterType == ClusterType.Unknown && serverDescription != null) {
            clusterType = serverDescription.getClusterType();
        }
        ClusterDescription description = new ClusterDescription(ClusterConnectionMode.Single, clusterType, serverDescription == null ? Collections.emptyList() : Arrays.asList(serverDescription));
        this.updateDescription(description);
        this.fireChangeEvent();
    }

    @Override
    protected ClusterableServer getServer(ServerAddress serverAddress) {
        Assertions.isTrue("open", !this.isClosed());
        return this.server;
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.server.close();
            super.close();
        }
    }
}

