/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb;

import com.massivecraft.massivecore.xlib.bson.io.OutputBuffer;
import com.massivecraft.massivecore.xlib.mongodb.BSONBinaryWriter;
import com.massivecraft.massivecore.xlib.mongodb.BaseWriteCommandMessage;
import com.massivecraft.massivecore.xlib.mongodb.DBEncoder;
import com.massivecraft.massivecore.xlib.mongodb.MessageSettings;
import com.massivecraft.massivecore.xlib.mongodb.ModifyRequest;
import com.massivecraft.massivecore.xlib.mongodb.MongoNamespace;
import com.massivecraft.massivecore.xlib.mongodb.WriteConcern;
import java.util.List;

class UpdateCommandMessage
extends BaseWriteCommandMessage {
    private final List<ModifyRequest> updates;
    private final DBEncoder encoder;

    public UpdateCommandMessage(MongoNamespace writeNamespace, WriteConcern writeConcern, List<ModifyRequest> updates, DBEncoder commandEncoder, DBEncoder encoder, MessageSettings settings) {
        super(writeNamespace, writeConcern, commandEncoder, settings);
        this.updates = updates;
        this.encoder = encoder;
    }

    @Override
    protected UpdateCommandMessage writeTheWrites(OutputBuffer buffer, int commandStartPosition, BSONBinaryWriter writer) {
        UpdateCommandMessage nextMessage = null;
        writer.writeStartArray("updates");
        for (int i = 0; i < this.updates.size(); ++i) {
            writer.mark();
            ModifyRequest update = this.updates.get(i);
            writer.writeStartDocument();
            writer.pushMaxDocumentSize(this.getSettings().getMaxDocumentSize());
            writer.writeName("q");
            writer.encodeDocument(this.getCommandEncoder(), update.getQuery());
            writer.writeName("u");
            writer.encodeDocument(this.encoder, update.getUpdateDocument());
            if (update.isMulti()) {
                writer.writeBoolean("multi", update.isMulti());
            }
            if (update.isUpsert()) {
                writer.writeBoolean("upsert", update.isUpsert());
            }
            writer.popMaxDocumentSize();
            writer.writeEndDocument();
            if (!this.exceedsLimits(buffer.getPosition() - commandStartPosition, i + 1)) continue;
            writer.reset();
            nextMessage = new UpdateCommandMessage(this.getWriteNamespace(), this.getWriteConcern(), this.updates.subList(i, this.updates.size()), this.getCommandEncoder(), this.encoder, this.getSettings());
            break;
        }
        writer.writeEndArray();
        return nextMessage;
    }

    @Override
    public int getItemCount() {
        return this.updates.size();
    }

    @Override
    protected String getCommandName() {
        return "update";
    }
}

