/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb.gridfs;

import com.massivecraft.massivecore.xlib.bson.BSONObject;
import com.massivecraft.massivecore.xlib.mongodb.BasicDBObject;
import com.massivecraft.massivecore.xlib.mongodb.CommandResult;
import com.massivecraft.massivecore.xlib.mongodb.DBObject;
import com.massivecraft.massivecore.xlib.mongodb.MongoException;
import com.massivecraft.massivecore.xlib.mongodb.gridfs.GridFS;
import com.massivecraft.massivecore.xlib.mongodb.util.JSON;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class GridFSFile
implements DBObject {
    @Deprecated
    protected GridFS _fs = null;
    Object _id;
    String _filename;
    String _contentType;
    long _length;
    long _chunkSize;
    Date _uploadDate;
    List<String> _aliases;
    DBObject _extradata = new BasicDBObject();
    String _md5;
    static final Set<String> VALID_FIELDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("_id", "filename", "contentType", "length", "chunkSize", "uploadDate", "aliases", "md5")));

    public void save() {
        if (this._fs == null) {
            throw new MongoException("need _fs");
        }
        this._fs._filesCollection.save(this);
    }

    public void validate() {
        if (this._fs == null) {
            throw new MongoException("no _fs");
        }
        if (this._md5 == null) {
            throw new MongoException("no _md5 stored");
        }
        BasicDBObject cmd = new BasicDBObject("filemd5", this._id);
        cmd.put("root", (Object)this._fs._bucketName);
        CommandResult res = this._fs._db.command(cmd);
        if (res != null && res.containsField("md5")) {
            String m = res.get("md5").toString();
            if (m.equals(this._md5)) {
                return;
            }
            throw new MongoException("md5 differ.  mine [" + this._md5 + "] theirs [" + m + "]");
        }
        throw new MongoException("no md5 returned from server: " + res);
    }

    public int numChunks() {
        double d = this._length;
        return (int)Math.ceil(d /= (double)this._chunkSize);
    }

    public Object getId() {
        return this._id;
    }

    public String getFilename() {
        return this._filename;
    }

    public String getContentType() {
        return this._contentType;
    }

    public long getLength() {
        return this._length;
    }

    public long getChunkSize() {
        return this._chunkSize;
    }

    public Date getUploadDate() {
        return this._uploadDate;
    }

    public List<String> getAliases() {
        return (List)this._extradata.get("aliases");
    }

    public DBObject getMetaData() {
        return (DBObject)this._extradata.get("metadata");
    }

    public void setMetaData(DBObject metadata) {
        this._extradata.put("metadata", metadata);
    }

    public String getMD5() {
        return this._md5;
    }

    @Override
    public Object put(String key, Object v) {
        if (key == null) {
            throw new RuntimeException("key should never be null");
        }
        if (key.equals("_id")) {
            this._id = v;
        } else if (key.equals("filename")) {
            this._filename = v == null ? null : v.toString();
        } else if (key.equals("contentType")) {
            this._contentType = (String)v;
        } else if (key.equals("length")) {
            this._length = ((Number)v).longValue();
        } else if (key.equals("chunkSize")) {
            this._chunkSize = ((Number)v).longValue();
        } else if (key.equals("uploadDate")) {
            this._uploadDate = (Date)v;
        } else if (key.equals("md5")) {
            this._md5 = (String)v;
        } else {
            this._extradata.put(key, v);
        }
        return v;
    }

    @Override
    public Object get(String key) {
        if (key == null) {
            throw new RuntimeException("key should never be null");
        }
        if (key.equals("_id")) {
            return this._id;
        }
        if (key.equals("filename")) {
            return this._filename;
        }
        if (key.equals("contentType")) {
            return this._contentType;
        }
        if (key.equals("length")) {
            return this._length;
        }
        if (key.equals("chunkSize")) {
            return this._chunkSize;
        }
        if (key.equals("uploadDate")) {
            return this._uploadDate;
        }
        if (key.equals("md5")) {
            return this._md5;
        }
        return this._extradata.get(key);
    }

    @Override
    public void putAll(BSONObject o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map toMap() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object removeField(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean containsKey(String s) {
        return this.containsField(s);
    }

    @Override
    public boolean containsField(String s) {
        return this.keySet().contains(s);
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(VALID_FIELDS);
        keys.addAll(this._extradata.keySet());
        return keys;
    }

    @Override
    public boolean isPartialObject() {
        return false;
    }

    @Override
    public void markAsPartialObject() {
        throw new RuntimeException("can't load partial GridFSFile file");
    }

    public String toString() {
        return JSON.serialize(this);
    }

    protected GridFS getGridFS() {
        return this._fs;
    }

    protected void setGridFS(GridFS fs) {
        this._fs = fs;
    }
}

