/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.xlib.mongodb.util;

import com.massivecraft.massivecore.xlib.bson.util.ClassMap;
import com.massivecraft.massivecore.xlib.mongodb.Bytes;
import com.massivecraft.massivecore.xlib.mongodb.util.AbstractObjectSerializer;
import com.massivecraft.massivecore.xlib.mongodb.util.ObjectSerializer;
import java.util.Iterator;
import java.util.List;

class ClassMapBasedObjectSerializer
extends AbstractObjectSerializer {
    private ClassMap<ObjectSerializer> _serializers = new ClassMap();

    ClassMapBasedObjectSerializer() {
    }

    void addObjectSerializer(Class c, ObjectSerializer serializer) {
        this._serializers.put(c, serializer);
    }

    @Override
    public void serialize(Object obj, StringBuilder buf) {
        Class<?> ancestor;
        if ((obj = Bytes.applyEncodingHooks(obj)) == null) {
            buf.append(" null ");
            return;
        }
        ObjectSerializer serializer = null;
        List<Class<?>> ancestors = ClassMap.getAncestry(obj.getClass());
        Iterator<Class<?>> iterator = ancestors.iterator();
        while (iterator.hasNext() && (serializer = this._serializers.get(ancestor = iterator.next())) == null) {
        }
        if (serializer == null && obj.getClass().isArray()) {
            serializer = this._serializers.get(Object[].class);
        }
        if (serializer == null) {
            throw new RuntimeException("json can't serialize type : " + obj.getClass());
        }
        serializer.serialize(obj, buf);
    }
}

