/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite;

import codecrafter47.bungeetablistplus.BungeeTabListPlus;
import de.sabbertran.proxysuite.ProxySuite;
import de.sabbertran.proxysuite.utils.Location;
import de.sabbertran.proxysuite.utils.LoggedMessage;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.event.TabCompleteEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class Events
implements Listener {
    private ProxySuite main;
    private ArrayList<ProxiedPlayer> justJoined;

    public Events(ProxySuite main) {
        this.main = main;
        this.justJoined = new ArrayList();
    }

    @EventHandler
    public void onServerSwitch(ServerSwitchEvent ev) {
        final ProxiedPlayer p = ev.getPlayer();
        this.main.getProxy().getScheduler().schedule((Plugin)this.main, new Runnable(){

            public void run() {
                Events.this.main.getPermissionHandler().resetPermissions((CommandSender)p);
                Events.this.main.getPermissionHandler().updatePermissions(p);
            }
        }, (long)(this.main.getConfig().getInt("ProxySuite.Server.SwitchCheckDelayMS") / 2), TimeUnit.MILLISECONDS);
        if (!this.justJoined.remove(p)) {
            if (this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.Vanish") && this.main.getPlayerHandler().getVanishedPlayers().contains(p)) {
                this.main.getPlayerHandler().sendVanishToServer(p);
            }
            this.main.getProxy().getScheduler().schedule((Plugin)this.main, new Runnable(){

                public void run() {
                    if (Events.this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.Fly")) {
                        if (Events.this.main.getPermissionHandler().hasPermission((CommandSender)p, "proxysuite.player.keepflyonserverchange")) {
                            if (Events.this.main.getPlayerHandler().getFlying().contains(p)) {
                                Events.this.main.getPlayerHandler().sendFlyToServer(p);
                            }
                        } else if (Events.this.main.getPlayerHandler().getFlying().contains(p)) {
                            Events.this.main.getPlayerHandler().sendUnflyToServer(p);
                            Events.this.main.getPlayerHandler().getFlying().remove(p);
                            Events.this.main.getPlayerHandler().writeFlyToDatabase(p, false);
                            Events.this.main.getMessageHandler().sendMessage((CommandSender)p, Events.this.main.getMessageHandler().getMessage("fly.disabled"));
                        }
                    }
                    if (Events.this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.Gamemode")) {
                        if (Events.this.main.getPermissionHandler().hasPermission((CommandSender)p, "proxysuite.player.keepgamemodeonserverchange")) {
                            if (Events.this.main.getPlayerHandler().getGamemode().containsKey(p)) {
                                Events.this.main.getPlayerHandler().sendGamemodeToServer(p, Events.this.main.getPlayerHandler().getGamemode().get(p));
                            }
                        } else if (!Events.this.main.getPlayerHandler().getGamemode().get(p).equals("SURVIVAL")) {
                            Events.this.main.getPlayerHandler().setGamemode(p, "SURVIVAL");
                        }
                    }
                }
            }, (long)this.main.getConfig().getInt("ProxySuite.Server.SwitchCheckDelayMS"), TimeUnit.MILLISECONDS);
        } else {
            Location firstSpawn = this.main.getSpawnHandler().getFirstSpawn();
            if (firstSpawn != null && this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.Teleport") && this.main.getPlayerHandler().getPendingFirstSpawnTeleports().remove(p.getUniqueId())) {
                this.main.getTeleportHandler().teleportToLocation(p, firstSpawn, true, true);
            }
        }
    }

    @EventHandler
    public void onLogin(LoginEvent ev) {
        ev.registerIntent((Plugin)this.main);
        try {
            ResultSet rs = this.main.getSQLConnection().createStatement().executeQuery("SELECT * FROM " + this.main.getTablePrefix() + "bans " + "WHERE player = '" + ev.getConnection().getUniqueId() + "' ORDER BY -(expiration IS NULL), expiration DESC LIMIT 1");
            if (rs.next()) {
                Timestamp expiration = rs.getTimestamp("expiration");
                if (rs.wasNull() || expiration.after(new Date())) {
                    ev.setCancelled(true);
                    String reason = rs.wasNull() ? this.main.getMessageHandler().getMessage("join.banned").replace("%reason%", rs.getString("reason")) : this.main.getMessageHandler().getMessage("join.banneduntil").replace("%reason%", rs.getString("reason")).replace("%expiration%", this.main.getDateFormat().format(expiration));
                    ev.setCancelReason(new BaseComponent[]{new TextComponent(reason)});
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String ip = ev.getConnection().getAddress().getAddress().toString();
        if (!ev.isCancelled() && this.main.getConfig().getInt("ProxySuite.Security.MaxPlayersWithSameIP") > 0 && this.main.getPlayerHandler().getIps().containsKey(ip) && this.main.getPlayerHandler().getIps().get(ip) >= this.main.getConfig().getInt("ProxySuite.Security.MaxPlayersWithSameIP")) {
            ev.setCancelled(true);
            ev.setCancelReason(new BaseComponent[]{new TextComponent(this.main.getMessageHandler().getMessage("security.join.denied"))});
        }
        if (!ev.isCancelled()) {
            this.main.getPlayerHandler().registerLogin(ev.getConnection());
            if (this.main.getPlayerHandler().getIps().containsKey(ip)) {
                this.main.getPlayerHandler().getIps().put(ip, this.main.getPlayerHandler().getIps().get(ip) + 1);
            } else {
                this.main.getPlayerHandler().getIps().put(ip, 1);
            }
        }
        ev.completeIntent((Plugin)this.main);
    }

    @EventHandler
    public void onPostLogin(final PostLoginEvent ev) {
        final ProxiedPlayer p = ev.getPlayer();
        this.justJoined.add(p);
        if (this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.Home")) {
            this.main.getHomeHandler().updateHomesFromDatabase(p);
        }
        this.main.getProxy().getScheduler().schedule((Plugin)this.main, new Runnable(){

            public void run() {
                if (Events.this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.BanKickWarn")) {
                    Events.this.main.getProxy().getScheduler().runAsync((Plugin)Events.this.main, new Runnable(){

                        public void run() {
                            try {
                                ResultSet rs = Events.this.main.getSQLConnection().createStatement().executeQuery("SELECT id FROM " + Events.this.main.getTablePrefix() + "warnings " + "WHERE player = '" + p.getUniqueId() + "' AND archived = '0' AND " + "(UNIX_TIMESTAMP(date) + " + Events.this.main.getConfig().getInt("ProxySuite.Warnings.TimeUntilArchive") * 24 * 60 * 60 + ") <= UNIX_TIMESTAMP(now())");
                                while (rs.next()) {
                                    Events.this.main.getWarningHandler().archiveWarn(rs.getInt("id"));
                                }
                                if (Events.this.main.getPermissionHandler().hasPermission((CommandSender)p, "proxysuite.messages.warnings.joininfo") && (rs = Events.this.main.getSQLConnection().createStatement().executeQuery("SELECT * FROM " + Events.this.main.getTablePrefix() + "warnings " + "WHERE player = '" + p.getUniqueId() + "' AND player_read = '0'")).next()) {
                                    Events.this.main.getMessageHandler().sendMessage((CommandSender)p, Events.this.main.getMessageHandler().getMessage("warning.unread"));
                                    rs.previous();
                                    while (rs.next()) {
                                        Events.this.main.getMessageHandler().sendMessage((CommandSender)p, Events.this.main.getMessageHandler().getMessage("warning.unread.entry").replace("%id%", "" + rs.getInt("id")).replace("%reason%", rs.getString("reason")));
                                    }
                                    Events.this.main.getMessageHandler().sendMessage((CommandSender)p, Events.this.main.getMessageHandler().getMessage("warning.unread.hideinfo"));
                                }
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                Events.this.main.getProxy().getScheduler().schedule((Plugin)Events.this.main, new Runnable(){

                    public void run() {
                        Events.this.main.getMessageHandler().broadcast(Events.this.main.getMessageHandler().getMessage("join.broadcast").replace("%player%", ev.getPlayer().getName()).replace("%player%", p.getName()).replace("%prefix%", Events.this.main.getPlayerHandler().getPrefix(p)).replace("%suffix%", Events.this.main.getPlayerHandler().getSuffix(p)));
                        if (Events.this.main.getPermissionHandler().hasPermission((CommandSender)p, "proxysuite.messages.motd")) {
                            for (String s : Events.this.main.getConfig().getStringList("ProxySuite.Messages.MOTD")) {
                                Events.this.main.getMessageHandler().sendMessage((CommandSender)p, s);
                            }
                        }
                    }
                }, (long)Events.this.main.getConfig().getInt("ProxySuite.Messages.JoinMessageDelayMS"), TimeUnit.MILLISECONDS);
                if (Events.this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.Vanish")) {
                    Events.this.main.getProxy().getScheduler().runAsync((Plugin)Events.this.main, new Runnable(){

                        public void run() {
                            try {
                                ResultSet rs = Events.this.main.getSQLConnection().createStatement().executeQuery("SELECT vanished FROM " + Events.this.main.getTablePrefix() + "players WHERE uuid = '" + p.getUniqueId() + "'");
                                if (rs.next() && rs.getBoolean("vanished")) {
                                    Events.this.main.getPlayerHandler().getVanishedPlayers().add(p);
                                    Events.this.main.getPlayerHandler().sendVanishToServer(p);
                                    if (Events.this.main.isBungeeTabListPlusInstalled()) {
                                        BungeeTabListPlus.hidePlayer((ProxiedPlayer)p);
                                    }
                                }
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                if (Events.this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.Fly")) {
                    Events.this.main.getProxy().getScheduler().runAsync((Plugin)Events.this.main, new Runnable(){

                        public void run() {
                            try {
                                ResultSet rs = Events.this.main.getSQLConnection().createStatement().executeQuery("SELECT flying FROM " + Events.this.main.getTablePrefix() + "players WHERE uuid = '" + p.getUniqueId() + "'");
                                if (rs.next() && rs.getBoolean("flying")) {
                                    Events.this.main.getPlayerHandler().getFlying().add(p);
                                }
                                if (Events.this.main.getPlayerHandler().getFlying().contains(p)) {
                                    Events.this.main.getPlayerHandler().sendFlyToServer(p);
                                } else {
                                    Events.this.main.getPlayerHandler().sendUnflyToServer(p);
                                }
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                if (Events.this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.Gamemode")) {
                    Events.this.main.getProxy().getScheduler().runAsync((Plugin)Events.this.main, new Runnable(){

                        public void run() {
                            try {
                                ResultSet rs = Events.this.main.getSQLConnection().createStatement().executeQuery("SELECT gamemode FROM " + Events.this.main.getTablePrefix() + "players WHERE uuid = '" + p.getUniqueId() + "'");
                                if (rs.next()) {
                                    Events.this.main.getPlayerHandler().getGamemode().put(p, rs.getString("gamemode"));
                                    Events.this.main.getPlayerHandler().sendGamemodeToServer(p, rs.getString("gamemode"));
                                }
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                Events.this.main.getMessageHandler().getLastMessages().put(p, new LoggedMessage[Events.this.main.getConfig().getInt("ProxySuite.Logging.LastMessagesLogged")]);
                String ip = ev.getPlayer().getPendingConnection().getAddress().getAddress().toString();
                int max = Events.this.main.getConfig().getInt("ProxySuite.Security.IPJoinInfo");
                if (max > 0 && Events.this.main.getPlayerHandler().getIps().containsKey(p) && Events.this.main.getPlayerHandler().getIps().get(ip) >= max) {
                    String players = "";
                    for (ProxiedPlayer pl : Events.this.main.getProxy().getPlayers()) {
                        if (pl == ev.getPlayer() || !pl.getPendingConnection().getAddress().getAddress().toString().equals(ip)) continue;
                        players = players + pl.getName() + ", ";
                    }
                    if (players.length() > 1) {
                        players = players.substring(0, players.length() - 2);
                    }
                    Events.this.main.getMessageHandler().sendMessageWithPermission(Events.this.main.getMessageHandler().getMessage("security.join.manyclients.info").replace("%player%", ev.getPlayer().getName()).replace("%sameIPList%", players), "proxysuite.security.ipjoininfo");
                }
            }
        }, 500L, TimeUnit.MILLISECONDS);
    }

    @EventHandler
    public void onPlayerDisconnect(PlayerDisconnectEvent ev) {
        final ProxiedPlayer p = ev.getPlayer();
        UUID uuid = p.getUniqueId();
        if (this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.Home")) {
            this.main.getHomeHandler().removeHomesFromCache(p);
        }
        this.main.getPlayerHandler().registerLogout(p);
        this.main.getMessageHandler().broadcast(this.main.getMessageHandler().getMessage("leave.broadcast").replace("%player%", p.getName()).replace("%prefix%", this.main.getPlayerHandler().getPrefix(p)).replace("%suffix%", this.main.getPlayerHandler().getSuffix(p)));
        this.main.getPlayerHandler().getVanishedPlayers().remove(p);
        this.main.getPlayerHandler().getFlying().remove(p);
        this.main.getPlayerHandler().getGamemode().remove(p);
        String ip = ev.getPlayer().getPendingConnection().getAddress().getAddress().toString();
        if (this.main.getPlayerHandler().getIps().get(ip) == 1) {
            this.main.getPlayerHandler().getIps().remove(ip);
        } else {
            this.main.getPlayerHandler().getIps().put(ip, this.main.getPlayerHandler().getIps().get(ip) - 1);
        }
        this.main.getPermissionHandler().resetPermissions((CommandSender)ev.getPlayer());
        this.main.getProxy().getScheduler().schedule((Plugin)this.main, new Runnable(){

            public void run() {
                Events.this.main.getPlayerHandler().getPrefixes().remove(p);
                Events.this.main.getPlayerHandler().getSuffixes().remove(p);
                if (p.getServer() == null) {
                    Events.this.main.getMessageHandler().getLastMessages().remove(p);
                }
            }
        }, 60L, TimeUnit.SECONDS);
    }

    @EventHandler
    public void onChat(ChatEvent ev) {
        if (this.main.getConfig().getBoolean("ProxySuite.Logging.CommandOutputEnabled")) {
            if (ev.getMessage().startsWith("/") && ev.getSender() instanceof ProxiedPlayer) {
                this.main.getLogger().info((ProxiedPlayer)ev.getSender() + " issued command: " + ev.getMessage());
            } else if (ev.getSender() instanceof ProxiedPlayer) {
                this.main.getMessageHandler().logMessage((ProxiedPlayer)ev.getSender(), ev.getMessage());
            }
        }
    }

    @EventHandler(priority=64)
    public void onTabComplete(TabCompleteEvent ev) {
        if (ev.getSuggestions().isEmpty()) {
            String partialPlayerName = ev.getCursor().toLowerCase();
            int lastSpaceIndex = partialPlayerName.lastIndexOf(32);
            if (lastSpaceIndex >= 0) {
                partialPlayerName = partialPlayerName.substring(lastSpaceIndex + 1);
            }
            for (ProxiedPlayer p : this.main.getProxy().getPlayers()) {
                if (!p.getName().toLowerCase().startsWith(partialPlayerName)) continue;
                ev.getSuggestions().add(p.getName());
            }
        }
    }
}

