/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite;

import de.sabbertran.proxysuite.ProxySuite;
import de.sabbertran.proxysuite.utils.CheckedCommand;
import de.sabbertran.proxysuite.utils.Location;
import de.sabbertran.proxysuite.utils.Portal;
import de.sabbertran.proxysuite.utils.Warp;
import de.sabbertran.proxysuite.utils.WorldInfo;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class PMessageListener
implements Listener {
    private ProxySuite main;

    public PMessageListener(ProxySuite main) {
        this.main = main;
    }

    @EventHandler
    public void onPluginMessage(PluginMessageEvent ev) {
        block46: {
            if (ev.getTag().equals("ProxySuite")) {
                ByteArrayInputStream stream = new ByteArrayInputStream(ev.getData());
                DataInputStream in = new DataInputStream(stream);
                try {
                    ProxiedPlayer p;
                    String subchannel = in.readUTF();
                    if (subchannel.equals("Permissions")) {
                        String player = in.readUTF();
                        try {
                            String permission;
                            while ((permission = in.readUTF()) != null) {
                                if (!this.main.getPermissionHandler().getPermissions().containsKey(player)) {
                                    this.main.getPermissionHandler().getPermissions().put(player, new ArrayList());
                                }
                                this.main.getPermissionHandler().getPermissions().get(player).add(permission.toLowerCase());
                            }
                            break block46;
                        }
                        catch (EOFException eOFException) {
                            break block46;
                        }
                    }
                    if (subchannel.equals("Position")) {
                        ProxiedPlayer p2 = this.main.getProxy().getPlayer(in.readUTF());
                        if (p2 != null) {
                            ServerInfo server = this.main.getProxy().getServerInfo(in.readUTF());
                            String world = in.readUTF();
                            double x = Double.parseDouble(in.readUTF());
                            double y = Double.parseDouble(in.readUTF());
                            double z = Double.parseDouble(in.readUTF());
                            float pitch = Float.parseFloat(in.readUTF());
                            float yaw = Float.parseFloat(in.readUTF());
                            Location loc = new Location(server, world, x, y, z, pitch, yaw);
                            this.main.getPositionHandler().locationReceived(p2, loc);
                        }
                    } else if (subchannel.equals("PortalEnter")) {
                        if (this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.Portal")) {
                            Warp destination;
                            ProxiedPlayer p3 = this.main.getPlayerHandler().getPlayer(in.readUTF(), null, false);
                            Portal portal = this.main.getPortalHandler().getPortal(in.readUTF());
                            if (p3 != null && portal != null && (destination = this.main.getWarpHandler().getWarp(portal.getDestination(), true)) != null) {
                                this.main.getTeleportHandler().teleportToWarp(p3, destination, true);
                            }
                        }
                    } else if (subchannel.equals("SetPortalFailed")) {
                        String name = in.readUTF();
                        String player = in.readUTF();
                        ProxiedPlayer p4 = this.main.getPlayerHandler().getPlayer(player, null, false);
                        if (p4 != null) {
                            this.main.getMessageHandler().sendMessage((CommandSender)p4, this.main.getMessageHandler().getMessage("portal.creation.failed"));
                        }
                    } else if (subchannel.equals("SetPortalSuccess")) {
                        String player = in.readUTF();
                        String name = in.readUTF();
                        String server = in.readUTF();
                        String world = in.readUTF();
                        int x1 = Integer.parseInt(in.readUTF());
                        int y1 = Integer.parseInt(in.readUTF());
                        int z1 = Integer.parseInt(in.readUTF());
                        int x2 = Integer.parseInt(in.readUTF());
                        int y2 = Integer.parseInt(in.readUTF());
                        int z2 = Integer.parseInt(in.readUTF());
                        String type = in.readUTF();
                        String destination = in.readUTF();
                        Location loc1 = new Location(this.main.getProxy().getServerInfo(server), world, x1, y1, z1);
                        Location loc2 = new Location(this.main.getProxy().getServerInfo(server), world, x2, y2, z2);
                        Portal portal = new Portal(name, type, loc1, loc2, destination);
                        this.main.getPortalHandler().addPortalSuccess(portal);
                        ProxiedPlayer p5 = this.main.getPlayerHandler().getPlayer(player, null, false);
                        if (p5 != null) {
                            this.main.getMessageHandler().sendMessage((CommandSender)p5, this.main.getMessageHandler().getMessage("portal.creation.success").replace("%name%", name).replace("%destination%", destination));
                        }
                    } else if (subchannel.equals("GetPortals")) {
                        ServerInfo s = this.main.getServerInfo(ev.getSender());
                        if (s != null) {
                            this.main.getPortalHandler().sendPortalsToServer(s);
                        }
                    } else if (subchannel.equals("Prefix")) {
                        String player = in.readUTF();
                        String prefix = in.readUTF();
                        ProxiedPlayer p6 = this.main.getPlayerHandler().getPlayer(player, null, false);
                        if (p6 != null) {
                            this.main.getPlayerHandler().getPrefixes().put(p6, prefix);
                        }
                    } else if (subchannel.equals("Suffix")) {
                        String player = in.readUTF();
                        String suffix = in.readUTF();
                        ProxiedPlayer p7 = this.main.getPlayerHandler().getPlayer(player, null, false);
                        if (p7 != null) {
                            this.main.getPlayerHandler().getSuffixes().put(p7, suffix);
                        }
                    } else if (subchannel.equals("DeathWithBack")) {
                        ServerInfo s = this.main.getServerInfo(ev.getSender());
                        String player = in.readUTF();
                        ProxiedPlayer p8 = this.main.getPlayerHandler().getPlayer(player, null, false);
                        if (p8 != null) {
                            String world = in.readUTF();
                            double x = Double.parseDouble(in.readUTF());
                            double y = Double.parseDouble(in.readUTF());
                            double z = Double.parseDouble(in.readUTF());
                            float pitch = Float.parseFloat(in.readUTF());
                            float yaw = Float.parseFloat(in.readUTF());
                            Location loc = new Location(s, world, x, y, z, pitch, yaw);
                            this.main.getTeleportHandler().savePlayerLocation(p8, loc);
                        }
                    } else if (subchannel.equals("CanExecuteCommand")) {
                        String player = in.readUTF();
                        String command = in.readUTF();
                        boolean canExecute = Boolean.parseBoolean(in.readUTF());
                        ProxiedPlayer p9 = this.main.getProxy().getPlayer(player);
                        if (p9 != null) {
                            CheckedCommand cc = new CheckedCommand(p9, command, canExecute);
                            this.main.getCommandHandler().getCheckedCommands().add(cc);
                        }
                    } else if (subchannel.equals("WorldChange")) {
                        ProxiedPlayer p10 = this.main.getProxy().getPlayer(in.readUTF());
                        if (p10 != null) {
                            if (this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.Fly") && !this.main.getPermissionHandler().hasPermission((CommandSender)p10, "proxysuite.player.keepflyonworldchange") && this.main.getPlayerHandler().getFlying().contains(p10)) {
                                this.main.getPlayerHandler().sendUnflyToServer(p10);
                                this.main.getPlayerHandler().getFlying().remove(p10);
                                this.main.getPlayerHandler().writeFlyToDatabase(p10, false);
                                this.main.getMessageHandler().sendMessage((CommandSender)p10, this.main.getMessageHandler().getMessage("fly.disabled"));
                            }
                            if (this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.Gamemode") && !this.main.getPermissionHandler().hasPermission((CommandSender)p10, "proxysuite.player.keepgamemodeonworldchange")) {
                                this.main.getPlayerHandler().setGamemode(p10, "SURVIVAL");
                            }
                            this.main.getPermissionHandler().resetPermissions((CommandSender)p10);
                            this.main.getPermissionHandler().updatePermissions(p10);
                        }
                    } else if (subchannel.equals("ExecuteCommand")) {
                        CommandSender sender;
                        String player = in.readUTF();
                        Object object = sender = player.equalsIgnoreCase("CONSOLE") ? this.main.getProxy().getConsole() : this.main.getProxy().getPlayer(player);
                        if (sender != null) {
                            String cmd = in.readUTF();
                            if (cmd.startsWith("/")) {
                                cmd = cmd.substring(1);
                            }
                            this.main.getProxy().getPluginManager().dispatchCommand(sender, cmd);
                        }
                    } else if (subchannel.equals("PlayerWorldInfo") && (p = this.main.getProxy().getPlayer(in.readUTF())) != null) {
                        WorldInfo worldInfo = new WorldInfo(in.readUTF(), Long.parseLong(in.readUTF()));
                        this.main.getPlayerHandler().getWorldInfos().put(p, worldInfo);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

