/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite;

import com.google.common.io.ByteStreams;
import de.sabbertran.proxysuite.Events;
import de.sabbertran.proxysuite.PMessageListener;
import de.sabbertran.proxysuite.handlers.AnnouncementHandler;
import de.sabbertran.proxysuite.handlers.BanHandler;
import de.sabbertran.proxysuite.handlers.CommandHandler;
import de.sabbertran.proxysuite.handlers.CustomCommandHandler;
import de.sabbertran.proxysuite.handlers.HomeHandler;
import de.sabbertran.proxysuite.handlers.MessageHandler;
import de.sabbertran.proxysuite.handlers.NoteHandler;
import de.sabbertran.proxysuite.handlers.PermissionHandler;
import de.sabbertran.proxysuite.handlers.PlayerHandler;
import de.sabbertran.proxysuite.handlers.PortalHandler;
import de.sabbertran.proxysuite.handlers.PositionHandler;
import de.sabbertran.proxysuite.handlers.SpawnHandler;
import de.sabbertran.proxysuite.handlers.TeleportHandler;
import de.sabbertran.proxysuite.handlers.WarningHandler;
import de.sabbertran.proxysuite.handlers.WarpHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.List;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class ProxySuite
extends Plugin {
    private static ProxySuite instance;
    private Configuration config;
    private List<String> sql;
    private java.sql.Connection sql_connection;
    private String tablePrefix;
    private SimpleDateFormat dateFormat;
    private boolean bungeeTabListPlusInstalled;
    private TeleportHandler teleportHandler;
    private PermissionHandler permissionHandler;
    private WarpHandler warpHandler;
    private PositionHandler positionHandler;
    private SpawnHandler spawnHandler;
    private PlayerHandler playerHandler;
    private HomeHandler homeHandler;
    private BanHandler banHandler;
    private WarningHandler warningHandler;
    private MessageHandler messageHandler;
    private NoteHandler noteHandler;
    private PortalHandler portalHandler;
    private AnnouncementHandler announcementHandler;
    private CustomCommandHandler customCommandHandler;
    private CommandHandler commandHandler;

    public ProxySuite() {
        instance = this;
    }

    public void onEnable() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        File configFile = new File(this.getDataFolder(), "config.yml");
        File messagesFile = new File(this.getDataFolder(), "messages.yml");
        File announcementsFile = new File(this.getDataFolder(), "announcements.yml");
        try {
            FileOutputStream os;
            InputStream is;
            if (!configFile.exists()) {
                configFile.createNewFile();
                is = this.getResourceAsStream("config.yml");
                os = new FileOutputStream(configFile);
                ByteStreams.copy((InputStream)is, (OutputStream)os);
            }
            if (!messagesFile.exists()) {
                messagesFile.createNewFile();
                is = this.getResourceAsStream("messages.yml");
                os = new FileOutputStream(messagesFile);
                ByteStreams.copy((InputStream)is, (OutputStream)os);
            }
            if (!announcementsFile.exists()) {
                announcementsFile.createNewFile();
                is = this.getResourceAsStream("announcements.yml");
                os = new FileOutputStream(announcementsFile);
                ByteStreams.copy((InputStream)is, (OutputStream)os);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create file", e);
        }
        try {
            this.config = ConfigurationProvider.getProvider(YamlConfiguration.class).load((Reader)new InputStreamReader((InputStream)new FileInputStream(configFile), "UTF8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.sql = this.config.getStringList("ProxySuite.SQL");
        this.tablePrefix = this.config.getString("ProxySuite.TablePrefix");
        this.dateFormat = new SimpleDateFormat(this.config.getString("ProxySuite.Messages.TimeFormat"));
        this.messageHandler = new MessageHandler(this);
        this.teleportHandler = new TeleportHandler(this);
        this.permissionHandler = new PermissionHandler(this);
        this.warpHandler = new WarpHandler(this);
        this.positionHandler = new PositionHandler(this);
        this.spawnHandler = new SpawnHandler(this);
        this.playerHandler = new PlayerHandler(this);
        this.homeHandler = new HomeHandler(this);
        this.banHandler = new BanHandler(this);
        this.warningHandler = new WarningHandler(this);
        this.noteHandler = new NoteHandler(this);
        this.portalHandler = new PortalHandler(this);
        this.announcementHandler = new AnnouncementHandler(this);
        this.commandHandler = new CommandHandler(this);
        this.customCommandHandler = new CustomCommandHandler(this);
        this.messageHandler.readMessagesFromFile();
        this.permissionHandler.readAvailablePermissionsFromFile();
        this.announcementHandler.readAnnouncementsFromFile();
        this.announcementHandler.startScheduler();
        this.commandHandler.registerCommands();
        this.customCommandHandler.registerCustomCommandsFromFile();
        this.setupDatabase();
        this.readDatabase();
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new Events(this));
        this.getProxy().registerChannel("ProxySuite");
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new PMessageListener(this));
        for (ServerInfo s : this.getProxy().getServers().values()) {
            this.portalHandler.sendPortalsToServer(s);
        }
        this.bungeeTabListPlusInstalled = this.getProxy().getPluginManager().getPlugin("BungeeTabListPlus") != null;
        this.getLogger().info(this.getDescription().getName() + " " + this.getDescription().getVersion() + " by " + this.getDescription().getAuthor() + " enabled");
    }

    public void onDisable() {
        this.getProxy().getScheduler().cancel((Plugin)this);
        this.getLogger().info(this.getDescription().getName() + " " + this.getDescription().getVersion() + " by " + this.getDescription().getAuthor() + " disabled");
    }

    public void readDatabase() {
        this.warpHandler.readWarpsFromDatabase();
        this.portalHandler.readPortalsFromDatabase();
        this.spawnHandler.readSpawnsFromDatabase();
    }

    private void setupDatabase() {
        if (this.sql != null && this.sql.size() == 5 && !this.sql.get(4).equals("Password")) {
            try {
                this.getSQLConnection().createStatement().execute("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "players` (`id` INT " + "NOT NULL" + " AUTO_INCREMENT, `uuid` VARCHAR(255) NOT NULL, `name` VARCHAR(255) NOT NULL, `vanished` " + "BOOLEAN NOT NULL DEFAULT FALSE, `flying` BOOLEAN NOT NULL DEFAULT FALSE, `gamemode` VARCHAR" + "(256) NOT NULL DEFAULT 'SURVIVAL', `online` BOOLEAN NOT NULL, `first_join` TIMESTAMP NOT " + "NULL DEFAULT CURRENT_TIMESTAMP , `last_seen` TIMESTAMP NULL DEFAULT NULL, PRIMARY KEY (`id`), UNIQUE(`uuid`)" + ")");
                this.getSQLConnection().createStatement().execute("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "portals` (`id` INT NOT NULL" + " AUTO_INCREMENT, `name` VARCHAR(255) NOT NULL, `type` VARCHAR(255) NOT NULL, `server` " + "VARCHAR(255) NOT NULL, `world` VARCHAR(255) NOT NULL, `loc1_x` DOUBLE NOT NULL, `loc1_y` " + "DOUBLE NOT NULL, `loc1_z` DOUBLE NOT NULL, `loc1_pitch` DOUBLE NOT NULL, `loc1_yaw` DOUBLE " + "NOT NULL, `loc2_x` DOUBLE NOT NULL, `loc2_y` DOUBLE NOT NULL, `loc2_z` DOUBLE NOT NULL, " + "`loc2_pitch` DOUBLE NOT NULL, `loc2_yaw` DOUBLE NOT NULL, `destination` VARCHAR(255) NOT " + "NULL, PRIMARY KEY (`id`))");
                this.getSQLConnection().createStatement().execute("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "warps` (`id` INT NOT NULL " + "AUTO_INCREMENT, `name` VARCHAR(255) NOT NULL, `hidden` BOOLEAN NOT NULL, `server` VARCHAR" + "(256) NOT NULL, `world` VARCHAR(255) NOT NULL, `x` DOUBLE NOT NULL, `y` DOUBLE NOT NULL, `z`" + " DOUBLE NOT NULL, `pitch` FLOAT NOT NULL, `yaw` FLOAT NOT NULL, PRIMARY KEY (`id`))");
                this.getSQLConnection().createStatement().execute("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "homes` (`id` INT NOT NULL " + "AUTO_INCREMENT, `player` VARCHAR(255) NOT NULL, `name` VARCHAR(255) NOT NULL, `server` " + "VARCHAR(255) NOT NULL, `world` VARCHAR(255) NOT NULL, `x` DOUBLE NOT NULL, `y` DOUBLE NOT NULL, " + "`z` DOUBLE NOT NULL, `pitch` FLOAT NOT NULL, `yaw` FLOAT NOT NULL, PRIMARY KEY (`id`))");
                this.getSQLConnection().createStatement().execute("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "warnings` (`id` INT NOT " + "NULL AUTO_INCREMENT, `deleted` BOOLEAN NOT NULL DEFAULT FALSE, `player` VARCHAR(255) NOT " + "NULL, `player_read` BOOLEAN NOT NULL DEFAULT FALSE, `reason` TEXT NOT NULL, `author` VARCHAR(255) " + "NOT NULL, `date` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, `archived` BOOLEAN NOT NULL " + "DEFAULT FALSE, `server` VARCHAR(255) NOT NULL, `world` VARCHAR(255) NOT NULL, `x` DOUBLE NOT" + " NULL, `y` DOUBLE NOT NULL, `z` DOUBLE NOT NULL, `pitch` FLOAT NOT NULL, `yaw` FLOAT NOT " + "NULL, `lastMessages` VARCHAR(255) NOT NULL DEFAULT '', PRIMARY KEY (`id`))");
                this.getSQLConnection().createStatement().execute("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "bans` (`id` INT NOT NULL " + "AUTO_INCREMENT, `player` VARCHAR(255) NOT NULL, `reason` TEXT NOT NULL, `author` VARCHAR" + "(256) NOT NULL, `expiration` TIMESTAMP NULL DEFAULT NULL, `created` TIMESTAMP NOT NULL DEFAULT " + "CURRENT_TIMESTAMP, `lastMessages` VARCHAR(255) NOT NULL DEFAULT '', PRIMARY KEY (`id`))");
                this.getSQLConnection().createStatement().execute("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "spawns` (`id` INT NOT NULL " + "AUTO_INCREMENT, `type` VARCHAR(255) NOT NULL, `server` VARCHAR(255) NOT NULL, `world` " + "VARCHAR(255) NOT NULL, `x` DOUBLE NOT NULL, `y` DOUBLE NOT NULL, `z` DOUBLE NOT NULL, " + "`pitch` FLOAT NOT NULL, `yaw` FLOAT NOT NULL, PRIMARY KEY (`id`))");
                this.getSQLConnection().createStatement().execute("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "notes` (`id` INT NOT NULL AUTO_INCREMENT," + " `player` VARCHAR(255) NOT NULL, `note` TEXT NOT NULL, `deleted` BOOLEAN NOT NULL DEFAULT " + "FALSE, `author` VARCHAR(255) NOT NULL, `server` VARCHAR(255) NOT NULL, `world` VARCHAR(255) " + "NOT NULL, `x` DOUBLE NOT NULL, `y` DOUBLE NOT NULL, `z` DOUBLE NOT NULL, `pitch` FLOAT NOT " + "NULL, `yaw` FLOAT NOT NULL, `date` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, `lastMessages` VARCHAR(255) NOT NULL DEFAULT '', " + "PRIMARY KEY (`id`))");
                this.getSQLConnection().createStatement().execute("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "lastMessages` (`id` INT NOT" + " NULL AUTO_INCREMENT, `player` VARCHAR(255) NOT NULL, `message` TEXT NOT NULL, `date` " + "TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (`id`))");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            this.getLogger().info("Error while setting up the SQL Connection! Please check you SQL data!");
        }
    }

    public ServerInfo getServerInfo(Connection sender) {
        for (ServerInfo s : this.getProxy().getServers().values()) {
            if (!s.getAddress().equals(sender.getAddress())) continue;
            return s;
        }
        return null;
    }

    public java.sql.Connection getSQLConnection() {
        try {
            if (this.sql_connection == null || this.sql_connection.isClosed()) {
                Class.forName("com.mysql.jdbc.Driver");
                String url = "jdbc:mysql://" + this.sql.get(0) + ":" + this.sql.get(1) + "/" + this.sql.get(2);
                this.sql_connection = DriverManager.getConnection(url, this.sql.get(3), this.sql.get(4));
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.sql_connection;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public TeleportHandler getTeleportHandler() {
        return this.teleportHandler;
    }

    public PermissionHandler getPermissionHandler() {
        return this.permissionHandler;
    }

    public WarpHandler getWarpHandler() {
        return this.warpHandler;
    }

    public PositionHandler getPositionHandler() {
        return this.positionHandler;
    }

    public SpawnHandler getSpawnHandler() {
        return this.spawnHandler;
    }

    public PlayerHandler getPlayerHandler() {
        return this.playerHandler;
    }

    public HomeHandler getHomeHandler() {
        return this.homeHandler;
    }

    public BanHandler getBanHandler() {
        return this.banHandler;
    }

    public WarningHandler getWarningHandler() {
        return this.warningHandler;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public NoteHandler getNoteHandler() {
        return this.noteHandler;
    }

    public PortalHandler getPortalHandler() {
        return this.portalHandler;
    }

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public CustomCommandHandler getCustomCommandHandler() {
        return this.customCommandHandler;
    }

    public AnnouncementHandler getAnnouncementHandler() {
        return this.announcementHandler;
    }

    public boolean isBungeeTabListPlusInstalled() {
        return this.bungeeTabListPlusInstalled;
    }

    public static ProxySuite getInstance() {
        return instance;
    }
}

