/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.md_5.bungee.api.connection.ProxiedPlayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxySuiteUtils {
    public static int levenshteinDistance(CharSequence lhs, CharSequence rhs) {
        int len0 = lhs.length() + 1;
        int len1 = rhs.length() + 1;
        int[] cost = new int[len0];
        int[] newcost = new int[len0];
        for (int i = 0; i < len0; ++i) {
            cost[i] = i;
        }
        for (int j = 1; j < len1; ++j) {
            newcost[0] = j;
            for (int i = 1; i < len0; ++i) {
                int match = lhs.charAt(i - 1) == rhs.charAt(j - 1) ? 0 : 1;
                int cost_replace = cost[i - 1] + match;
                int cost_insert = cost[i] + 1;
                int cost_delete = newcost[i - 1] + 1;
                newcost[i] = Math.min(Math.min(cost_insert, cost_delete), cost_replace);
            }
            int[] swap = cost;
            cost = newcost;
            newcost = swap;
        }
        return cost[len0 - 1];
    }

    public static void sortMapAsc(HashMap<ProxiedPlayer, Integer> unsortMap) {
        LinkedList<Map.Entry<Object, Integer>> list = new LinkedList<Map.Entry<Object, Integer>>(unsortMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<ProxiedPlayer, Integer>>(){

            @Override
            public int compare(Map.Entry<ProxiedPlayer, Integer> o1, Map.Entry<ProxiedPlayer, Integer> o2) {
                if (o1.getValue() > o2.getValue()) {
                    return 1;
                }
                if (o1.getValue() < o2.getValue()) {
                    return -1;
                }
                return o1.getKey().getName().compareTo(o2.getKey().getName());
            }
        });
        HashMap sortedMap = new HashMap();
        for (Map.Entry entry : list) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        unsortMap = sortedMap;
    }

    public static int getOccurrenceOf(String haystack, char needle) {
        int ret = 0;
        for (char c : haystack.toCharArray()) {
            if (c != needle) continue;
            ++ret;
        }
        return ret;
    }
}

