/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite.commands;

import de.sabbertran.proxysuite.ProxySuite;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomCommand
extends Command {
    private ProxySuite main;
    private String command;
    private String permission;
    private String[] messages;
    private ArrayList<String> disabledServers;

    public CustomCommand(ProxySuite main, String command, String permission, String[] messages, ArrayList<String> disabledServers) {
        super(command.trim());
        this.command = command.trim();
        this.main = main;
        this.permission = permission;
        this.messages = messages;
        this.disabledServers = disabledServers;
    }

    public void execute(final CommandSender sender, final String[] args) {
        this.main.getCommandHandler().executeCommand(sender, this.command, new Runnable(){

            public void run() {
                if (sender instanceof ProxiedPlayer) {
                    final ProxiedPlayer p = (ProxiedPlayer)sender;
                    if (CustomCommand.this.permission.trim().equals("") || CustomCommand.this.main.getPermissionHandler().hasPermission(sender, CustomCommand.this.permission)) {
                        if (!CustomCommand.this.disabledServers.contains(p.getServer().getInfo().getName())) {
                            for (final String s : CustomCommand.this.messages) {
                                final int delay = s.matches("^%delay:[0-9]+%.*$") ? Integer.parseInt(s.split("%")[1].substring(6)) : 0;
                                Runnable runnable = new Runnable(){

                                    public void run() {
                                        String s2 = s.replace("%delay:" + delay + "%", "");
                                        if (s2.trim().startsWith("/") || s2.trim().startsWith("\\")) {
                                            s2 = s2.trim();
                                            for (int i = 0; i < args.length; ++i) {
                                                s2 = s2.replace("$" + (i + 1), args[i]);
                                            }
                                            if (s2.startsWith("/")) {
                                                p.chat(s2);
                                            } else if (s2.startsWith("\\\\")) {
                                                CustomCommand.this.main.getProxy().getPluginManager().dispatchCommand(CustomCommand.this.main.getProxy().getConsole(), s2.substring(2).replace("%player%", sender.getName()));
                                            } else {
                                                CustomCommand.this.main.getProxy().getPluginManager().dispatchCommand(sender, s2.substring(1));
                                            }
                                        } else {
                                            CustomCommand.this.main.getMessageHandler().sendMessage((CommandSender)p, CustomCommand.this.main.getCustomCommandHandler().translateVariables(s2, p));
                                        }
                                    }
                                };
                                if (delay > 0) {
                                    CustomCommand.this.main.getProxy().getScheduler().schedule((Plugin)CustomCommand.this.main, runnable, (long)delay, TimeUnit.MILLISECONDS);
                                    continue;
                                }
                                runnable.run();
                            }
                        } else {
                            String cmd = "/" + CustomCommand.this.command;
                            for (String s : args) {
                                cmd = cmd + " " + args;
                            }
                            cmd = cmd.trim();
                            p.chat(cmd);
                        }
                    } else {
                        CustomCommand.this.main.getPermissionHandler().sendMissingPermissionInfo(sender);
                    }
                } else {
                    CustomCommand.this.main.getMessageHandler().sendMessage(sender, CustomCommand.this.main.getMessageHandler().getMessage("command.noplayer"));
                }
            }
        });
    }
}

