/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite.commands.home;

import de.sabbertran.proxysuite.ProxySuite;
import de.sabbertran.proxysuite.utils.Home;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;

public class HomeCommand
extends Command {
    private ProxySuite main;
    private HomeCommand self;

    public HomeCommand(ProxySuite main) {
        super("home");
        this.main = main;
        this.self = this;
    }

    public void execute(final CommandSender sender, final String[] args) {
        this.main.getCommandHandler().executeCommand(sender, "home", new Runnable(){

            public void run() {
                if (sender instanceof ProxiedPlayer) {
                    final ProxiedPlayer p = (ProxiedPlayer)sender;
                    if (args.length == 0) {
                        if (HomeCommand.this.main.getPermissionHandler().hasPermission(sender, "proxysuite.commands.home")) {
                            Home h = HomeCommand.this.main.getHomeHandler().getHome(p.getName(), "home");
                            if (h != null) {
                                int remainingCooldown = HomeCommand.this.main.getTeleportHandler().getRemainingCooldown(p);
                                boolean ignoreCooldown = HomeCommand.this.main.getTeleportHandler().canIgnoreCooldown(sender);
                                if (remainingCooldown == 0 || ignoreCooldown) {
                                    HomeCommand.this.main.getTeleportHandler().teleportToHome(p, h, ignoreCooldown);
                                } else {
                                    HomeCommand.this.main.getMessageHandler().sendMessage(sender, HomeCommand.this.main.getMessageHandler().getMessage("teleport.cooldown").replace("%cooldown%", "" + remainingCooldown));
                                }
                            } else {
                                HomeCommand.this.main.getMessageHandler().sendMessage(sender, HomeCommand.this.main.getMessageHandler().getMessage("home.notset.default"));
                            }
                        } else {
                            HomeCommand.this.main.getPermissionHandler().sendMissingPermissionInfo(sender);
                        }
                    } else if (args.length == 1) {
                        if (HomeCommand.this.main.getPermissionHandler().hasPermission(sender, "proxysuite.commands.home")) {
                            Home h = HomeCommand.this.main.getHomeHandler().getHome(p.getName(), args[0]);
                            if (h != null) {
                                int remainingCooldown = HomeCommand.this.main.getTeleportHandler().getRemainingCooldown(p);
                                boolean ignoreCooldown = HomeCommand.this.main.getTeleportHandler().canIgnoreCooldown(sender);
                                if (remainingCooldown == 0 || ignoreCooldown) {
                                    HomeCommand.this.main.getTeleportHandler().teleportToHome(p, h, ignoreCooldown);
                                } else {
                                    HomeCommand.this.main.getMessageHandler().sendMessage(sender, HomeCommand.this.main.getMessageHandler().getMessage("teleport.cooldown").replace("%cooldown%", "" + remainingCooldown));
                                }
                            } else {
                                HomeCommand.this.main.getMessageHandler().sendMessage(sender, HomeCommand.this.main.getMessageHandler().getMessage("home.notset").replace("%home%", args[0]));
                            }
                        } else {
                            HomeCommand.this.main.getPermissionHandler().sendMissingPermissionInfo(sender);
                        }
                    } else if (args.length == 2) {
                        if (HomeCommand.this.main.getPermissionHandler().hasPermission(sender, "proxysuite.commands.home.others")) {
                            final String player = args[0];
                            final String home = args[1];
                            HomeCommand.this.main.getProxy().getScheduler().runAsync((Plugin)HomeCommand.this.main, new Runnable(){

                                public void run() {
                                    Home h = HomeCommand.this.main.getHomeHandler().getHome(player, home);
                                    if (h != null) {
                                        int remainingCooldown = HomeCommand.this.main.getTeleportHandler().getRemainingCooldown(p);
                                        boolean ignoreCooldown = HomeCommand.this.main.getTeleportHandler().canIgnoreCooldown(sender);
                                        if (remainingCooldown == 0 || ignoreCooldown) {
                                            HomeCommand.this.main.getTeleportHandler().teleportToHome(p, h, ignoreCooldown);
                                        } else {
                                            HomeCommand.this.main.getMessageHandler().sendMessage(sender, HomeCommand.this.main.getMessageHandler().getMessage("teleport.cooldown").replace("%cooldown%", "" + remainingCooldown));
                                        }
                                    } else {
                                        HomeCommand.this.main.getMessageHandler().sendMessage(sender, HomeCommand.this.main.getMessageHandler().getMessage("home.notset.others").replace("%home%", home).replace("%player%", player));
                                    }
                                }
                            });
                        } else {
                            HomeCommand.this.main.getPermissionHandler().sendMissingPermissionInfo(sender);
                        }
                    } else {
                        HomeCommand.this.main.getCommandHandler().sendUsage(sender, HomeCommand.this.self);
                    }
                } else {
                    HomeCommand.this.main.getMessageHandler().sendMessage(sender, HomeCommand.this.main.getMessageHandler().getMessage("command.noplayer"));
                }
            }
        });
    }
}

