/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite.commands.portal;

import de.sabbertran.proxysuite.ProxySuite;
import de.sabbertran.proxysuite.utils.Portal;
import de.sabbertran.proxysuite.utils.Warp;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;

public class PortalCommand
extends Command {
    private ProxySuite main;
    private PortalCommand self;

    public PortalCommand(ProxySuite main) {
        super("portal");
        this.main = main;
        this.self = this;
    }

    public void execute(final CommandSender sender, final String[] args) {
        this.main.getCommandHandler().executeCommand(sender, "portal", new Runnable(){

            public void run() {
                if (PortalCommand.this.main.getPermissionHandler().hasPermission(sender, "proxysuite.commands.portal")) {
                    if (args.length == 1) {
                        if (sender instanceof ProxiedPlayer) {
                            ProxiedPlayer p = (ProxiedPlayer)sender;
                            Portal portal = PortalCommand.this.main.getPortalHandler().getPortal(args[0]);
                            if (portal != null) {
                                Warp destination = PortalCommand.this.main.getWarpHandler().getWarp(portal.getDestination(), true);
                                if (destination != null) {
                                    PortalCommand.this.main.getTeleportHandler().teleportToWarp(p, destination, true);
                                } else {
                                    PortalCommand.this.main.getMessageHandler().sendMessage((CommandSender)p, PortalCommand.this.main.getMessageHandler().getMessage("portal.destination.notexists").replace("%destination%", portal.getDestination()));
                                }
                            } else {
                                PortalCommand.this.main.getMessageHandler().sendMessage(sender, PortalCommand.this.main.getMessageHandler().getMessage("portal.notexists").replace("%portal%", args[0]));
                            }
                        } else {
                            PortalCommand.this.main.getMessageHandler().sendMessage(sender, PortalCommand.this.main.getMessageHandler().getMessage("command.noplayer"));
                        }
                    } else {
                        PortalCommand.this.main.getCommandHandler().sendUsage(sender, PortalCommand.this.self);
                    }
                } else {
                    PortalCommand.this.main.getPermissionHandler().sendMissingPermissionInfo(sender);
                }
            }
        });
    }
}

