/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite.commands.spawn;

import de.sabbertran.proxysuite.ProxySuite;
import de.sabbertran.proxysuite.utils.Location;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;

public class SpawnCommand
extends Command {
    private ProxySuite main;

    public SpawnCommand(ProxySuite main) {
        super("spawn");
        this.main = main;
    }

    public void execute(final CommandSender sender, String[] args) {
        this.main.getCommandHandler().executeCommand(sender, "spawn", new Runnable(){

            public void run() {
                if (SpawnCommand.this.main.getPermissionHandler().hasPermission(sender, "proxysuite.commands.spawn")) {
                    if (sender instanceof ProxiedPlayer) {
                        ProxiedPlayer p = (ProxiedPlayer)sender;
                        Location normalSpawn = SpawnCommand.this.main.getSpawnHandler().getNormalSpawn();
                        if (normalSpawn != null) {
                            int remainingCooldown = SpawnCommand.this.main.getTeleportHandler().getRemainingCooldown(p);
                            boolean ignoreCooldown = SpawnCommand.this.main.getTeleportHandler().canIgnoreCooldown(sender);
                            if (remainingCooldown == 0 || ignoreCooldown) {
                                SpawnCommand.this.main.getTeleportHandler().teleportToLocation(p, normalSpawn, ignoreCooldown, false);
                            } else {
                                SpawnCommand.this.main.getMessageHandler().sendMessage(sender, SpawnCommand.this.main.getMessageHandler().getMessage("teleport.cooldown").replace("%cooldown%", "" + remainingCooldown));
                            }
                        } else {
                            SpawnCommand.this.main.getMessageHandler().sendMessage(sender, SpawnCommand.this.main.getMessageHandler().getMessage("spawn.notset"));
                        }
                    } else {
                        SpawnCommand.this.main.getMessageHandler().sendMessage(sender, SpawnCommand.this.main.getMessageHandler().getMessage("command.noplayer"));
                    }
                } else {
                    SpawnCommand.this.main.getPermissionHandler().sendMissingPermissionInfo(sender);
                }
            }
        });
    }
}

