/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite.commands.warp;

import de.sabbertran.proxysuite.ProxySuite;
import de.sabbertran.proxysuite.utils.Warp;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;

public class WarpCommand
extends Command {
    private ProxySuite main;
    private WarpCommand self;

    public WarpCommand(ProxySuite main) {
        super("warp");
        this.main = main;
        this.self = this;
    }

    public void execute(final CommandSender sender, final String[] args) {
        this.main.getCommandHandler().executeCommand(sender, "warp", new Runnable(){

            public void run() {
                if (WarpCommand.this.main.getPermissionHandler().hasPermission(sender, "proxysuite.commands.warp")) {
                    if (args.length == 1) {
                        if (sender instanceof ProxiedPlayer) {
                            ProxiedPlayer p = (ProxiedPlayer)sender;
                            boolean includeHidden = WarpCommand.this.main.getPermissionHandler().hasPermission(sender, "proxysuite.warps.showhidden");
                            Warp w = WarpCommand.this.main.getWarpHandler().getWarp(args[0], includeHidden);
                            if (w != null) {
                                int remainingCooldown = WarpCommand.this.main.getTeleportHandler().getRemainingCooldown(p);
                                boolean ignoreCooldown = WarpCommand.this.main.getTeleportHandler().canIgnoreCooldown(sender);
                                if (remainingCooldown == 0 || ignoreCooldown) {
                                    WarpCommand.this.main.getTeleportHandler().teleportToWarp(p, w, ignoreCooldown);
                                } else {
                                    WarpCommand.this.main.getMessageHandler().sendMessage(sender, WarpCommand.this.main.getMessageHandler().getMessage("teleport.cooldown").replace("%cooldown%", "" + remainingCooldown));
                                }
                            } else {
                                WarpCommand.this.main.getMessageHandler().sendMessage(sender, WarpCommand.this.main.getMessageHandler().getMessage("warp.notexists").replace("%warp%", args[0]));
                            }
                        } else {
                            WarpCommand.this.main.getMessageHandler().sendMessage(sender, WarpCommand.this.main.getMessageHandler().getMessage("command.noplayer"));
                        }
                    } else if (args.length == 2) {
                        if (WarpCommand.this.main.getPermissionHandler().hasPermission(sender, "proxysuite.commands.warp.others")) {
                            String player = args[0];
                            ProxiedPlayer p = WarpCommand.this.main.getPlayerHandler().getPlayer(player, sender, true);
                            if (p != null) {
                                boolean includeHidden = WarpCommand.this.main.getPermissionHandler().hasPermission(sender, "proxysuite.warps.showhidden");
                                Warp w = WarpCommand.this.main.getWarpHandler().getWarp(args[1], includeHidden);
                                if (w != null) {
                                    boolean ignoreCooldown;
                                    int remainingCooldown = WarpCommand.this.main.getTeleportHandler().getRemainingCooldown(p);
                                    boolean bl = ignoreCooldown = WarpCommand.this.main.getTeleportHandler().canIgnoreCooldown((CommandSender)p) || WarpCommand.this.main.getTeleportHandler().canIgnoreCooldown(sender);
                                    if (remainingCooldown == 0 || ignoreCooldown) {
                                        WarpCommand.this.main.getTeleportHandler().teleportToWarp(p, w, ignoreCooldown);
                                    } else {
                                        WarpCommand.this.main.getMessageHandler().sendMessage(sender, WarpCommand.this.main.getMessageHandler().getMessage("teleport.cooldown.others").replace("%player%", p.getName()).replace("%cooldown%", "" + remainingCooldown));
                                    }
                                } else {
                                    WarpCommand.this.main.getMessageHandler().sendMessage(sender, WarpCommand.this.main.getMessageHandler().getMessage("warp.notexists").replace("%warp%", args[0]));
                                }
                            } else {
                                WarpCommand.this.main.getMessageHandler().sendMessage(sender, WarpCommand.this.main.getMessageHandler().getMessage("command.player.notonline").replace("%player%", args[0]));
                            }
                        } else {
                            WarpCommand.this.main.getPermissionHandler().sendMissingPermissionInfo(sender);
                        }
                    } else {
                        WarpCommand.this.main.getCommandHandler().sendUsage(sender, WarpCommand.this.self);
                    }
                } else {
                    WarpCommand.this.main.getPermissionHandler().sendMissingPermissionInfo(sender);
                }
            }
        });
    }
}

