/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite.handlers;

import de.sabbertran.proxysuite.ProxySuite;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;

public class AnnouncementHandler {
    private ProxySuite main;
    private ArrayList<String> announcements;
    private int currentAnnouncement;
    private ScheduledTask task;

    public AnnouncementHandler(ProxySuite main) {
        this.main = main;
        this.announcements = new ArrayList();
        this.currentAnnouncement = -1;
    }

    public void readAnnouncementsFromFile() {
        this.announcements = new ArrayList();
        File f = new File(this.main.getDataFolder(), "announcements.yml");
        try {
            String line;
            BufferedReader read = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF8"));
            while ((line = read.readLine()) != null) {
                if ((line = line.trim()).equals("''")) {
                    this.announcements.add("");
                    continue;
                }
                if (line.equals("") || line.startsWith("#")) continue;
                this.announcements.add(line);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.currentAnnouncement = 0;
    }

    public void startScheduler() {
        int interval = this.main.getConfig().getInt("ProxySuite.Announcements.Interval");
        this.task = this.main.getProxy().getScheduler().schedule((Plugin)this.main, new Runnable(){

            public void run() {
                AnnouncementHandler.this.broadcastMessage();
            }
        }, (long)interval, (long)interval, TimeUnit.SECONDS);
    }

    private void broadcastMessage() {
        if (!this.announcements.isEmpty() && this.main.getProxy().getPlayers().size() > 0) {
            String message;
            if (!this.main.getConfig().getBoolean("ProxySuite.Announcements.Random")) {
                message = this.announcements.get(this.currentAnnouncement);
                ++this.currentAnnouncement;
                if (this.currentAnnouncement == this.announcements.size()) {
                    this.currentAnnouncement = 0;
                }
            } else {
                Random r = new Random();
                message = this.announcements.get(r.nextInt(this.announcements.size()));
            }
            if (!message.trim().equals("")) {
                message = message.startsWith("{") && message.endsWith("}") ? "[" + this.main.getConfig().getString("ProxySuite.Announcements.PrefixJson") + "," + message + "]" : this.main.getConfig().getString("ProxySuite.Announcements.Prefix") + message;
                this.main.getMessageHandler().broadcast(message);
            }
        }
    }
}

