/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite.handlers;

import de.sabbertran.proxysuite.ProxySuite;
import de.sabbertran.proxysuite.utils.LoggedMessage;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;

public class BanHandler {
    private ProxySuite main;

    public BanHandler(ProxySuite main) {
        this.main = main;
    }

    public void kickPlayer(ProxiedPlayer p, CommandSender sender, boolean hideMessage) {
        p.disconnect((BaseComponent)this.main.getMessageHandler().translateColorCodes(this.main.getMessageHandler().getMessage("kick.defaultreason")));
        if (!hideMessage) {
            this.main.getMessageHandler().sendMessageWithPermission(this.main.getMessageHandler().getMessage("kick.info.default").replace("%player%", p.getName()).replace("%author%", sender.getName()), "proxysuite.messages.kickinfo");
        }
    }

    public void kickPlayer(ProxiedPlayer p, String reason, CommandSender sender, boolean hideMessage) {
        p.disconnect((BaseComponent)this.main.getMessageHandler().translateColorCodes(reason));
        if (!hideMessage) {
            this.main.getMessageHandler().sendMessageWithPermission(this.main.getMessageHandler().getMessage("kick.info").replace("%player%", p.getName()).replace("%author%", sender.getName()).replace("%reason%", reason), "proxysuite.messages.kickinfo");
        }
    }

    public void banPlayer(final String player, String reason, final CommandSender sender) {
        if (reason == null || reason.equals("")) {
            reason = this.main.getMessageHandler().getMessage("ban.defaultreason");
        }
        final String reason2 = reason;
        this.main.getProxy().getScheduler().runAsync((Plugin)this.main, new Runnable(){

            public void run() {
                try {
                    ProxiedPlayer p = BanHandler.this.main.getPlayerHandler().getPlayer(player, sender, false);
                    String lastMessages = "";
                    if (p != null && BanHandler.this.main.getMessageHandler().getLastMessages().containsKey(p)) {
                        for (LoggedMessage m : BanHandler.this.main.getMessageHandler().getLastMessages().get(p)) {
                            if (m == null) continue;
                            try {
                                String sql = "INSERT INTO " + BanHandler.this.main.getTablePrefix() + "lastMessages (player, message, date) " + "VALUES (?, ?, FROM_UNIXTIME(" + m.getDate().getTime() / 1000L + "))";
                                PreparedStatement pst = BanHandler.this.main.getSQLConnection().prepareStatement(sql, 1);
                                pst.setString(1, p.getUniqueId().toString());
                                pst.setString(2, m.getMessage());
                                pst.execute();
                                ResultSet rs = pst.getGeneratedKeys();
                                if (!rs.next()) continue;
                                lastMessages = lastMessages + rs.getInt(1) + ";";
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                        }
                        if (lastMessages.length() > 0) {
                            lastMessages = lastMessages.substring(0, lastMessages.length() - 1);
                        }
                    }
                    String sqlIns = "INSERT INTO " + BanHandler.this.main.getTablePrefix() + "bans (player, reason, author, lastMessages) SELECT " + BanHandler.this.main.getTablePrefix() + "players.uuid, ?, '" + (sender instanceof ProxiedPlayer ? ((ProxiedPlayer)sender).getUniqueId() : "CONSOLE") + "', '" + lastMessages + "' FROM " + BanHandler.this.main.getTablePrefix() + "players WHERE LOWER(" + BanHandler.this.main.getTablePrefix() + "players.name) = '" + player.toLowerCase() + "'";
                    PreparedStatement pst = BanHandler.this.main.getSQLConnection().prepareStatement(sqlIns);
                    pst.setString(1, reason2);
                    pst.execute();
                    if (p != null) {
                        p.disconnect((BaseComponent)BanHandler.this.main.getMessageHandler().translateColorCodes(reason2));
                    }
                    BanHandler.this.main.getMessageHandler().sendMessageWithPermission(BanHandler.this.main.getMessageHandler().getMessage("ban.info").replace("%player%", p != null ? p.getName() : player).replace("%author%", sender.getName()).replace("%reason%", reason2), "proxysuite.messages.baninfo");
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void tempBanPlayer(final String player, final Date expiration, String reason, final CommandSender sender) {
        if (reason == null || reason.equals("")) {
            reason = this.main.getMessageHandler().getMessage("ban.temp.defaultreason").replace("%expiration%", this.main.getDateFormat().format(expiration));
        }
        final String reason2 = reason;
        this.main.getProxy().getScheduler().runAsync((Plugin)this.main, new Runnable(){

            public void run() {
                try {
                    ProxiedPlayer p = BanHandler.this.main.getPlayerHandler().getPlayer(player, sender, false);
                    String lastMessages = "";
                    if (p != null && BanHandler.this.main.getMessageHandler().getLastMessages().containsKey(p)) {
                        for (LoggedMessage m : BanHandler.this.main.getMessageHandler().getLastMessages().get(p)) {
                            if (m == null) continue;
                            try {
                                String sql = "INSERT INTO " + BanHandler.this.main.getTablePrefix() + "lastMessages (player, message, date) " + "VALUES (?, ?, FROM_UNIXTIME(" + m.getDate().getTime() / 1000L + "))";
                                PreparedStatement pst = BanHandler.this.main.getSQLConnection().prepareStatement(sql, 1);
                                pst.setString(1, p.getUniqueId().toString());
                                pst.setString(2, m.getMessage());
                                pst.execute();
                                ResultSet rs = pst.getGeneratedKeys();
                                if (!rs.next()) continue;
                                lastMessages = lastMessages + rs.getInt(1) + ";";
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                        }
                        if (lastMessages.length() > 0) {
                            lastMessages = lastMessages.substring(0, lastMessages.length() - 1);
                        }
                    }
                    String sqlIns = "INSERT INTO " + BanHandler.this.main.getTablePrefix() + "bans (player, reason, expiration, " + "author, lastMessages) SELECT " + BanHandler.this.main.getTablePrefix() + "players.uuid, ?, FROM_UNIXTIME(" + expiration.getTime() / 1000L + ")," + " '" + (sender instanceof ProxiedPlayer ? ((ProxiedPlayer)sender).getUniqueId() : "CONSOLE") + "', '" + lastMessages + "' FROM " + BanHandler.this.main.getTablePrefix() + "players WHERE LOWER(" + BanHandler.this.main.getTablePrefix() + "players.name) = '" + player.toLowerCase() + "'";
                    PreparedStatement pst = BanHandler.this.main.getSQLConnection().prepareStatement(sqlIns);
                    pst.setString(1, reason2);
                    pst.execute();
                    if (p != null) {
                        p.disconnect((BaseComponent)BanHandler.this.main.getMessageHandler().translateColorCodes(reason2));
                    }
                    BanHandler.this.main.getMessageHandler().sendMessageWithPermission(BanHandler.this.main.getMessageHandler().getMessage("ban.temp.info").replace("%player%", p != null ? p.getName() : player).replace("%expiration%", BanHandler.this.main.getDateFormat().format(expiration)).replace("%author%", sender.getName()).replace("%reason%", reason2), "proxysuite.messages.baninfo");
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void unban(final String player, final CommandSender sender, int banId) {
        final String sql = "UPDATE " + this.main.getTablePrefix() + "bans SET expiration = now() WHERE id = '" + banId + "'";
        this.main.getProxy().getScheduler().runAsync((Plugin)this.main, new Runnable(){

            public void run() {
                try {
                    BanHandler.this.main.getSQLConnection().createStatement().execute(sql);
                    BanHandler.this.main.getMessageHandler().sendMessageWithPermission(BanHandler.this.main.getMessageHandler().getMessage("unban.info").replace("%player%", player).replace("%author%", sender.getName()), "proxysuite.messages.unbaninfo");
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void unban(final String player, final Date expiration, final CommandSender sender, int banId) {
        final String sql = "UPDATE " + this.main.getTablePrefix() + "bans SET expiration = FROM_UNIXTIME(" + expiration.getTime() / 1000L + ") WHERE " + this.main.getTablePrefix() + "id = '" + banId + "'";
        this.main.getProxy().getScheduler().runAsync((Plugin)this.main, new Runnable(){

            public void run() {
                try {
                    BanHandler.this.main.getSQLConnection().createStatement().execute(sql);
                    BanHandler.this.main.getMessageHandler().sendMessageWithPermission(BanHandler.this.main.getMessageHandler().getMessage("unban.info.future").replace("%player%", player).replace("%expiration%", BanHandler.this.main.getDateFormat().format(expiration)).replace("%author%", sender.getName()), "proxysuite.messages.unbaninfo");
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public long getAddTime(String time) {
        long addtime = 0L;
        for (String s : time.split(";")) {
            if (s.toLowerCase().contains("s")) {
                s = s.toLowerCase().replace("s", "");
                addtime += (long)(Integer.parseInt(s) * 1000);
                continue;
            }
            if (s.toLowerCase().contains("m")) {
                s = s.toLowerCase().replace("m", "");
                addtime += (long)(Integer.parseInt(s) * 1000 * 60);
                continue;
            }
            if (s.toLowerCase().contains("h")) {
                s = s.toLowerCase().replace("h", "");
                addtime += (long)(Integer.parseInt(s) * 1000 * 60 * 60);
                continue;
            }
            if (!s.toLowerCase().contains("d")) continue;
            s = s.toLowerCase().replace("d", "");
            addtime += (long)(Integer.parseInt(s) * 1000 * 60 * 60 * 24);
        }
        return addtime;
    }
}

