/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite.handlers;

import de.sabbertran.proxysuite.ProxySuite;
import de.sabbertran.proxysuite.commands.FlyCommand;
import de.sabbertran.proxysuite.commands.ProxySuiteCommand;
import de.sabbertran.proxysuite.commands.SeenCommand;
import de.sabbertran.proxysuite.commands.VanishCommand;
import de.sabbertran.proxysuite.commands.ban.BanCommand;
import de.sabbertran.proxysuite.commands.ban.KickCommand;
import de.sabbertran.proxysuite.commands.ban.TempBanCommand;
import de.sabbertran.proxysuite.commands.ban.UnBanCommand;
import de.sabbertran.proxysuite.commands.gamemode.GamemodeCommand;
import de.sabbertran.proxysuite.commands.home.DelHomeCommand;
import de.sabbertran.proxysuite.commands.home.HomeCommand;
import de.sabbertran.proxysuite.commands.home.HomesCommand;
import de.sabbertran.proxysuite.commands.home.SetHomeCommand;
import de.sabbertran.proxysuite.commands.note.NoteCommand;
import de.sabbertran.proxysuite.commands.note.NoteInfoCommand;
import de.sabbertran.proxysuite.commands.note.NotesCommand;
import de.sabbertran.proxysuite.commands.portal.DelPortalCommand;
import de.sabbertran.proxysuite.commands.portal.PortalCommand;
import de.sabbertran.proxysuite.commands.portal.PortalsCommand;
import de.sabbertran.proxysuite.commands.portal.SetPortalCommand;
import de.sabbertran.proxysuite.commands.spawn.SetSpawnCommand;
import de.sabbertran.proxysuite.commands.spawn.SpawnCommand;
import de.sabbertran.proxysuite.commands.teleport.BackCommand;
import de.sabbertran.proxysuite.commands.teleport.TPACommand;
import de.sabbertran.proxysuite.commands.teleport.TPAHereCommand;
import de.sabbertran.proxysuite.commands.teleport.TPAcceptCommand;
import de.sabbertran.proxysuite.commands.teleport.TPCommand;
import de.sabbertran.proxysuite.commands.teleport.TPDenyCommand;
import de.sabbertran.proxysuite.commands.teleport.TPHereCommand;
import de.sabbertran.proxysuite.commands.warn.WarnCommand;
import de.sabbertran.proxysuite.commands.warn.WarningCommand;
import de.sabbertran.proxysuite.commands.warn.WarningsCommand;
import de.sabbertran.proxysuite.commands.warp.DelWarpCommand;
import de.sabbertran.proxysuite.commands.warp.SetWarpCommand;
import de.sabbertran.proxysuite.commands.warp.WarpCommand;
import de.sabbertran.proxysuite.commands.warp.WarpsCommand;
import de.sabbertran.proxysuite.utils.CheckedCommand;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandHandler {
    private ProxySuite main;
    private HashMap<ServerInfo, Boolean> worldGuardLoaded;
    private ArrayList<CheckedCommand> checkedCommands;

    public CommandHandler(ProxySuite main) {
        this.main = main;
        this.checkedCommands = new ArrayList();
    }

    public void registerCommands() {
        this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new ProxySuiteCommand(this.main));
        this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new SeenCommand(this.main));
        if (this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.Teleport")) {
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new TPCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new TPHereCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new TPACommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new TPAHereCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new TPDenyCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new TPAcceptCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new BackCommand(this.main));
        }
        if (this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.Warp")) {
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new WarpsCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new SetWarpCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new WarpCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new DelWarpCommand(this.main));
        }
        if (this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.Spawn")) {
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new SetSpawnCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new SpawnCommand(this.main));
        }
        if (this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.Home")) {
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new HomesCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new SetHomeCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new HomeCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new DelHomeCommand(this.main));
        }
        if (this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.BanKickWarn")) {
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new KickCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new TempBanCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new BanCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new UnBanCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new WarnCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new WarningCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new WarningsCommand(this.main));
        }
        if (this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.Note")) {
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new NoteCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new NoteInfoCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new NotesCommand(this.main));
        }
        if (this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.Portal")) {
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new PortalsCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new PortalCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new SetPortalCommand(this.main));
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new DelPortalCommand(this.main));
        }
        if (this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.Vanish")) {
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new VanishCommand(this.main));
        }
        if (this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.Fly")) {
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new FlyCommand(this.main));
        }
        if (this.main.getConfig().getBoolean("ProxySuite.ModulesEnabled.Gamemode")) {
            this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)new GamemodeCommand(this.main));
        }
    }

    public void executeCommand(final CommandSender sender, final String command, final Runnable runnable) {
        this.main.getProxy().getScheduler().runAsync((Plugin)this.main, new Runnable(){

            public void run() {
                boolean run = true;
                if (sender instanceof ProxiedPlayer) {
                    ProxiedPlayer p = (ProxiedPlayer)sender;
                    ByteArrayOutputStream b = new ByteArrayOutputStream();
                    DataOutputStream out = new DataOutputStream(b);
                    try {
                        out.writeUTF("CanExecuteCommand");
                        out.writeUTF(p.getName());
                        out.writeUTF(command);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    p.getServer().sendData("ProxySuite", b.toByteArray());
                    int count = 0;
                    while (CommandHandler.this.getCheckedCommand(p, command) == null && count < 100) {
                        try {
                            Thread.sleep(100L);
                            ++count;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (count != 100) {
                        CheckedCommand cc = CommandHandler.this.getCheckedCommand(p, command);
                        run = cc.canExecute();
                        CommandHandler.this.checkedCommands.remove(cc);
                    }
                }
                if (run) {
                    runnable.run();
                } else {
                    CommandHandler.this.main.getMessageHandler().sendMessage(sender, CommandHandler.this.main.getMessageHandler().getMessage("command.region.blocked"));
                }
            }
        });
    }

    private CheckedCommand getCheckedCommand(ProxiedPlayer player, String command) {
        for (CheckedCommand cc : this.checkedCommands) {
            if (cc.getPlayer() != player || !cc.getCommand().equals(command)) continue;
            return cc;
        }
        return null;
    }

    public void sendUsage(CommandSender sender, Command cmd) {
        if (cmd instanceof ProxySuiteCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.proxysuite"));
        } else if (cmd instanceof FlyCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.fly"));
        } else if (cmd instanceof SeenCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.seen"));
        } else if (cmd instanceof VanishCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.vanish"));
        } else if (cmd instanceof BanCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.ban"));
        } else if (cmd instanceof KickCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.kick"));
        } else if (cmd instanceof TempBanCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.tempban"));
        } else if (cmd instanceof UnBanCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.unban"));
        } else if (cmd instanceof GamemodeCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.gamemode"));
        } else if (cmd instanceof DelHomeCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.delhome"));
        } else if (cmd instanceof HomeCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.home"));
        } else if (cmd instanceof HomesCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.homes"));
        } else if (cmd instanceof SetHomeCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.sethome"));
        } else if (cmd instanceof NoteCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.note"));
        } else if (cmd instanceof NoteInfoCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.noteinfo"));
        } else if (cmd instanceof NotesCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.notes"));
        } else if (cmd instanceof DelPortalCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.delportal"));
        } else if (cmd instanceof PortalCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.portal"));
        } else if (cmd instanceof PortalsCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.portals"));
        } else if (cmd instanceof SetPortalCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.setportal"));
        } else if (cmd instanceof SetSpawnCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.setspawn"));
        } else if (cmd instanceof SpawnCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.spawn"));
        } else if (cmd instanceof BackCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.back"));
        } else if (cmd instanceof TPAcceptCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.tpaccept"));
        } else if (cmd instanceof TPACommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.tpa"));
        } else if (cmd instanceof TPAHereCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.tpahere"));
        } else if (cmd instanceof TPCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.tp"));
        } else if (cmd instanceof TPDenyCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.tpdeny"));
        } else if (cmd instanceof TPHereCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.tphere"));
        } else if (cmd instanceof WarnCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.warn"));
        } else if (cmd instanceof WarningCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.warning"));
        } else if (cmd instanceof WarningsCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.warnings"));
        } else if (cmd instanceof DelWarpCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.delwarp"));
        } else if (cmd instanceof SetWarpCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.setwarp"));
        } else if (cmd instanceof WarpCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.warp"));
        } else if (cmd instanceof WarpsCommand) {
            this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.usage.warps"));
        }
    }

    public ArrayList<CheckedCommand> getCheckedCommands() {
        return this.checkedCommands;
    }
}

